/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;

public class RecordedDvDateTime {
    private DvDateTime dateTime;

    public RecordedDvDateTime() {
    }

    public RecordedDvDateTime(DvDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public Timestamp toTimestamp() {
        TemporalAccessor temporal = this.dateTime.getValue();
        return Timestamp.valueOf(LocalDateTime.from(temporal));
    }

    public Optional<String> zoneId() {
        TemporalAccessor accessor = this.dateTime.getValue();
        if (accessor instanceof OffsetDateTime) {
            ZoneOffset offset = ((OffsetDateTime)accessor).getOffset();
            return Optional.of(offset.getId());
        }
        return Optional.empty();
    }

    public DvDateTime decodeDvDateTime(Timestamp timestamp, String timezone) {
        if (timestamp == null) {
            return null;
        }
        Comparable<ChronoLocalDateTime<?>> temporal = timezone != null ? timestamp.toLocalDateTime().atOffset(ZoneOffset.of(timezone)) : timestamp.toLocalDateTime();
        return new DvDateTime((TemporalAccessor)((Object)temporal));
    }
}

