/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.repository.SystemRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service
public class SystemService {
    private final SystemRepository systemRepository;
    private final ServerConfig serverConfig;
    private final Logger logger = LoggerFactory.getLogger(SystemService.class);
    private UUID systemId;

    public SystemService(SystemRepository systemRepository, ServerConfig serverConfig) {
        this.systemRepository = systemRepository;
        this.serverConfig = serverConfig;
    }

    @PostConstruct
    private void init() {
        Optional<UUID> uuid = this.systemRepository.findSystemId(this.serverConfig.getNodename());
        if (uuid.isEmpty()) {
            try {
                this.systemRepository.commit(this.systemRepository.toRecord(this.serverConfig.getNodename(), "DEFAULT RUNNING SYSTEM"));
            }
            catch (DataIntegrityViolationException ex) {
                this.logger.info(ex.getMessage(), (Throwable)ex);
            }
            uuid = this.systemRepository.findSystemId(this.serverConfig.getNodename());
        }
        this.systemId = uuid.orElseThrow(() -> new InternalServerException("Can not fetch System Id"));
    }

    public UUID getSystemUuid() {
        return this.systemId;
    }
}

