/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.composition.Composition;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlOptions;
import org.ehrbase.api.definitions.OperationalTemplateFormat;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.openehr.sdk.examplegenerator.ExampleGeneratorConfig;
import org.ehrbase.openehr.sdk.examplegenerator.ExampleGeneratorToCompositionWalker;
import org.ehrbase.openehr.sdk.generator.commons.shareddefinition.Language;
import org.ehrbase.openehr.sdk.generator.commons.shareddefinition.Setting;
import org.ehrbase.openehr.sdk.generator.commons.shareddefinition.Territory;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.TemplateMetaDataDto;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValuePath;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.webtemplateskeletonbuilder.WebTemplateSkeletonBuilder;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.openehr.schemas.v1.CARCHETYPEROOT;
import org.openehr.schemas.v1.OBJECTID;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TemplateServiceImp
extends BaseServiceImp
implements TemplateService {
    private final KnowledgeCacheService knowledgeCacheService;
    private final CompositionService compositionService;
    private final TenantService tenantService;

    public TemplateServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig, CompositionService compositionService, TenantService tenantService) {
        super(knowledgeCacheService, context, serverConfig);
        this.knowledgeCacheService = Objects.requireNonNull(knowledgeCacheService);
        this.compositionService = compositionService;
        this.tenantService = tenantService;
    }

    public List<TemplateMetaDataDto> getAllTemplates() {
        return this.knowledgeCacheService.listAllOperationalTemplates().stream().map(this::mapToDto).collect(Collectors.toList());
    }

    private TemplateMetaDataDto mapToDto(TemplateMetaData data) {
        TemplateMetaDataDto dto = new TemplateMetaDataDto();
        dto.setCreatedOn(data.getCreatedOn());
        Optional<OPERATIONALTEMPLATE> operationalTemplate = Optional.ofNullable(data.getOperationaltemplate());
        dto.setTemplateId((String)operationalTemplate.map(OPERATIONALTEMPLATE::getTemplateId).map(OBJECTID::getValue).orElse(null));
        dto.setArchetypeId((String)operationalTemplate.map(OPERATIONALTEMPLATE::getDefinition).map(CARCHETYPEROOT::getArchetypeId).map(OBJECTID::getValue).orElse(null));
        dto.setConcept((String)operationalTemplate.map(OPERATIONALTEMPLATE::getConcept).orElse(null));
        return dto;
    }

    public Composition buildExample(String templateId) {
        WebTemplate webTemplate = this.findTemplate(templateId);
        Composition composition = WebTemplateSkeletonBuilder.build((WebTemplate)webTemplate, (boolean)false);
        ExampleGeneratorConfig object = new ExampleGeneratorConfig();
        DefaultValues defaultValues = new DefaultValues();
        defaultValues.addDefaultValue(DefaultValuePath.TIME, (Object)OffsetDateTime.now());
        defaultValues.addDefaultValue(DefaultValuePath.LANGUAGE, (Object)((Language)FlatHelper.findEnumValueOrThrow((String)webTemplate.getDefaultLanguage(), Language.class)));
        defaultValues.addDefaultValue(DefaultValuePath.TERRITORY, (Object)Territory.DE);
        defaultValues.addDefaultValue(DefaultValuePath.SETTING, (Object)Setting.OTHER_CARE);
        defaultValues.addDefaultValue(DefaultValuePath.COMPOSER_NAME, (Object)"Max Mustermann");
        ExampleGeneratorToCompositionWalker walker = new ExampleGeneratorToCompositionWalker();
        walker.walk(composition, (Object)object, webTemplate, defaultValues, templateId);
        composition.setTerritory(Territory.DE.toCodePhrase());
        return composition;
    }

    public WebTemplate findTemplate(String templateId) {
        try {
            return this.knowledgeCacheService.getQueryOptMetaData(templateId);
        }
        catch (NullPointerException e) {
            throw new ObjectNotFoundException("template", "Template with the specified id does not exist", (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalServerException("Could not generate web template", (Throwable)e);
        }
    }

    public String findOperationalTemplate(String templateId, OperationalTemplateFormat format) throws ObjectNotFoundException, InvalidApiParameterException, InternalServerException {
        if (format != OperationalTemplateFormat.XML) {
            throw new InvalidApiParameterException("Requested operational template type not supported");
        }
        Optional<OPERATIONALTEMPLATE> existingTemplate = this.knowledgeCacheService.retrieveOperationalTemplate(templateId);
        return existingTemplate.map(template -> {
            XmlOptions opts = new XmlOptions();
            opts.setSaveSyntheticDocumentElement(new QName("http://schemas.openehr.org/v1", "template"));
            return template.xmlText(opts);
        }).orElseThrow(() -> new ObjectNotFoundException("template", "Template with the specified id does not exist"));
    }

    public String create(OPERATIONALTEMPLATE content) {
        return this.knowledgeCacheService.addOperationalTemplate(content);
    }

    public boolean adminDeleteTemplate(String templateId) {
        Optional<OPERATIONALTEMPLATE> existingTemplate = this.knowledgeCacheService.retrieveOperationalTemplate(templateId);
        if (existingTemplate.isEmpty()) {
            throw new ObjectNotFoundException("ADMIN TEMPLATE", String.format("Operational template with id %s not found.", templateId));
        }
        return this.knowledgeCacheService.deleteOperationalTemplate(existingTemplate.get());
    }

    public String adminUpdateTemplate(String templateId, String content) {
        String string;
        block9: {
            Optional<OPERATIONALTEMPLATE> existingTemplate = this.knowledgeCacheService.retrieveOperationalTemplate(templateId);
            if (existingTemplate.isEmpty()) {
                throw new ObjectNotFoundException("ADMIN TEMPLATE UPDATE", String.format("Template with id %s does not exist", templateId));
            }
            InputStream in = IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8);
            try {
                string = this.knowledgeCacheService.adminUpdateOperationalTemplate(in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InternalServerException(e.getMessage(), (Throwable)e);
                }
            }
            in.close();
        }
        return string;
    }

    public int adminDeleteAllTemplates() {
        return this.knowledgeCacheService.deleteAllOperationalTemplates();
    }
}

