/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.api.tenant.Tenant;
import org.ehrbase.api.tenant.TenantAuthentication;
import org.ehrbase.dao.access.interfaces.I_TenantAccess;
import org.ehrbase.dao.access.jooq.TenantAccess;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.tenant.DefaultTenantAuthentication;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TenantServiceImp
extends BaseServiceImp
implements TenantService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ERR_GETTING_TENANT = "Could not find tenant %s in cache";
    private static final String WARN_NOT_TENANT_ID = "No tenant identifier provided, falling back to default tenant identifier {}";
    private static final String ERR_DELETE_TENANT_ID = "Deleting tenant id[%s] is not allowed";
    private final Cache sysTenantCache;

    public TenantServiceImp(@Lazy KnowledgeCacheService knowledgeCacheService, CacheManager cacheManager, DSLContext context, ServerConfig serverConfig) {
        super(knowledgeCacheService, context, serverConfig);
        this.sysTenantCache = cacheManager.getCache("sysTenant");
    }

    @PostConstruct
    void init() {
        TenantAccess.getSysTenants(this.getDataAccess().getContext()).forEach((arg_0, arg_1) -> ((Cache)this.sysTenantCache).put(arg_0, arg_1));
    }

    public Short getCurrentSysTenant() {
        return this.retrieveFromCache(this.getCurrentTenantIdentifier());
    }

    public Short getSysTenantByTenantId(String tenantId) {
        return this.retrieveFromCache(tenantId);
    }

    private Short retrieveFromCache(String tenantId) {
        return Optional.ofNullable(tenantId).map(arg_0 -> ((Cache)this.sysTenantCache).get(arg_0)).map(Cache.ValueWrapper::get).map(Short.class::cast).orElseThrow(() -> new IllegalArgumentException(String.format(ERR_GETTING_TENANT, tenantId)));
    }

    public String getCurrentTenantIdentifier() {
        return Optional.ofNullable(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).filter(DefaultTenantAuthentication.class::isInstance).map(DefaultTenantAuthentication.class::cast).map(DefaultTenantAuthentication::getTenantId).filter(StringUtils::isNotEmpty).orElseGet(() -> {
            this.log.trace(WARN_NOT_TENANT_ID, (Object)TenantAuthentication.getDefaultTenantId());
            return TenantAuthentication.getDefaultTenantId();
        });
    }

    public String create(Tenant tenant) {
        I_TenantAccess tenantAccess = I_TenantAccess.getNewInstance(this.getDataAccess().getContext(), tenant);
        Short sysTenant = tenantAccess.commit();
        this.sysTenantCache.put((Object)tenant.getTenantId(), (Object)sysTenant);
        return tenant.getTenantId();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void deleteTenant(String tenantId) {
        if ("1f332a66-0e57-11ed-861d-0242ac120002".equals(tenantId)) {
            throw new IllegalArgumentException(String.format("Not allowed to delete default tenant with id %s.", tenantId));
        }
        if (!this.hasTenant(tenantId)) {
            throw new ObjectNotFoundException("Tenant", String.format("Tenant with id %s does not exist.", tenantId));
        }
        I_TenantAccess.deleteTenant(this.getDataAccess().getContext(), tenantId);
        this.sysTenantCache.evict((Object)tenantId);
    }

    public List<Tenant> getAll() {
        return I_TenantAccess.getAll(this.getDataAccess().getContext()).stream().map(I_TenantAccess::convert).collect(Collectors.toList());
    }

    public Optional<Tenant> findBy(String tenantId) {
        return Optional.ofNullable(I_TenantAccess.retrieveInstanceBy(this.getDataAccess().getContext(), tenantId)).map(I_TenantAccess::convert);
    }

    public Tenant update(Tenant tenant) {
        return I_TenantAccess.retrieveInstanceBy(this.getDataAccess().getContext(), tenant.getTenantId()).update(tenant);
    }

    public boolean hasTenant(String tenantId) {
        return I_TenantAccess.hasTenant(this.getDataAccess(), tenantId);
    }
}

