/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.ehrbase.openehr.sdk.terminology.openehr.CodeSetAccess;
import org.ehrbase.openehr.sdk.terminology.openehr.OpenEHRCodeSetIdentifiers;
import org.ehrbase.openehr.sdk.terminology.openehr.TerminologyAccess;
import org.ehrbase.openehr.sdk.terminology.openehr.TerminologyService;
import org.ehrbase.openehr.sdk.terminology.openehr.implementation.AttributeCodesetMapping;
import org.ehrbase.openehr.sdk.terminology.openehr.implementation.LocalizedTerminologies;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TerminologyServiceImp
implements TerminologyService {
    private static TerminologyServiceImp instance;
    private LocalizedTerminologies localizedTerminologies = new LocalizedTerminologies();

    @Autowired
    public TerminologyServiceImp() throws Exception {
    }

    public static TerminologyServiceImp getInstance() {
        return instance;
    }

    @PostConstruct
    public void init() {
        instance = this;
    }

    public TerminologyAccess terminology(String name) {
        return this.localizedTerminologies.getDefault().terminology(name);
    }

    public TerminologyAccess terminology(String name, String language) {
        return this.localizedTerminologies.locale(language).terminology(name);
    }

    public CodeSetAccess codeSet(String name) {
        return this.localizedTerminologies.getDefault().codeSet(name);
    }

    public CodeSetAccess codeSet(String name, String language) {
        return this.localizedTerminologies.locale(language).codeSet(name);
    }

    public CodeSetAccess codeSetForId(String name) {
        return this.localizedTerminologies.getDefault().codeSetForId(OpenEHRCodeSetIdentifiers.valueOf((String)name));
    }

    public CodeSetAccess codeSetForId(String name, String language) {
        return this.localizedTerminologies.locale(language).codeSetForId(OpenEHRCodeSetIdentifiers.valueOf((String)name));
    }

    public Boolean hasTerminology(String name) {
        return this.localizedTerminologies.getDefault().hasTerminology(name);
    }

    public Boolean hasTerminology(String name, String language) {
        return this.localizedTerminologies.locale(language).hasTerminology(name);
    }

    public Boolean hasCodeSet(String name) {
        return this.localizedTerminologies.getDefault().hasCodeSet(name);
    }

    public Boolean hasCodeSet(String name, String language) {
        return this.localizedTerminologies.locale(language).hasCodeSet(name);
    }

    public String[] terminologyIdentifiers() {
        return this.localizedTerminologies.getDefault().terminologyIdentifiers().toArray(new String[0]);
    }

    public String[] terminologyIdentifiers(String language) {
        return this.localizedTerminologies.locale(language).terminologyIdentifiers().toArray(new String[0]);
    }

    public Map<String, String> openehrCodeSets() {
        return this.localizedTerminologies.getDefault().openehrCodeSets();
    }

    public Map<String, String> openehrCodeSets(String language) {
        return this.localizedTerminologies.locale(language).openehrCodeSets();
    }

    public String[] codeSetIdentifiers() {
        return this.localizedTerminologies.getDefault().codeSetIdentifiers().toArray(new String[0]);
    }

    public String[] codeSetIdentifiers(String language) {
        return this.localizedTerminologies.locale(language).codeSetIdentifiers().toArray(new String[0]);
    }

    public String getLabelForCode(String code, String language) {
        return this.localizedTerminologies.locale(language).terminology("openehr").rubricForCode(code, language);
    }

    public AttributeCodesetMapping codesetMapping() {
        return this.localizedTerminologies.codesetMapping();
    }

    public LocalizedTerminologies localizedTerminologies() {
        return this.localizedTerminologies;
    }
}

