/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.containment;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ehrbase.aql.containment.Containment;
import org.ehrbase.aql.containment.ContainmentSet;
import org.ehrbase.aql.containment.JsonPathQueryBuilder;
import org.ehrbase.aql.containment.JsonPathQueryResult;
import org.ehrbase.aql.containment.Templates;
import org.ehrbase.openehr.sdk.webtemplate.parser.NodeId;
import org.ehrbase.service.KnowledgeCacheService;

public class Containments {
    private Set<Object> containmentSet;
    private KnowledgeCacheService knowledgeCacheService;

    public Containments(KnowledgeCacheService knowledgeCacheService, ContainmentSet containmentSet) {
        this.knowledgeCacheService = knowledgeCacheService;
        this.containmentSet = containmentSet.getContainmentList();
    }

    public boolean hasUnresolvedContainment(String templateId) {
        for (Object containment : this.containmentSet) {
            if (!(containment instanceof Containment) || ((Containment)containment).getPath(templateId) != null) continue;
            return true;
        }
        return false;
    }

    public void resolveContainers(String templateId) {
        ArrayList<Object> containmentList = new ArrayList<Object>();
        containmentList.addAll(this.containmentSet);
        for (int i = 0; i < containmentList.size(); ++i) {
            List<Object> sublist;
            List<NodeId> jsonQuery;
            JsonPathQueryResult jsonPathQueryResult;
            Containment containment;
            if (!(containmentList.get(i) instanceof Containment) || (containment = (Containment)containmentList.get(i)).getClassName().equals("COMPOSITION") && containment.getArchetypeId() == null || containment.getPath(templateId) != null || (jsonPathQueryResult = new Templates(this.knowledgeCacheService).resolveForTemplate(templateId, jsonQuery = new JsonPathQueryBuilder(sublist = containmentList.subList(i, containmentList.size())).assemble())) == null) continue;
            containment.setPath(templateId, jsonPathQueryResult.getAqlPath());
        }
    }
}

