/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.List;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.queryimpl.DefaultColumnId;
import org.ehrbase.ehr.util.LocatableHelper;
import org.jooq.Field;
import org.jooq.impl.DSL;

public class FieldConstantHandler {
    private final I_VariableDefinition variableDefinition;

    public FieldConstantHandler(I_VariableDefinition variableDefinition) {
        this.variableDefinition = variableDefinition;
    }

    public boolean isConstant() {
        if (this.variableDefinition.getPath() == null || this.variableDefinition.getPath().toUpperCase().startsWith("EHR_STATUS")) {
            return false;
        }
        List<String> segments = LocatableHelper.dividePathIntoSegments(this.variableDefinition.getPath());
        return segments.size() >= 2 && segments.get(segments.size() - 1).equals("archetype_node_id");
    }

    public Field<?> field() {
        List<String> segments = LocatableHelper.dividePathIntoSegments(this.variableDefinition.getPath());
        if (segments.get(segments.size() - 1).equals("archetype_node_id")) {
            return DSL.inline((String)this.implicitArchetypeNodeId(segments.get(segments.size() - 2))).as(this.alias());
        }
        return null;
    }

    private String implicitArchetypeNodeId(String nodeId) {
        if (nodeId.equals("other_context")) {
            return "at0001";
        }
        return nodeId.substring(nodeId.indexOf("[") + 1, nodeId.lastIndexOf("]"));
    }

    String alias() {
        String alias = this.variableDefinition.getAlias();
        if (alias == null) {
            alias = DefaultColumnId.value(this.variableDefinition);
        }
        return alias;
    }
}

