/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.List;
import org.ehrbase.aql.definition.CastFunctionDefinition;
import org.ehrbase.aql.definition.FuncParameter;
import org.ehrbase.aql.definition.FuncParameterType;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.binding.OrderByBinder;
import org.ehrbase.aql.sql.binding.VariableDefinitions;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.SelectQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class FunctionExpression {
    private final I_VariableDefinition functionDefinition;
    private final SelectQuery<?> query;
    private final VariableDefinitions variables;

    FunctionExpression(VariableDefinitions variables, I_VariableDefinition functionDefinition, SelectQuery<?> query) {
        this.variables = variables;
        this.functionDefinition = functionDefinition;
        this.query = query;
    }

    public Field<?> buildField() {
        I_VariableDefinition i_VariableDefinition = this.functionDefinition;
        if (i_VariableDefinition instanceof CastFunctionDefinition) {
            CastFunctionDefinition castFunctionDefinition = (CastFunctionDefinition)i_VariableDefinition;
            return this.to(castFunctionDefinition.getCastee()).cast(this.getType(castFunctionDefinition.getTargetType()));
        }
        if (this.isAggregateDistinct()) {
            return DSL.aggregateDistinct((String)this.functionDefinition.getIdentifier(), Object.class, (Field[])((Field[])this.functionDefinition.getFuncParameters().stream().filter(funcParameter -> !funcParameter.isIdentifier()).map(this::to).toArray(Field[]::new)));
        }
        return DSL.function((String)this.functionDefinition.getIdentifier(), Object.class, (Field[])((Field[])this.functionDefinition.getFuncParameters().stream().filter(funcParameter -> !funcParameter.isIdentifier()).map(this::to).toArray(Field[]::new)));
    }

    private DataType<?> getType(String as) {
        return switch (as.toUpperCase()) {
            case "DATE" -> SQLDataType.DATE;
            case "TIME" -> SQLDataType.TIME;
            case "INTERVAL" -> SQLDataType.INTERVAL;
            case "TIMESTAMP" -> SQLDataType.TIMESTAMP;
            case "NUMERIC" -> SQLDataType.NUMERIC;
            default -> SQLDataType.VARCHAR;
        };
    }

    private boolean isAggregateDistinct() {
        return this.functionDefinition.getFuncParameters().stream().filter(FuncParameter::isVariable).anyMatch(f -> this.variables.isDistinct(f.getValue().toString()));
    }

    private Field<?> to(FuncParameter funcParameter) {
        return switch (funcParameter.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case FuncParameterType.VARIABLE -> OrderByBinder.find(this.query, funcParameter.getValue().toString());
            case FuncParameterType.OPERAND -> DSL.inline((Object)funcParameter.getValue());
            case FuncParameterType.IDENTIFIER -> throw new UnsupportedOperationException(funcParameter.getType().toString());
            case FuncParameterType.FUNCTION -> new FunctionExpression(this.variables, (I_VariableDefinition)funcParameter.getValue(), this.query).buildField();
        };
    }

    List<String> arguments() {
        ArrayList<String> args = new ArrayList<String>();
        for (FuncParameter parameter : this.functionDefinition.getFuncParameters()) {
            if (parameter.isVariable()) {
                args.add(parameter.getValue().toString());
            }
            if (!parameter.getType().equals((Object)FuncParameterType.FUNCTION)) continue;
            args.addAll(new FunctionExpression(this.variables, (I_VariableDefinition)parameter.getValue(), this.query).arguments());
        }
        return args;
    }
}

