/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.ehrbase.aql.sql.binding.IJoinBinder;
import org.ehrbase.aql.sql.queryimpl.attribute.JoinSetup;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.CompositionRecord;
import org.ehrbase.jooq.pg.tables.records.EhrRecord;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.ehrbase.jooq.pg.tables.records.StatusRecord;
import org.ehrbase.jooq.pg.tables.records.SystemRecord;
import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.jooq.TableLike;

public class JoinBinder
implements IJoinBinder {
    public static final String COMPOSITION_JOIN = "composition_join";
    public static final Table<CompositionRecord> compositionRecordTable = Tables.COMPOSITION.as("composition_join");
    public static final String SYSTEM_JOIN = "system_join";
    public static final Table<SystemRecord> systemRecordTable = Tables.SYSTEM.as("system_join");
    public static final String STATUS_JOIN = "status_join";
    public static final Table<StatusRecord> statusRecordTable = Tables.STATUS.as("status_join");
    public static final String EHR_JOIN = "ehr_join";
    public static final Table<EhrRecord> ehrRecordTable = Tables.EHR_.as("ehr_join");
    public static final Table<PartyIdentifiedRecord> composerRef = Tables.PARTY_IDENTIFIED.as("composer_ref");
    public static final Table<PartyIdentifiedRecord> subjectRef = Tables.PARTY_IDENTIFIED.as("subject_ref");
    public static final Table<PartyIdentifiedRecord> facilityRef = Tables.PARTY_IDENTIFIED.as("facility_ref");
    private boolean compositionJoined = false;
    private boolean statusJoined = false;
    private boolean subjectJoin = false;
    private boolean eventContextJoined = false;
    private boolean facilityJoined = false;
    private boolean composerJoined = false;
    private boolean ehrJoined = false;
    private boolean systemJoined = false;
    private final I_DomainAccess domainAccess;
    private final JoinSetup joinSetup;

    public JoinBinder(I_DomainAccess domainAccess, JoinSetup joinSetup) {
        this.domainAccess = domainAccess;
        this.joinSetup = joinSetup;
    }

    public SelectQuery<?> addJoinClause(SelectQuery<?> selectQuery) {
        if (this.joinSetup == null) {
            return selectQuery;
        }
        if (!this.joinSetup.isUseEntry() && this.noJoinRequired(this.joinSetup)) {
            selectQuery = this.simpleFromClause(selectQuery, this.joinSetup);
        } else {
            if (this.joinSetup.isJoinSubject()) {
                this.joinSubject(selectQuery, this.joinSetup);
            }
            if (this.joinSetup.isJoinComposition()) {
                this.joinComposition(selectQuery);
            }
            if (this.joinSetup.isJoinEventContext()) {
                this.joinEventContext(selectQuery);
            }
            if (this.joinSetup.isJoinContextFacility()) {
                this.joinContextFacility(selectQuery);
            }
            if (this.joinSetup.isJoinComposer()) {
                this.joinComposer(selectQuery);
            }
            if (this.joinSetup.isJoinEhr()) {
                this.joinEhr(selectQuery);
            }
            if (this.joinSetup.isJoinSystem()) {
                this.joinSystem(selectQuery);
            }
            if (this.joinSetup.isJoinEhrStatus()) {
                this.joinEhrStatus(selectQuery, this.joinSetup);
            }
        }
        return selectQuery;
    }

    private boolean noJoinRequired(JoinSetup joinSetup) {
        return (joinSetup.isJoinComposer() ? 2 : 0) + (joinSetup.isJoinEventContext() ? 1 : 0) + (joinSetup.isJoinComposition() ? 2 : 0) + (joinSetup.isJoinContextFacility() ? 2 : 0) + (joinSetup.isJoinEhr() ? 1 : 0) + (joinSetup.isJoinEhrStatus() ? 2 : 0) + (joinSetup.isJoinSubject() ? 2 : 0) + (joinSetup.isJoinSystem() ? 1 : 0) == 1;
    }

    public Table initialFrom() {
        if (this.joinSetup.isUseEntry()) {
            return Tables.ENTRY;
        }
        if (this.joinSetup.isJoinEhrStatus() || this.joinSetup.isJoinSubject()) {
            this.joinSetup.setJoinEhr(false);
            return Tables.EHR_.as(EHR_JOIN);
        }
        return Tables.ENTRY;
    }

    private SelectQuery<?> simpleFromClause(SelectQuery<?> selectQuery, JoinSetup joinSetup) {
        List selectFields = selectQuery.getSelect();
        SelectQuery selectQuery1 = this.domainAccess.getContext().selectQuery();
        selectQuery1.addSelect((Collection)selectFields);
        if (joinSetup.isJoinEhr()) {
            selectQuery1.addFrom((TableLike)Tables.EHR_.as(EHR_JOIN));
        } else if (joinSetup.isJoinComposition()) {
            selectQuery1.addFrom((TableLike)Tables.COMPOSITION.as(COMPOSITION_JOIN));
        } else if (joinSetup.isJoinSystem()) {
            selectQuery1.addFrom((TableLike)Tables.SYSTEM.as(SYSTEM_JOIN));
        }
        return selectQuery1;
    }

    private void joinComposition(SelectQuery<?> selectQuery) {
        if (this.compositionJoined) {
            return;
        }
        selectQuery.addJoin(compositionRecordTable, JoinType.RIGHT_OUTER_JOIN, compositionRecordTable.field((Field)Tables.COMPOSITION.ID).eq((Field)Tables.ENTRY.COMPOSITION_ID));
        this.compositionJoined = true;
    }

    private void joinSystem(SelectQuery<?> selectQuery) {
        if (this.systemJoined) {
            return;
        }
        selectQuery.addJoin(systemRecordTable, JoinType.JOIN, systemRecordTable.field((Field)Tables.SYSTEM.ID).eq(ehrRecordTable.field(Tables.EHR_.SYSTEM_ID.getName(), UUID.class)));
        this.systemJoined = true;
    }

    private void joinEhrStatus(SelectQuery<?> selectQuery, JoinSetup joinSetup) {
        if (this.statusJoined) {
            return;
        }
        if (joinSetup.isJoinComposition() || joinSetup.isUseEntry()) {
            this.joinComposition(selectQuery);
            selectQuery.addJoin(statusRecordTable, statusRecordTable.field(Tables.STATUS.EHR_ID.getName(), UUID.class).eq(compositionRecordTable.field(Tables.COMPOSITION.EHR_ID.getName(), UUID.class)));
            this.statusJoined = true;
        } else {
            if (joinSetup.isJoinEhr()) {
                this.joinEhr(selectQuery);
            }
            selectQuery.addJoin(statusRecordTable, statusRecordTable.field(Tables.STATUS.EHR_ID.getName(), UUID.class).eq(ehrRecordTable.field(Tables.EHR_.ID.getName(), UUID.class)));
            this.statusJoined = true;
        }
    }

    private void joinSubject(SelectQuery<?> selectQuery, JoinSetup joinSetup) {
        if (this.subjectJoin) {
            return;
        }
        this.joinEhrStatus(selectQuery, joinSetup);
        Table<PartyIdentifiedRecord> subjectTable = subjectRef;
        selectQuery.addJoin(subjectTable, subjectTable.field(Tables.PARTY_IDENTIFIED.ID.getName(), UUID.class).eq(statusRecordTable.field(Tables.STATUS.PARTY.getName(), UUID.class)));
        this.subjectJoin = true;
    }

    private void joinEventContext(SelectQuery<?> selectQuery) {
        if (this.eventContextJoined) {
            return;
        }
        selectQuery.addJoin((TableLike)Tables.EVENT_CONTEXT, Tables.EVENT_CONTEXT.COMPOSITION_ID.eq((Field)Tables.ENTRY.COMPOSITION_ID));
        this.eventContextJoined = true;
    }

    private void joinContextFacility(SelectQuery<?> selectQuery) {
        if (this.facilityJoined) {
            return;
        }
        this.joinEventContext(selectQuery);
        Table<PartyIdentifiedRecord> facilityTable = facilityRef;
        selectQuery.addJoin(facilityTable, JoinType.LEFT_OUTER_JOIN, Tables.EVENT_CONTEXT.FACILITY.eq(facilityTable.field(Tables.PARTY_IDENTIFIED.ID.getName(), UUID.class)));
        this.facilityJoined = true;
    }

    private void joinComposer(SelectQuery<?> selectQuery) {
        if (this.composerJoined) {
            return;
        }
        this.joinComposition(selectQuery);
        Table<PartyIdentifiedRecord> composerTable = composerRef;
        selectQuery.addJoin(composerTable, compositionRecordTable.field(Tables.COMPOSITION.COMPOSER.getName(), UUID.class).eq(composerTable.field(Tables.PARTY_IDENTIFIED.ID.getName(), UUID.class)));
        this.composerJoined = true;
    }

    private void joinEhr(SelectQuery<?> selectQuery) {
        if (this.ehrJoined) {
            return;
        }
        this.joinComposition(selectQuery);
        selectQuery.addJoin(ehrRecordTable, JoinType.RIGHT_OUTER_JOIN, ehrRecordTable.field(Tables.EHR_.ID.getName(), UUID.class).eq(compositionRecordTable.field(Tables.COMPOSITION.EHR_ID.getName(), UUID.class)));
        this.ehrJoined = true;
    }
}

