/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.compiler.OrderAttribute;
import org.ehrbase.aql.definition.FuncParameter;
import org.ehrbase.aql.definition.FunctionDefinition;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.Variables;
import org.ehrbase.aql.sql.binding.FunctionExpression;
import org.ehrbase.aql.sql.binding.OrderByBinder;
import org.ehrbase.aql.sql.binding.VariableDefinitions;
import org.ehrbase.aql.sql.queryimpl.DefaultColumnId;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.SelectQuery;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperQuery {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DSLContext context;
    private final VariableDefinitions variableDefinitions;
    private final SelectQuery<?> query;
    private boolean outputWithJson;

    public SuperQuery(I_DomainAccess domainAccess, VariableDefinitions variableDefinitions, SelectQuery<?> query, boolean containsJson) {
        this.context = domainAccess.getContext();
        this.variableDefinitions = variableDefinitions;
        this.query = query;
        this.outputWithJson = containsJson;
    }

    private List<Field<?>> selectDistinctFields() {
        ArrayList fields = new ArrayList();
        Iterator<I_VariableDefinition> iterator = this.variableDefinitions.iterator();
        if (!this.variableDefinitions.hasDistinctOperator()) {
            return fields;
        }
        while (iterator.hasNext()) {
            I_VariableDefinition variableDefinition = iterator.next();
            if (variableDefinition instanceof FunctionDefinition) {
                StringBuilder stringBuilder = new StringBuilder();
                for (FuncParameter funcParameter : variableDefinition.getFuncParameters()) {
                    stringBuilder.append(funcParameter.getValue());
                }
                fields.add(DSL.field((Name)DSL.name((String)stringBuilder.toString())));
                continue;
            }
            if (variableDefinition.getAlias() == null || variableDefinition.getAlias().isEmpty()) {
                fields.add(DSL.field((Name)DSL.name((String)DefaultColumnId.value(variableDefinition))));
                continue;
            }
            fields.add(DSL.field((Name)DSL.name((String)variableDefinition.getAlias())));
        }
        return fields;
    }

    private SelectQuery<Record> selectDistinct(SelectQuery<Record> selectQuery) {
        List<Field<?>> fields = this.selectDistinctFields();
        selectQuery.addDistinctOn(fields);
        selectQuery.addFrom(this.query);
        return selectQuery;
    }

    private SelectQuery<Record> selectAggregate(SelectQuery<Record> selectQuery) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<String> skipField = new ArrayList<String>();
        Iterator<I_VariableDefinition> iterator = this.variableDefinitions.iterator();
        boolean distinctRequired = false;
        while (iterator.hasNext()) {
            I_VariableDefinition variableDefinition = iterator.next();
            String alias = this.getAlias(variableDefinition);
            if (variableDefinition.isFunction()) {
                skipField.add(alias);
                FunctionExpression functionExpression = new FunctionExpression(this.variableDefinitions, variableDefinition, this.query);
                Field field = functionExpression.buildField();
                skipField.addAll(functionExpression.arguments());
                if (variableDefinition.getAlias() != null) {
                    field = field.as(alias);
                }
                fields.add(field);
                continue;
            }
            if (variableDefinition.isExtension()) {
                this.log.debug("Not yet implemented");
                continue;
            }
            boolean bl = distinctRequired = distinctRequired || variableDefinition.isDistinct();
            if (skipField.contains(alias)) continue;
            if (variableDefinition.isDistinct()) {
                fields.add(DSL.field((Name)DSL.name((String)("DISTINCT " + alias))));
                continue;
            }
            fields.add(DSL.field((Name)DSL.name((String)alias)));
        }
        selectQuery.addSelect(fields);
        selectQuery.addFrom(this.query);
        this.outputWithJson = false;
        return selectQuery;
    }

    public SelectQuery<Record> selectOrderBy(List<OrderAttribute> orderAttributes) {
        SelectQuery<Record> selectQuery = this.context.selectQuery();
        selectQuery.addFrom(this.query);
        selectQuery = this.setOrderBy(orderAttributes, selectQuery);
        return selectQuery;
    }

    public SelectQuery<Record> setOrderBy(List<OrderAttribute> orderAttributes, SelectQuery<Record> selectQuery) {
        return new OrderByBinder(this.variableDefinitions, orderAttributes, selectQuery).bind();
    }

    public SelectQuery<Record> select() {
        SelectQuery selectQuery = this.context.selectQuery();
        if (new Variables(this.variableDefinitions).hasDefinedFunction()) {
            return this.selectAggregate((SelectQuery<Record>)selectQuery);
        }
        if (new Variables(this.variableDefinitions).hasDefinedDistinct()) {
            return this.selectDistinct((SelectQuery<Record>)selectQuery);
        }
        return selectQuery;
    }

    public boolean isOutputWithJson() {
        return this.outputWithJson;
    }

    private String getAlias(I_VariableDefinition variableDefinition) {
        if (StringUtils.isEmpty((CharSequence)variableDefinition.getAlias())) {
            return variableDefinition.getPath();
        }
        return variableDefinition.getAlias();
    }
}

