/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ehrbase.aql.sql.queryimpl.JqueryPath;
import org.ehrbase.aql.sql.queryimpl.JsonbEntryQuery;
import org.ehrbase.aql.sql.queryimpl.NormalizedRmAttributePath;
import org.ehrbase.aql.sql.queryimpl.attribute.JsonbSelect;

public class GenericJsonPath {
    public static final String CONTEXT = "context";
    public static final String FEEDER_AUDIT = "feeder_audit";
    public static final String ORIGINATING_SYSTEM_ITEM_IDS = "originating_system_item_ids";
    public static final String FEEDER_SYSTEM_ITEM_IDS = "feeder_system_item_ids";
    public static final String ORIGINAL_CONTENT = "original_content";
    public static final String ORIGINATING_SYSTEM_AUDIT = "originating_system_audit";
    public static final String FEEDER_SYSTEM_AUDIT = "feeder_system_audit";
    public static final String SETTING = "setting";
    public static final String HEALTH_CARE_FACILITY = "health_care_facility";
    public static final String ITEMS = "items";
    public static final String CONTENT = "content";
    public static final String VALUE = "value";
    public static final String NAME = "name";
    public static final String OTHER_DETAILS = "other_details";
    public static final String OTHER_CONTEXT = "other_context";
    public static final String TERMINOLOGY_ID = "terminology_id";
    public static final String PURPOSE = "purpose";
    public static final String TARGET = "target";
    public static final String ARCHETYPE_NODE_ID = "archetype_node_id";
    private final String path;
    private boolean isIterative = false;

    public GenericJsonPath(String path) {
        this.path = path;
    }

    public String jqueryPath() {
        if (this.path == null || this.path.isEmpty()) {
            return this.path;
        }
        JqueryPath jqueryPath = new JqueryPath(JsonbEntryQuery.PATH_PART.VARIABLE_PATH_PART, this.path, "0");
        List<String> jqueryPaths = new NormalizedRmAttributePath(jqueryPath.evaluate()).transformStartingAt(0);
        if (!jqueryPaths.isEmpty() && jqueryPaths.get(0).startsWith("/other_details")) {
            jqueryPaths.set(0, jqueryPaths.get(0).replace("/other_details", OTHER_DETAILS));
        } else if (!jqueryPaths.isEmpty() && jqueryPaths.get(0).startsWith("/other_context")) {
            jqueryPaths.set(0, jqueryPaths.get(0).replace("/other_context", OTHER_CONTEXT));
        } else if (!jqueryPaths.isEmpty() && jqueryPaths.get(0).startsWith("/feeder_system_item_ids")) {
            jqueryPaths.set(0, jqueryPaths.get(0).replace("/feeder_system_item_ids", FEEDER_SYSTEM_ITEM_IDS));
        } else if (jqueryPaths.size() == 1 && !jqueryPaths.get(0).startsWith(OTHER_DETAILS) && !jqueryPaths.get(0).startsWith(OTHER_CONTEXT)) {
            jqueryPaths.set(0, jqueryPaths.get(0).replace("/", ""));
        }
        if (jqueryPaths.contains("0")) {
            jqueryPaths = jqueryPaths.stream().map(s -> s.equals("0") ? "$AQL_NODE_ITERATIVE$" : s).collect(Collectors.toList());
        }
        return new JsonbSelect(jqueryPaths).field();
    }

    @Deprecated(forRemoval=true)
    public String jqueryPathAttributeLevel() {
        if (this.path == null || this.path.isEmpty()) {
            return this.path;
        }
        List<String> jqueryPaths = Arrays.asList(this.path.split("/|,"));
        ArrayList<String> actualPaths = new ArrayList<String>();
        for (int i = 0; i < jqueryPaths.size(); ++i) {
            String segment = jqueryPaths.get(i);
            if (segment.matches(NAME) && GenericJsonPath.isTerminalValue(jqueryPaths, i) && jqueryPaths.get(0).equals(OTHER_DETAILS) || segment.startsWith(ITEMS)) {
                actualPaths.add("/" + segment);
                actualPaths.add("0");
                continue;
            }
            if (segment.startsWith(CONTENT)) {
                actualPaths.add("content,/" + segment);
                actualPaths.add("0");
                continue;
            }
            if (segment.matches("value|name") && !GenericJsonPath.isTerminalValue(jqueryPaths, i) && !jqueryPaths.get(0).equals(CONTEXT)) {
                actualPaths.add("/" + segment);
                if (!segment.matches(NAME)) continue;
                actualPaths.add("0");
                continue;
            }
            if (segment.matches(ARCHETYPE_NODE_ID) && jqueryPaths.get(0).equals(OTHER_DETAILS)) {
                actualPaths.add("/" + segment);
                continue;
            }
            actualPaths.add(segment);
        }
        return new JsonbSelect(actualPaths).field();
    }

    public static boolean isTerminalValue(List<String> paths, int index) {
        return paths.size() == 1 || paths.size() > 1 && index == paths.size() - 1 && paths.get(index).matches("value|name|terminology_id|purpose|target") && !paths.get(index - 1).matches("/(content|protocol|events|data|description|instruction|items|activities|activity|composition|entry|evaluation|observation|action|at)\\[([(0-9)|(A-Z)|(a-z)|\\-|_|\\.]*)\\]".substring(1)) && !paths.get(index - 1).startsWith(OTHER_DETAILS);
    }

    public boolean isIterative() {
        return this.isIterative;
    }
}

