/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl.attribute.composition;

import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.aql.sql.binding.JoinBinder;
import org.ehrbase.aql.sql.queryimpl.AqlRoutines;
import org.ehrbase.aql.sql.queryimpl.attribute.FieldResolutionContext;
import org.ehrbase.aql.sql.queryimpl.attribute.GenericJsonPath;
import org.ehrbase.aql.sql.queryimpl.attribute.IRMObjectAttribute;
import org.ehrbase.aql.sql.queryimpl.attribute.JoinSetup;
import org.ehrbase.aql.sql.queryimpl.attribute.JsonbSelect;
import org.ehrbase.aql.sql.queryimpl.attribute.composition.CompositionAttribute;
import org.ehrbase.jooq.pg.Routines;
import org.ehrbase.jooq.pg.Tables;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.TableField;
import org.jooq.impl.DSL;

public class FullCompositionJson
extends CompositionAttribute {
    protected TableField tableField;
    protected Optional<String> jsonPath;
    private boolean isJsonDataBlock;

    public FullCompositionJson(FieldResolutionContext fieldContext, JoinSetup joinSetup) {
        super(fieldContext, joinSetup);
        this.tableField = Tables.COMPOSITION.ID;
        this.jsonPath = Optional.empty();
        this.isJsonDataBlock = true;
    }

    @Override
    public Field<?> sqlField() {
        this.fieldContext.setJsonDatablock(true);
        this.fieldContext.setRmType("COMPOSITION");
        Configuration configuration = this.fieldContext.getContext().configuration();
        Field<String> jsonFullComposition = this.jsonPath.isPresent() ? AqlRoutines.jsonpathItemAsText(configuration, (Field<JSONB>)Routines.jsComposition2((Field)JoinBinder.compositionRecordTable.field(this.tableField.getName(), UUID.class), (Field)DSL.inline((String)this.fieldContext.getServerNodeId())).cast(JSONB.class), AqlRoutines.jsonpathParameters(this.jsonPath.get())) : Routines.jsComposition2((Field)JoinBinder.compositionRecordTable.field(this.tableField.getName(), UUID.class), (Field)DSL.inline((String)this.fieldContext.getServerNodeId())).cast(String.class);
        if (this.fieldContext.isWithAlias()) {
            return this.aliased(jsonFullComposition);
        }
        return this.defaultAliased(jsonFullComposition);
    }

    @Override
    public IRMObjectAttribute forTableField(TableField tableField) {
        this.tableField = tableField;
        return this;
    }

    public FullCompositionJson forJsonPath(String jsonPath) {
        if (jsonPath == null || jsonPath.isEmpty()) {
            this.jsonPath = Optional.empty();
            return this;
        }
        this.jsonPath = Optional.of(new GenericJsonPath(jsonPath).jqueryPath());
        return this;
    }

    public FullCompositionJson forJsonPath(String[] path) {
        if (GenericJsonPath.isTerminalValue(Arrays.asList(path), path.length - 1)) {
            this.isJsonDataBlock = false;
        }
        this.jsonPath = Optional.of(new JsonbSelect(Arrays.asList(path)).field());
        return this;
    }

    public boolean isJsonDataBlock() {
        return this.isJsonDataBlock;
    }
}

