/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl.value_field;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.ehrbase.aql.sql.queryimpl.AqlRoutines;
import org.ehrbase.aql.sql.queryimpl.FunctionBasedNodePredicateCall;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.attribute.AttributePath;
import org.ehrbase.aql.sql.queryimpl.attribute.FieldResolutionContext;
import org.ehrbase.aql.sql.queryimpl.attribute.GenericJsonPath;
import org.ehrbase.aql.sql.queryimpl.attribute.IRMObjectAttribute;
import org.ehrbase.aql.sql.queryimpl.attribute.JoinSetup;
import org.ehrbase.aql.sql.queryimpl.attribute.JsonbSelect;
import org.ehrbase.aql.sql.queryimpl.attribute.RMObjectAttribute;
import org.ehrbase.aql.sql.queryimpl.value_field.Functions;
import org.ehrbase.jooq.pg.Routines;
import org.ehrbase.jooq.pg.udt.records.DvCodedTextRecord;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.Function4;
import org.jooq.JSONB;
import org.jooq.SelectField;
import org.jooq.TableField;
import org.jooq.impl.DSL;

public class GenericJsonField
extends RMObjectAttribute {
    protected Optional<String> jsonPath = Optional.empty();
    private static final String ITERATIVE_MARKER = "$AQL_NODE_ITERATIVE$";

    public GenericJsonField(FieldResolutionContext fieldContext, JoinSetup joinSetup) {
        super(fieldContext, joinSetup);
    }

    public Field hierObjectId(Field<UUID> uuidField) {
        String rmType = "HIER_OBJECT_ID";
        Function<Field, Field> function = Routines::jsCanonicalHierObjectId1;
        return this.jsonField(rmType, function, (TableField)uuidField);
    }

    public Field dvCodedText(Field<DvCodedTextRecord> dvCodedTextRecordTableField) {
        String rmType = "DV_CODED_TEXT";
        Function<Field, Field> function = Routines::jsDvCodedTextInner1;
        return this.jsonField(rmType, function, (TableField)dvCodedTextRecordTableField);
    }

    public Field eventContext(Field<UUID> uuidField) {
        String rmType = "EVENT_CONTEXT";
        Function<Field, Field> function = Routines::jsContext;
        return this.jsonField(rmType, function, (TableField)uuidField);
    }

    public Field participations(Field<UUID> uuidField) {
        String rmType = "PARTICIPATION";
        Function<Field, Field> function = Routines::jsParticipations;
        return this.jsonField(rmType, function, (TableField)uuidField);
    }

    public Field partyRef(Field<String> namespace, Field<String> type, Field<String> scheme, Field<String> value) {
        String rmType = "PARTY_REF";
        Function4 function = Routines::jsPartyRef;
        return this.jsonField(rmType, function, (TableField)namespace, (TableField)type, (TableField)scheme, (TableField)value);
    }

    public Field dvDateTime(Field<Timestamp> dateTime, Field<String> timeZoneId) {
        String rmType = "DV_DATE_TIME";
        Function2 function = Routines::jsDvDateTime;
        return this.jsonField(rmType, function, (TableField)dateTime, (TableField)timeZoneId);
    }

    public Field ehrStatus(Field<UUID> uuidField, Field<String> serverId) {
        String rmType = null;
        Function2 function = Routines::jsEhrStatus2;
        return this.jsonField(rmType, function, (TableField)uuidField, (TableField)serverId);
    }

    public Field ehrStatus(Field<UUID> uuidField) {
        String rmType = null;
        Function<Field, Field> function = Routines::jsEhrStatus1;
        return this.jsonField(rmType, function, (TableField)uuidField);
    }

    public Field canonicalPartyIdendified(Field<UUID> uuidField) {
        String rmType = "PARTY_IDENTIFIED";
        Function<Field, Field> function = Routines::jsCanonicalPartyIdentified;
        return this.jsonField(rmType, function, (TableField)uuidField);
    }

    public Field feederAudit(Field<?> feederAudit) {
        String rmType = "FEEDER_AUDIT";
        return this.jsonField(rmType, null, (TableField)feederAudit);
    }

    public Field jsonField(String rmType, Object function, TableField ... tableFields) {
        Object jsonField;
        this.fieldContext.setRmType(rmType);
        Configuration configuration = this.fieldContext.getContext().configuration();
        if (this.jsonPath.isPresent()) {
            List<String> tokenized = Arrays.asList(AqlRoutines.jsonpathParameters(this.jsonPath.get()));
            if (tokenized.contains("$AQL_NODE_NAME_PREDICATE$")) {
                Collections.replaceAll(tokenized, ITERATIVE_MARKER, "0");
                jsonField = new FunctionBasedNodePredicateCall(this.fieldContext, tokenized).resolve(function, tableFields);
            } else {
                jsonField = tokenized.contains(ITERATIVE_MARKER) ? this.fieldWithJsonArrayIteration(configuration, tokenized, function, tableFields) : AqlRoutines.jsonpathItemAsText(configuration, Functions.inline(Functions.apply(function, tableFields).cast(JSONB.class)), tokenized.toArray(new String[0]));
            }
        } else {
            jsonField = Functions.inline(Functions.apply(function, tableFields)).cast(String.class);
        }
        if (jsonField.toString().contains("ehr.xjsonb_array_elements") && this.fieldContext.getClause().equals((Object)IQueryImpl.Clause.WHERE)) {
            jsonField = DSL.select((SelectField)jsonField).asField();
        }
        return this.as((Field)jsonField);
    }

    private Field fieldWithJsonArrayIteration(Configuration configuration, List<String> tokenized, Object function, TableField ... tableFields) {
        String[] prefix = tokenized.subList(0, tokenized.indexOf(ITERATIVE_MARKER)).toArray(new String[0]);
        String[] remaining = tokenized.subList(tokenized.indexOf(ITERATIVE_MARKER) + 1, tokenized.size()).toArray(new String[0]);
        Object field = AqlRoutines.jsonpathItem(configuration, (Field<JSONB>)Functions.apply(function, tableFields).cast(JSONB.class), prefix);
        while (remaining.length > 0) {
            List<String> tokens = Arrays.asList((String[])remaining.clone());
            if (tokens.contains(ITERATIVE_MARKER)) {
                prefix = tokens.subList(0, tokens.indexOf(ITERATIVE_MARKER)).toArray(new String[0]);
                remaining = tokens.subList(tokens.indexOf(ITERATIVE_MARKER) + 1, tokens.size()).toArray(new String[0]);
            } else {
                prefix = remaining;
                remaining = new String[]{};
            }
            field = AqlRoutines.jsonpathItemAsText(configuration, AqlRoutines.jsonArraySplitElements(configuration, (Field<JSONB>)field.cast(JSONB.class)), prefix);
        }
        return field;
    }

    public Field sqlField() {
        return null;
    }

    @Override
    public IRMObjectAttribute forTableField(TableField tableField) {
        return this;
    }

    public GenericJsonField forJsonPath(String jsonPath) {
        if (jsonPath == null || jsonPath.isEmpty()) {
            this.jsonPath = Optional.empty();
            return this;
        }
        GenericJsonPath genericJsonPath = new GenericJsonPath(jsonPath);
        this.jsonPath = Optional.of(genericJsonPath.jqueryPath());
        this.fieldContext.setUsingSetReturningFunction(genericJsonPath.isIterative());
        return this;
    }

    public GenericJsonField forJsonPath(String root, String jsonPath) {
        String actualPath = new AttributePath(root).redux(jsonPath);
        return this.forJsonPath(actualPath);
    }

    public GenericJsonField forJsonPath(String[] path) {
        this.jsonPath = Optional.of(new JsonbSelect(Arrays.asList(path)).field());
        return this;
    }
}

