/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Triple;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.tables.EhrFolder;
import org.ehrbase.jooq.pg.tables.EhrFolderHistory;
import org.ehrbase.jooq.pg.tables.records.EhrFolderHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.EhrFolderRecord;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.repository.ContributionRepository;
import org.ehrbase.repository.RepositoryHelper;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableRecord;
import org.jooq.UpdatableRecord;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class EhrFolderRepository {
    public static final String NOT_MATCH_LATEST_VERSION = "If-Match version_uid does not match latest version.";
    private final DSLContext context;
    private final TenantService tenantService;
    private final ContributionRepository contributionRepository;
    private final ServerConfig serverConfig;

    public EhrFolderRepository(DSLContext context, TenantService tenantService, ContributionRepository contributionRepository, ServerConfig serverConfig) {
        this.context = context;
        this.tenantService = tenantService;
        this.contributionRepository = contributionRepository;
        this.serverConfig = serverConfig;
    }

    @Transactional
    public void commit(List<EhrFolderRecord> folderRecordList, @Nullable UUID contributionId, @Nullable UUID auditId) {
        this.storeHead(folderRecordList, OffsetDateTime.now(), contributionId, ContributionChangeType.creation, auditId);
    }

    private void storeHead(List<EhrFolderRecord> folderRecordList, OffsetDateTime sysPeriodLower, UUID contributionId, ContributionChangeType contributionChangeType, UUID auditId) {
        UUID finalContributionId = Optional.ofNullable(contributionId).orElseGet(() -> this.contributionRepository.createDefault(((EhrFolderRecord)folderRecordList.get(0)).getEhrId(), ContributionDataType.folder, contributionChangeType));
        UUID finalAuditId = Optional.ofNullable(auditId).orElseGet(() -> this.contributionRepository.createDefaultAudit(ContributionChangeType.creation));
        Short sysTenant = this.tenantService.getCurrentSysTenant();
        folderRecordList.forEach(r -> {
            r.setSysPeriodLower(sysPeriodLower);
            r.setSysTenant(sysTenant);
            r.setContributionId(finalContributionId);
            r.setAuditId(finalAuditId);
        });
        RepositoryHelper.executeBulkInsert(this.context, folderRecordList, EhrFolder.EHR_FOLDER);
    }

    @Transactional
    public void update(List<EhrFolderRecord> folderRecordList, UUID contributionId, UUID auditId) {
        UUID rootId;
        OffsetDateTime now;
        int oldVersion;
        EhrFolderHistoryRecord delRecord;
        boolean isDeleted;
        int ehrFoldersIdx;
        EhrFolderRecord rootFolder = EhrFolderRepository.findRoot(folderRecordList);
        UUID ehrId = rootFolder.getEhrId();
        Result<EhrFolderRecord> oldHead = this.getFolderHead(ehrId, ehrFoldersIdx = rootFolder.getEhrFoldersIdx().intValue());
        if (oldHead.isEmpty()) {
            Optional<EhrFolderHistoryRecord> history = this.getLatestHistoryRoot(ehrId, ehrFoldersIdx);
            isDeleted = history.map(x -> x.getSysDeleted()).filter(deleted -> deleted).isPresent();
            if (!isDeleted) {
                throw new PreconditionFailedException(NOT_MATCH_LATEST_VERSION);
            }
            delRecord = history.get();
            oldVersion = delRecord.getSysVersion();
            now = EhrFolderRepository.createCurrentTime(delRecord.getSysPeriodLower());
            rootId = delRecord.getId();
        } else {
            isDeleted = false;
            delRecord = null;
            EhrFolderRecord root = EhrFolderRepository.findRoot(oldHead);
            oldVersion = root.getSysVersion();
            now = EhrFolderRepository.createCurrentTime(root.getSysPeriodLower());
            rootId = root.getId();
        }
        if (oldVersion + 1 != rootFolder.getSysVersion()) {
            throw new PreconditionFailedException(NOT_MATCH_LATEST_VERSION);
        }
        if (!rootId.equals(rootFolder.getId())) {
            throw new PreconditionFailedException(NOT_MATCH_LATEST_VERSION);
        }
        if (isDeleted) {
            delRecord.setSysPeriodUpper(now);
            int updateCount = this.context.executeUpdate((UpdatableRecord)delRecord);
            if (updateCount != 1) {
                throw new PreconditionFailedException(NOT_MATCH_LATEST_VERSION);
            }
        } else {
            List<EhrFolderHistoryRecord> historyRecords = oldHead.stream().map(r -> EhrFolderRepository.toHistory(r, now)).toList();
            RepositoryHelper.executeBulkInsert(this.context, historyRecords, EhrFolderHistory.EHR_FOLDER_HISTORY);
            int deleteCount = this.context.deleteFrom((Table)EhrFolder.EHR_FOLDER).where(EhrFolder.EHR_FOLDER.EHR_ID.eq((Object)ehrId)).and(EhrFolder.EHR_FOLDER.SYS_VERSION.eq((Object)oldVersion)).execute();
            if (deleteCount == 0) {
                throw new PreconditionFailedException(NOT_MATCH_LATEST_VERSION);
            }
        }
        this.storeHead(folderRecordList, now, contributionId, ContributionChangeType.modification, auditId);
    }

    private static EhrFolderRecord findRoot(List<EhrFolderRecord> folderRecordList) {
        return folderRecordList.stream().filter(r -> r.getPath().length == 1).findAny().orElseThrow();
    }

    private static EhrFolderHistoryRecord toHistory(EhrFolderRecord ehrFolderRecord, OffsetDateTime sysPeriodUpper) {
        EhrFolderHistoryRecord historyRecord = (EhrFolderHistoryRecord)ehrFolderRecord.into((Table)EhrFolderHistory.EHR_FOLDER_HISTORY);
        historyRecord.setSysPeriodUpper(sysPeriodUpper);
        historyRecord.setSysDeleted(Boolean.valueOf(false));
        return historyRecord;
    }

    private static OffsetDateTime createCurrentTime(OffsetDateTime lowerBound) {
        OffsetDateTime now = OffsetDateTime.now();
        if (now.isAfter(lowerBound)) {
            return now;
        }
        return lowerBound.plusNanos(1000L);
    }

    public List<EhrFolderRecord> fromHistory(List<EhrFolderHistoryRecord> historyRecords) {
        return historyRecords.stream().map(this::fromHistory).toList();
    }

    private EhrFolderRecord fromHistory(EhrFolderHistoryRecord historyRecord) {
        return (EhrFolderRecord)historyRecord.into((Table)EhrFolder.EHR_FOLDER);
    }

    public Result<EhrFolderRecord> getFolderHead(UUID ehrId, int ehrFoldersIdx) {
        return this.context.selectFrom((TableLike)EhrFolder.EHR_FOLDER).where(new Condition[]{EhrFolder.EHR_FOLDER.EHR_ID.eq((Object)ehrId), EhrFolder.EHR_FOLDER.EHR_FOLDERS_IDX.eq((Object)ehrFoldersIdx)}).fetch();
    }

    public Optional<EhrFolderHistoryRecord> getLatestHistoryRoot(UUID ehrid, int ehrFoldersIdx) {
        return this.context.selectFrom((TableLike)EhrFolderHistory.EHR_FOLDER_HISTORY).where(new Condition[]{EhrFolderHistory.EHR_FOLDER_HISTORY.EHR_ID.eq((Object)ehrid), EhrFolderHistory.EHR_FOLDER_HISTORY.EHR_FOLDERS_IDX.eq((Object)ehrFoldersIdx), EhrFolderHistory.EHR_FOLDER_HISTORY.ROW_NUM.eq((Object)0)}).orderBy((OrderField)EhrFolderHistory.EHR_FOLDER_HISTORY.SYS_VERSION.desc()).limit((Number)1).fetchOptional();
    }

    @Transactional
    public void delete(UUID ehrId, UUID rootFolderId, int version, int ehrFoldersIdx, UUID contributionId, UUID auditId) {
        Result<EhrFolderRecord> headFolders = this.getFolderHead(ehrId, ehrFoldersIdx);
        if (headFolders.isEmpty()) {
            throw new PreconditionFailedException(NOT_MATCH_LATEST_VERSION);
        }
        EhrFolderRecord headRoot = EhrFolderRepository.findRoot(headFolders);
        if (headRoot.getSysVersion() != version || !headRoot.getId().equals(rootFolderId)) {
            throw new PreconditionFailedException(NOT_MATCH_LATEST_VERSION);
        }
        OffsetDateTime now = EhrFolderRepository.createCurrentTime(headRoot.getSysPeriodLower());
        List<EhrFolderHistoryRecord> historyRecords = headFolders.stream().map(r -> EhrFolderRepository.toHistory(r, now)).toList();
        RepositoryHelper.executeBulkInsert(this.context, historyRecords, EhrFolderHistory.EHR_FOLDER_HISTORY);
        if (contributionId == null) {
            contributionId = this.contributionRepository.createDefault(ehrId, ContributionDataType.folder, ContributionChangeType.deleted);
        }
        if (auditId == null) {
            auditId = this.contributionRepository.createDefaultAudit(ContributionChangeType.creation);
        }
        EhrFolderHistoryRecord delRecord = (EhrFolderHistoryRecord)headRoot.into((Table)EhrFolderHistory.EHR_FOLDER_HISTORY);
        delRecord.setSysVersion(Integer.valueOf(version + 1));
        delRecord.setSysPeriodUpper(null);
        delRecord.setSysPeriodLower(now);
        delRecord.setSysDeleted(Boolean.valueOf(true));
        delRecord.setContributionId(contributionId);
        delRecord.setAuditId(auditId);
        delRecord.setArchetypeNodeId(null);
        delRecord.setItems(null);
        delRecord.setFields(null);
        this.context.executeInsert((TableRecord)delRecord);
        int deleteCount = this.context.deleteFrom((Table)EhrFolder.EHR_FOLDER).where(new Condition[]{EhrFolder.EHR_FOLDER.EHR_ID.eq((Object)ehrId), EhrFolder.EHR_FOLDER.EHR_FOLDERS_IDX.eq((Object)ehrFoldersIdx), EhrFolder.EHR_FOLDER.SYS_VERSION.eq((Object)version)}).execute();
        if (deleteCount == 0) {
            throw new PreconditionFailedException(NOT_MATCH_LATEST_VERSION);
        }
    }

    public Result<EhrFolderHistoryRecord> getByVersion(UUID ehrId, int version) {
        SelectConditionStep headQuery = EhrFolderRepository.headQuery(this.context).where(new Condition[]{EhrFolder.EHR_FOLDER.EHR_ID.eq((Object)ehrId), EhrFolder.EHR_FOLDER.SYS_VERSION.eq((Object)version)});
        Field<?>[] fields = this.convertToEhrFolderHistoryFields(headQuery.fields());
        SelectConditionStep historyQuery = this.context.select(fields).from((TableLike)EhrFolderHistory.EHR_FOLDER_HISTORY).where(new Condition[]{EhrFolderHistory.EHR_FOLDER_HISTORY.EHR_ID.eq((Object)ehrId), EhrFolderHistory.EHR_FOLDER_HISTORY.SYS_VERSION.eq((Object)version), EhrFolderHistory.EHR_FOLDER_HISTORY.SYS_DELETED.isFalse()});
        return headQuery.unionAll((Select)historyQuery).fetch().into((Table)EhrFolderHistory.EHR_FOLDER_HISTORY);
    }

    public Field<?>[] convertToEhrFolderHistoryFields(Field<?>[] fields) {
        return (Field[])Arrays.stream(fields).map(x$0 -> EhrFolderHistory.EHR_FOLDER_HISTORY.field(x$0)).toArray(Field[]::new);
    }

    private static SelectJoinStep<Record> headQuery(DSLContext context) {
        return context.select((SelectFieldOrAsterisk[])EhrFolder.EHR_FOLDER.fields()).select(new SelectFieldOrAsterisk[]{DSL.inline((OffsetDateTime)null).as(EhrFolderHistory.EHR_FOLDER_HISTORY.SYS_PERIOD_UPPER.getName()), DSL.inline((boolean)false).as(EhrFolderHistory.EHR_FOLDER_HISTORY.SYS_DELETED.getName())}).from((TableLike)EhrFolder.EHR_FOLDER);
    }

    public Result<EhrFolderHistoryRecord> getByTime(UUID ehrId, OffsetDateTime time) {
        SelectConditionStep headQuery = EhrFolderRepository.headQuery(this.context).where(new Condition[]{EhrFolder.EHR_FOLDER.EHR_ID.eq((Object)ehrId), EhrFolder.EHR_FOLDER.SYS_PERIOD_LOWER.lessOrEqual((Object)time)});
        Field<?>[] fields = this.convertToEhrFolderHistoryFields(headQuery.fields());
        SelectConditionStep historyQuery = this.context.select(fields).from((TableLike)EhrFolderHistory.EHR_FOLDER_HISTORY).where(new Condition[]{EhrFolderHistory.EHR_FOLDER_HISTORY.EHR_ID.eq((Object)ehrId), EhrFolderHistory.EHR_FOLDER_HISTORY.SYS_PERIOD_LOWER.lessOrEqual((Object)time), EhrFolderHistory.EHR_FOLDER_HISTORY.SYS_PERIOD_UPPER.greaterThan((Object)time).or(EhrFolderHistory.EHR_FOLDER_HISTORY.SYS_PERIOD_UPPER.isNull()), EhrFolderHistory.EHR_FOLDER_HISTORY.SYS_DELETED.isFalse()});
        return headQuery.unionAll((Select)historyQuery).fetch().into((Table)EhrFolderHistory.EHR_FOLDER_HISTORY);
    }

    public Folder from(List<EhrFolderRecord> ehrFolderRecords) {
        Map<List<String>, EhrFolderRecord> byPathMap = ehrFolderRecords.stream().collect(Collectors.toMap(ehrFolderRecord -> Arrays.stream(ehrFolderRecord.getPath()).toList(), Function.identity()));
        return EhrFolderRepository.from(byPathMap.keySet().stream().filter(l -> l.size() == 1).findAny().orElseThrow(), byPathMap);
    }

    private static Folder from(List<String> path, Map<List<String>, EhrFolderRecord> byPathMap) {
        Folder folder = (Folder)new CanonicalJson().unmarshal(byPathMap.get(path).getFields().data(), Folder.class);
        byPathMap.keySet().stream().filter(l -> l.size() == path.size() + 1).forEach(nextPath -> {
            Folder subFolder = EhrFolderRepository.from(nextPath, byPathMap.entrySet().stream().filter(e -> ((List)e.getKey()).size() >= nextPath.size() && ((List)e.getKey()).subList(0, nextPath.size()).equals(nextPath)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            folder.addFolder(subFolder);
        });
        return folder;
    }

    public boolean hasDirectory(UUID ehrId) {
        SelectConditionStep headQuery = this.context.selectOne().from((TableLike)EhrFolder.EHR_FOLDER).where(new Condition[]{EhrFolder.EHR_FOLDER.EHR_ID.eq((Object)ehrId), EhrFolder.EHR_FOLDER.EHR_FOLDERS_IDX.eq((Object)1)});
        SelectConditionStep historyQuery = this.context.selectOne().from((TableLike)EhrFolderHistory.EHR_FOLDER_HISTORY).where(new Condition[]{EhrFolderHistory.EHR_FOLDER_HISTORY.EHR_ID.eq((Object)ehrId), EhrFolderHistory.EHR_FOLDER_HISTORY.EHR_FOLDERS_IDX.eq((Object)1)});
        return this.context.fetchExists((Select)headQuery.unionAll((Select)historyQuery));
    }

    public List<EhrFolderRecord> toRecord(UUID ehrId, Folder folder) {
        List<Triple<List<String>, List<Integer>, Folder>> flatten = EhrFolderRepository.flatten(folder);
        List<EhrFolderRecord> ehrFolderRecords = IntStream.range(0, flatten.size()).mapToObj(i -> this.toRecord(i, (Triple<List<String>, List<Integer>, Folder>)((Triple)flatten.get(i)), ehrId)).toList();
        UIDBasedId uIDBasedId = folder.getUid();
        if (uIDBasedId instanceof ObjectVersionId) {
            ObjectVersionId objectVersionId = (ObjectVersionId)uIDBasedId;
            ehrFolderRecords.forEach(r -> r.setSysVersion(Integer.valueOf(objectVersionId.getVersionTreeId().getValue())));
        }
        return ehrFolderRecords;
    }

    private EhrFolderRecord toRecord(int rowNum, Triple<List<String>, List<Integer>, Folder> flattened, UUID ehrId) {
        EhrFolderRecord folder2Record = (EhrFolderRecord)this.context.newRecord((Table)EhrFolder.EHR_FOLDER);
        folder2Record.setEhrId(ehrId);
        folder2Record.setEhrFoldersIdx(Integer.valueOf(1));
        folder2Record.setRowNum(Integer.valueOf(rowNum));
        List path = (List)flattened.getLeft();
        folder2Record.setPath((String[])path.toArray(String[]::new));
        Folder folder = (Folder)flattened.getRight();
        folder2Record.setId(UUID.fromString(folder.getUid().getRoot().getValue()));
        folder2Record.setArchetypeNodeId(folder.getArchetypeNodeId());
        folder2Record.setItems(this.findItems(folder));
        List indexList = (List)flattened.getMiddle();
        indexList.add(0, 0);
        folder2Record.setHierarchyIdx(EhrFolderRepository.encodeIndex(indexList, false));
        folder2Record.setHierarchyIdxCap(EhrFolderRepository.encodeIndex(indexList, true));
        folder2Record.setHierarchyIdxLen(Integer.valueOf(indexList.size()));
        folder.setFolders(null);
        folder2Record.setFields(JSONB.valueOf((String)new CanonicalJson().marshal((RMObject)folder)));
        return folder2Record;
    }

    private static String encodeIndex(List<Integer> index, boolean addCap) {
        return index.stream().map(Objects::toString).collect(Collectors.joining(",", "", addCap ? ",~" : ","));
    }

    private UUID[] findItems(Folder folder) {
        UUID[] value = null;
        if (folder.getItems() != null) {
            value = (UUID[])folder.getItems().stream().map(ObjectRef::getId).map(ObjectId::getValue).map(UUID::fromString).toArray(UUID[]::new);
        }
        return value;
    }

    private static List<Triple<List<String>, List<Integer>, Folder>> flatten(Folder folder) {
        ArrayList<Triple<List<String>, List<Integer>, Folder>> flattened = new ArrayList<Triple<List<String>, List<Integer>, Folder>>();
        ArrayList<String> namePath = new ArrayList<String>();
        namePath.add(folder.getNameAsString());
        ArrayList indexPath = new ArrayList();
        flattened.add(Triple.of(namePath, indexPath, (Object)folder));
        if (folder.getFolders() != null) {
            IntStream.range(0, folder.getFolders().size()).forEach(i -> EhrFolderRepository.flatten((Folder)folder.getFolders().get(i)).forEach(p -> {
                ArrayList<String> namePath = new ArrayList<String>();
                namePath.add(folder.getNameAsString());
                namePath.addAll((Collection)p.getLeft());
                List indexPath = (List)p.getMiddle();
                indexPath.add(0, i);
                flattened.add(Triple.of(namePath, (Object)indexPath, (Object)((Folder)p.getRight())));
            }));
        }
        return flattened;
    }

    @Transactional
    public void adminDelete(UUID ehrId, Integer ehrFoldersIdx) {
        this.context.deleteFrom((Table)EhrFolder.EHR_FOLDER).where(EhrFolder.EHR_FOLDER.EHR_ID.eq((Object)ehrId)).execute();
        DeleteConditionStep deleteQuery = this.context.deleteFrom((Table)EhrFolderHistory.EHR_FOLDER_HISTORY).where(EhrFolderHistory.EHR_FOLDER_HISTORY.EHR_ID.eq((Object)ehrId));
        if (ehrFoldersIdx != null) {
            deleteQuery = deleteQuery.and(EhrFolderHistory.EHR_FOLDER_HISTORY.EHR_FOLDERS_IDX.eq((Object)ehrFoldersIdx));
        }
        deleteQuery.execute();
    }

    public List<ObjectVersionId> findForContribution(UUID ehrId, UUID contributionId) {
        SelectConditionStep headQuery = this.context.select((SelectField)EhrFolder.EHR_FOLDER.ID, (SelectField)EhrFolder.EHR_FOLDER.SYS_VERSION).from((TableLike)EhrFolder.EHR_FOLDER).where(new Condition[]{EhrFolder.EHR_FOLDER.EHR_ID.eq((Object)ehrId), EhrFolder.EHR_FOLDER.ROW_NUM.eq((Object)0), EhrFolder.EHR_FOLDER.EHR_FOLDERS_IDX.eq((Object)1), EhrFolder.EHR_FOLDER.CONTRIBUTION_ID.eq((Object)contributionId)});
        SelectConditionStep historyQuery = this.context.select((SelectField)EhrFolderHistory.EHR_FOLDER_HISTORY.ID, (SelectField)EhrFolderHistory.EHR_FOLDER_HISTORY.SYS_VERSION).from((TableLike)EhrFolderHistory.EHR_FOLDER_HISTORY).where(new Condition[]{EhrFolderHistory.EHR_FOLDER_HISTORY.EHR_ID.eq((Object)ehrId), EhrFolderHistory.EHR_FOLDER_HISTORY.ROW_NUM.eq((Object)0), EhrFolderHistory.EHR_FOLDER_HISTORY.EHR_FOLDERS_IDX.eq((Object)1), EhrFolderHistory.EHR_FOLDER_HISTORY.CONTRIBUTION_ID.eq((Object)contributionId)});
        return headQuery.unionAll((Select)historyQuery).stream().map(r -> new ObjectVersionId(((UUID)r.value1()).toString() + "::" + this.serverConfig.getNodename() + "::" + r.value2())).toList();
    }
}

