/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartyRelated;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.dao.access.jooq.party.PartyRefValue;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.PartyType;
import org.ehrbase.jooq.pg.tables.records.IdentifierRecord;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.ehrbase.jooq.pg.tables.records.UsersRecord;
import org.ehrbase.jooq.pg.udt.DvCodedText;
import org.ehrbase.jooq.pg.udt.records.DvCodedTextRecord;
import org.ehrbase.repository.RepositoryHelper;
import org.ehrbase.service.PersistentCodePhrase;
import org.ehrbase.service.PersistentTermMapping;
import org.ehrbase.util.UuidGenerator;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class PartyProxyRepository {
    private final DSLContext context;
    private final TenantService tenantService;
    private static final Function<IdentifierRecord, DvIdentifier> idConvert = identifierRecord -> {
        DvIdentifier identifier = new DvIdentifier();
        identifier.setIssuer(identifierRecord.getIssuer());
        identifier.setAssigner(identifierRecord.getAssigner());
        identifier.setId(identifierRecord.getIdValue());
        identifier.setType(identifierRecord.getTypeName());
        return identifier;
    };

    public PartyProxyRepository(DSLContext context, TenantService tenantService) {
        this.context = context;
        this.tenantService = tenantService;
    }

    public Optional<UUID> findInternalUserId(String username) {
        return this.context.select((SelectField)Tables.USERS.PARTY_ID).from((TableLike)Tables.USERS).where(Tables.USERS.USERNAME.eq((Object)username)).fetchOptional((Field)Tables.USERS.PARTY_ID);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UUID createInternalUser(String username) {
        DvIdentifier identifier = new DvIdentifier();
        identifier.setId(username);
        identifier.setIssuer("EHRbase");
        identifier.setAssigner("EHRbase");
        identifier.setType("EHRbase Security Authentication User");
        PartyRef externalRef = new PartyRef((ObjectId)new GenericId(UuidGenerator.randomUUID().toString(), "DEMOGRAPHIC"), "User", "PARTY");
        PartyIdentified partyIdentified = new PartyIdentified(externalRef, "EHRbase Internal " + username, List.of(identifier));
        UUID uuid = this.create((PartyProxy)partyIdentified);
        UsersRecord usersRecord = (UsersRecord)this.context.newRecord((Table)Tables.USERS);
        usersRecord.setPartyId(uuid);
        usersRecord.setUsername(username);
        usersRecord.setSysTenant(this.tenantService.getCurrentSysTenant());
        usersRecord.store();
        return uuid;
    }

    @Transactional
    public UUID create(PartyProxy partyProxy) {
        PartyRefValue partyRefValue = new PartyRefValue(partyProxy).attributes();
        PartyIdentifiedRecord partyIdentifiedRecord = (PartyIdentifiedRecord)this.context.newRecord((Table)Tables.PARTY_IDENTIFIED);
        partyIdentifiedRecord.setId(UuidGenerator.randomUUID());
        partyIdentifiedRecord.setPartyRefNamespace(partyRefValue.getNamespace());
        partyIdentifiedRecord.setPartyRefValue(partyRefValue.getValue());
        partyIdentifiedRecord.setPartyRefScheme(partyRefValue.getScheme());
        partyIdentifiedRecord.setPartyRefType(partyRefValue.getType());
        partyIdentifiedRecord.setObjectIdType(partyRefValue.getObjectIdType());
        partyIdentifiedRecord.setSysTenant(this.tenantService.getCurrentSysTenant());
        List identifierList = Collections.emptyList();
        if (partyProxy instanceof PartyIdentified) {
            PartyIdentified partyIdentified = (PartyIdentified)partyProxy;
            identifierList = partyIdentified.getIdentifiers();
            partyIdentifiedRecord.setPartyType(PartyType.party_identified);
            partyIdentifiedRecord.setName(partyIdentified.getName());
            if (partyIdentified instanceof PartyRelated) {
                PartyRelated partyRelated = (PartyRelated)partyIdentified;
                partyIdentifiedRecord.setPartyType(PartyType.party_related);
                partyIdentifiedRecord.setRelationship(this.relationshipAsRecord((PartyProxy)partyRelated));
            }
        } else {
            partyIdentifiedRecord.setPartyType(PartyType.party_self);
        }
        partyIdentifiedRecord.store();
        RepositoryHelper.executeBulkInsert(this.context, identifierList.stream().map(i -> this.to(partyIdentifiedRecord.getId(), (DvIdentifier)i)).toList(), Tables.IDENTIFIER);
        return partyIdentifiedRecord.getId();
    }

    public Optional<UUID> findMatching(PartyProxy partyProxy) {
        if (partyProxy instanceof PartySelf) {
            PartySelf partySelf = (PartySelf)partyProxy;
            return this.findInDBSelf(partySelf);
        }
        if (partyProxy instanceof PartyRelated) {
            PartyRelated partyRelated = (PartyRelated)partyProxy;
            return this.findInDBPartyRelated(partyRelated);
        }
        if (partyProxy instanceof PartyIdentified) {
            PartyIdentified partyIdentified = (PartyIdentified)partyProxy;
            return this.findInDBIdentified(partyIdentified);
        }
        throw new UnsupportedOperationException();
    }

    private DvCodedTextRecord relationshipAsRecord(PartyProxy partyProxy) {
        com.nedap.archie.rm.datavalues.DvCodedText relationship = ((PartyRelated)partyProxy).getRelationship();
        return new DvCodedTextRecord(relationship.getValue(), new PersistentCodePhrase(relationship.getDefiningCode()).encode(), relationship.getFormatting(), new PersistentCodePhrase(relationship.getLanguage()).encode(), new PersistentCodePhrase(relationship.getEncoding()).encode(), new PersistentTermMapping().termMappingRepresentation(relationship.getMappings()));
    }

    private IdentifierRecord to(UUID partyId, DvIdentifier identifier) {
        if (identifier.getId() == null) {
            throw new IllegalArgumentException("DV_IDENTIFIER with null ID");
        }
        IdentifierRecord identifierRecord = (IdentifierRecord)this.context.newRecord((Table)Tables.IDENTIFIER);
        identifierRecord.setParty(partyId);
        identifierRecord.setIdValue(identifier.getId());
        identifierRecord.setIssuer(identifier.getIssuer());
        identifierRecord.setAssigner(identifier.getAssigner());
        identifierRecord.setTypeName(identifier.getType());
        identifierRecord.setSysTenant(this.tenantService.getCurrentSysTenant());
        return identifierRecord;
    }

    private Optional<UUID> findInDBSelf(PartySelf partyProxy) {
        Optional<UUID> partySelfUUID = this.findInDB(partyProxy.getExternalRef());
        if (partySelfUUID.isEmpty() && partyProxy.getExternalRef() == null) {
            PartyIdentifiedRecord partyIdentifiedRecord = (PartyIdentifiedRecord)this.context.fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE.isNull().and(Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE.isNull()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_SCHEME.isNull()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_TYPE.isNull()).and(Tables.PARTY_IDENTIFIED.PARTY_TYPE.eq((Object)PartyType.party_self)));
            partySelfUUID = Optional.ofNullable(partyIdentifiedRecord).map(PartyIdentifiedRecord::getId);
        }
        return partySelfUUID;
    }

    private Optional<UUID> findInDBPartyRelated(PartyRelated partyProxy) {
        PartyIdentifiedRecord partyIdentifiedRecord;
        Optional<UUID> uuid = this.findInDB(partyProxy.getExternalRef());
        if (uuid.isEmpty() && partyProxy.getExternalRef() == null && (partyIdentifiedRecord = (PartyIdentifiedRecord)this.context.fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE.isNull().and(Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE.isNull()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_SCHEME.isNull()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_TYPE.isNull()).and(Tables.PARTY_IDENTIFIED.NAME.eq((Object)partyProxy.getName())).and(DSL.field((String)"({0}).{1}", (QueryPart[])new QueryPart[]{Tables.PARTY_IDENTIFIED.RELATIONSHIP, DvCodedText.VALUE.getUnqualifiedName()}).eq((Object)this.relationshipAsRecord((PartyProxy)partyProxy).getValue())).and(Tables.PARTY_IDENTIFIED.PARTY_TYPE.eq((Object)PartyType.party_related)))) != null) {
            uuid = Optional.ofNullable(partyIdentifiedRecord.getId());
            if (this.compare(partyIdentifiedRecord, (List<DvIdentifier>)partyProxy.getIdentifiers())) {
                uuid = Optional.empty();
            }
        }
        return uuid;
    }

    private boolean compare(PartyIdentifiedRecord partyIdentifiedRecord, List<DvIdentifier> identifiers) {
        List<DvIdentifier> identifiersFromDB = this.context.fetch((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.PARTY.eq((Object)partyIdentifiedRecord.getId())).stream().map(idConvert::apply).toList();
        return this.compare(identifiersFromDB, identifiers);
    }

    private boolean compare(List<DvIdentifier> identifiersFromDB, List<DvIdentifier> identifiers) {
        if (identifiersFromDB == null && identifiers == null) {
            return true;
        }
        if (identifiersFromDB == null || identifiers == null) {
            return false;
        }
        if (identifiersFromDB.size() != identifiers.size()) {
            return false;
        }
        List<DvIdentifier> filteredList = identifiersFromDB.stream().filter(identifier -> identifiers.stream().anyMatch(identifier1 -> Objects.equals(identifier1.getType(), identifier.getType()) && Objects.equals(identifier1.getId(), identifier.getId()) && Objects.equals(identifier1.getAssigner(), identifier.getAssigner()) && Objects.equals(identifier1.getIssuer(), identifier.getIssuer()))).toList();
        return filteredList.size() == identifiersFromDB.size();
    }

    private Optional<UUID> findInDBIdentified(PartyIdentified partyProxy) {
        Optional<UUID> uuid = this.findInDB(partyProxy.getExternalRef());
        if (uuid.isPresent()) {
            PartyIdentifiedRecord partyIdentifiedRecord = (PartyIdentifiedRecord)this.context.fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.ID.eq((Object)uuid.get()));
            if (partyIdentifiedRecord == null) {
                throw new InternalServerException("Inconsistent PartyIdentified UUID:" + uuid);
            }
            if (!partyIdentifiedRecord.getName().equals(partyProxy.getName())) {
                throw new IllegalArgumentException("Conflicting identification, existing name was:" + (String)partyIdentifiedRecord.get((Field)Tables.PARTY_IDENTIFIED.NAME) + ", but found passed name:" + partyProxy.getName());
            }
            if (this.compare(partyIdentifiedRecord, (List<DvIdentifier>)partyProxy.getIdentifiers())) {
                uuid = Optional.empty();
            }
        }
        return uuid;
    }

    private Optional<UUID> findInDB(PartyRef partyRef) {
        PartyIdentifiedRecord partyIdentifiedRecord;
        if (partyRef == null) {
            return Optional.empty();
        }
        ObjectId ref = partyRef.getId();
        if (ref instanceof ObjectVersionId || ref instanceof HierObjectId) {
            ObjectId objectId = ref;
            partyIdentifiedRecord = (PartyIdentifiedRecord)this.context.fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE.eq((Object)partyRef.getNamespace()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE.eq((Object)objectId.getValue())));
        } else if (ref instanceof GenericId) {
            GenericId genericId = (GenericId)ref;
            partyIdentifiedRecord = (PartyIdentifiedRecord)this.context.fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE.eq((Object)partyRef.getNamespace()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_SCHEME.eq((Object)genericId.getScheme())).and(Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE.eq((Object)genericId.getValue())));
        } else {
            throw new IllegalStateException("Unsupported PartyRef identification:" + ref.getClass().getSimpleName());
        }
        return Optional.ofNullable(partyIdentifiedRecord).map(PartyIdentifiedRecord::getId);
    }
}

