/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.ehrbase.api.tenant.TenantAuthentication;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.SQLDialect;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@org.springframework.context.annotation.Configuration
@EnableTransactionManagement
public class PersistenceConfig {
    @Qualifier(value="dataSource")
    @Autowired
    private DataSource dataSource;

    public TransactionAwareDataSourceProxy transactionAwareDataSource() {
        return new TransactionAwareDataSourceProxy(this.dataSource);
    }

    @Bean
    public DataSourceTransactionManager transactionManager() {
        return new DataSourceTransactionManager(this.dataSource);
    }

    @Bean
    public DataSourceConnectionProvider connectionProvider() {
        return new DataSourceConnectionProvider((DataSource)this.transactionAwareDataSource()){
            public static final String DB_SET_TENANT_ID = "select  set_config('ehrbase.current_tenant', ?, false)";

            public Connection acquire() {
                Connection connection;
                block10: {
                    Connection connection2 = super.acquire();
                    PreparedStatement sql = connection2.prepareStatement(DB_SET_TENANT_ID);
                    try {
                        sql.setString(1, Short.toString(TenantAuthentication.DEFAULT_SYS_TENANT));
                        sql.execute();
                        connection = connection2;
                        if (sql == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (sql != null) {
                                try {
                                    sql.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            try {
                                super.release(connection2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw new DataAccessException("Failed to set default tenant", (Throwable)e);
                        }
                    }
                    sql.close();
                }
                return connection;
            }
        };
    }

    @Bean
    public ExceptionTranslator exceptionTransformer() {
        return new ExceptionTranslator();
    }

    @Bean
    @Primary
    public DefaultDSLContext dsl(DefaultConfiguration cfg) {
        return new DefaultDSLContext((Configuration)cfg);
    }

    @Bean
    public DefaultConfiguration configuration(DataSourceConnectionProvider provider) {
        DefaultConfiguration jooqConfiguration = new DefaultConfiguration();
        jooqConfiguration.set((ConnectionProvider)provider);
        jooqConfiguration.set(new ExecuteListenerProvider[]{new DefaultExecuteListenerProvider((ExecuteListener)this.exceptionTransformer())});
        SQLDialect dialect = SQLDialect.POSTGRES;
        jooqConfiguration.set(dialect);
        return jooqConfiguration;
    }

    static class ExceptionTranslator
    extends DefaultExecuteListener {
        ExceptionTranslator() {
        }

        public void exception(ExecuteContext context) {
            SQLDialect dialect = context.configuration().dialect();
            SQLErrorCodeSQLExceptionTranslator translator = new SQLErrorCodeSQLExceptionTranslator(dialect.name());
            context.exception((RuntimeException)translator.translate("Access database using Jooq", context.sql(), context.sqlException()));
        }
    }
}

