/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.tenant;

import com.auth0.jwt.JWT;
import com.auth0.jwt.impl.JWTParser;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Payload;
import org.apache.commons.codec.binary.Base64;
import org.ehrbase.api.tenant.TenantAuthentication;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;

public class DefaultTenantAuthentication
extends AbstractAuthenticationToken
implements TenantAuthentication<String> {
    private static final long serialVersionUID = -187707458684929521L;
    public static final String TENANT_CLAIM = "tnt";
    private String name;
    private String tenantId;
    private DecodedJWT token;
    private String raw;
    private Payload payload;

    public static <T> DefaultTenantAuthentication of(TenantAuthentication<T> auth, Converter<T, String> converter) {
        DefaultTenantAuthentication defAuth = new DefaultTenantAuthentication();
        defAuth.tenantId = auth.getTenantId();
        defAuth.name = auth.getName();
        defAuth.raw = (String)converter.convert(auth.getAuthentication());
        defAuth.token = JWT.decode((String)defAuth.raw);
        return defAuth;
    }

    public static <T> DefaultTenantAuthentication of(String tenantId) {
        DefaultTenantAuthentication auth = new DefaultTenantAuthentication();
        auth.tenantId = tenantId;
        return auth;
    }

    public static <T> DefaultTenantAuthentication ofToken(String token) {
        return new DefaultTenantAuthentication(token);
    }

    private DefaultTenantAuthentication() {
        super(null);
    }

    private DefaultTenantAuthentication(String token) {
        super(null);
        this.raw = token;
        this.token = JWT.decode((String)token);
        this.payload = new JWTParser().parsePayload(new String(Base64.decodeBase64((String)this.token.getPayload())));
        this.tenantId = this.payload.getClaim(TENANT_CLAIM).asString();
    }

    public String getName() {
        return this.name;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Object getCredentials() {
        return this.token;
    }

    public Object getPrincipal() {
        return this.token;
    }

    public String getAuthentication() {
        return this.raw;
    }
}

