/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.tenant.extraction;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.function.TriFunction;
import org.ehrbase.api.tenant.TenantAuthentication;
import org.ehrbase.api.tenant.TenantIdExtractionStrategy;
import org.ehrbase.tenant.TokenSupport;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;

public abstract class AuthenticatedExtractionStrategy<A extends Authentication>
implements TenantIdExtractionStrategy<String> {
    private static final TriFunction<Authentication, String, String, TenantAuthentication<String>> TO_AUTH = (auth, rawToken, tenantId) -> {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(AbstractAuthenticationToken.class);
        enhancer.setInterfaces(new Class[]{TenantAuthentication.class});
        enhancer.setCallback((Callback)new TenantAuthenticationAdapter((Authentication)auth, (String)rawToken, (String)tenantId));
        Object created = enhancer.create(new Class[]{Collection.class}, new Object[]{Collections.emptyList()});
        return (TenantAuthentication)created;
    };
    private final Predicate<Authentication> predicate;

    protected AuthenticatedExtractionStrategy(Predicate<Authentication> predicate) {
        this.predicate = predicate;
    }

    public boolean accept(Object ... args) {
        SecurityContext ctx = SecurityContextHolder.getContext();
        Authentication theAuthentication = ctx.getAuthentication();
        return null != theAuthentication && this.predicate.test(theAuthentication);
    }

    public Optional<TenantAuthentication<String>> extract(Object ... args) {
        return this.extractWithPrior(Optional.empty(), args);
    }

    static class TenantAuthenticationAdapter
    implements MethodInterceptor {
        private static Method tenantIdCall;
        private static Method defTenantIdCall;
        private static Method authenticationCall;
        private final Authentication authentication;
        private final String rawToken;
        private final String tenantId;

        TenantAuthenticationAdapter(Authentication authentication, String rawToken, String tenantId) {
            this.authentication = authentication;
            this.rawToken = rawToken;
            this.tenantId = tenantId;
        }

        public Object intercept(Object me, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (defTenantIdCall.equals(method)) {
                return TenantAuthentication.getDefaultTenantId();
            }
            if (tenantIdCall.equals(method)) {
                return this.tenantId;
            }
            if (authenticationCall.equals(method)) {
                return this.rawToken;
            }
            return method.invoke((Object)this.authentication, args);
        }

        static {
            try {
                defTenantIdCall = TenantAuthentication.class.getDeclaredMethod("getDefaultTenantId", new Class[0]);
                tenantIdCall = TenantAuthentication.class.getDeclaredMethod("getTenantId", new Class[0]);
                authenticationCall = TenantAuthentication.class.getDeclaredMethod("getAuthentication", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static class AuthenticationExtractionStrategy
    extends AuthenticatedExtractionStrategy<UsernamePasswordAuthenticationToken> {
        public AuthenticationExtractionStrategy() {
            super(auth -> auth instanceof UsernamePasswordAuthenticationToken);
        }

        public Optional<TenantAuthentication<String>> extractWithPrior(Optional<TenantAuthentication<?>> priorAuthentication, Object ... args) {
            SecurityContext ctx = SecurityContextHolder.getContext();
            if (priorAuthentication.isPresent()) {
                return Optional.of((TenantAuthentication)TO_AUTH.apply((Object)ctx.getAuthentication(), (Object)priorAuthentication.get().getAuthentication().toString(), (Object)priorAuthentication.get().getTenantId()));
            }
            throw new IllegalStateException();
        }

        public int priority() {
            return 900;
        }
    }

    public static class TokenAuthenticatedExtractionStrategy
    extends AuthenticatedExtractionStrategy<AbstractAuthenticationToken> {
        public TokenAuthenticatedExtractionStrategy() {
            super(auth -> auth instanceof AbstractAuthenticationToken);
        }

        public Optional<TenantAuthentication<String>> extractWithPrior(Optional<TenantAuthentication<?>> priorAuthentication, Object ... args) {
            SecurityContext ctx = SecurityContextHolder.getContext();
            Authentication authentication = ctx.getAuthentication();
            if (authentication instanceof AbstractAuthenticationToken) {
                AbstractAuthenticationToken auth = (AbstractAuthenticationToken)authentication;
                Object object = auth.getCredentials();
                if (object instanceof AbstractOAuth2Token) {
                    AbstractOAuth2Token token = (AbstractOAuth2Token)object;
                    Optional<String> optTenantId = TokenSupport.extractClaim(token.getTokenValue(), "tnt");
                    if (optTenantId.isPresent()) {
                        return Optional.of((TenantAuthentication)TO_AUTH.apply((Object)auth, (Object)token.getTokenValue(), (Object)optTenantId.get()));
                    }
                    if (priorAuthentication.isPresent()) {
                        return Optional.of((TenantAuthentication)TO_AUTH.apply((Object)auth, (Object)token.getTokenValue(), (Object)priorAuthentication.get().getTenantId()));
                    }
                    throw new IllegalStateException();
                }
                return Optional.empty();
            }
            throw new IllegalStateException();
        }

        public int priority() {
            return 1000;
        }
    }
}

