/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.ehrbase.cache.CacheProperties;
import org.ehrbase.cache.CacheProvider;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CacheProperties.class})
@EnableCaching
public class CacheConfiguration {
    @Bean
    @ConditionalOnExpression(value="T(org.springframework.boot.autoconfigure.cache.CacheType).CAFFEINE.name().equalsIgnoreCase(\"${spring.cache.type}\")")
    public CacheManagerCustomizer<CaffeineCacheManager> cacheManagerCustomizer(CacheProperties cacheProperties) {
        return cm -> {
            cm.registerCustomCache(CacheProvider.INTROSPECT_CACHE.name(), Caffeine.newBuilder().build());
            cm.registerCustomCache(CacheProvider.TEMPLATE_UUID_ID_CACHE.name(), Caffeine.newBuilder().build());
            cm.registerCustomCache(CacheProvider.TEMPLATE_ID_UUID_CACHE.name(), Caffeine.newBuilder().build());
            cm.registerCustomCache(CacheProvider.USER_ID_CACHE.name(), CacheConfiguration.configureCache((Caffeine<Object, Object>)Caffeine.newBuilder(), cacheProperties.getUserIdCacheConfig()).build());
            cm.registerCustomCache(CacheProvider.EXTERNAL_FHIR_TERMINOLOGY_CACHE.name(), CacheConfiguration.configureCache((Caffeine<Object, Object>)Caffeine.newBuilder(), cacheProperties.getExternalFhirTerminologyCacheConfig()).build());
        };
    }

    private static Caffeine<Object, Object> configureCache(Caffeine<Object, Object> caffeine, CacheProperties.CacheConfig cacheConfig) {
        if (cacheConfig.getExpireAfterWrite() != null) {
            caffeine.expireAfterWrite(cacheConfig.getExpireAfterWrite().getDuration(), cacheConfig.getExpireAfterWrite().getUnit());
        }
        if (cacheConfig.getExpireAfterAccess() != null) {
            caffeine.expireAfterAccess(cacheConfig.getExpireAfterAccess().getDuration(), cacheConfig.getExpireAfterAccess().getUnit());
        }
        return caffeine;
    }
}

