/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.StoredQueryRecord;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.service.TimeProvider;
import org.ehrbase.util.SemVer;
import org.ehrbase.util.StoredQueryQualifiedName;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.LikeEscapeStep;
import org.jooq.OrderField;
import org.jooq.SelectConditionStep;
import org.jooq.SelectSeekStepN;
import org.jooq.SelectWhereStep;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

@Repository
public class StoredQueryRepository {
    private final DSLContext context;
    private final TimeProvider timeProvider;

    public StoredQueryRepository(DSLContext context, TimeProvider timeProvider) {
        this.context = context;
        this.timeProvider = timeProvider;
    }

    public void store(String qualifiedQueryName, SemVer version, String sourceAqlText) {
        StoredQueryRecord storedQueryRecord = this.createStoredQueryRecord(qualifiedQueryName, version, sourceAqlText);
        storedQueryRecord.insert();
    }

    public void update(String qualifiedQueryName, SemVer version, String sourceAqlText) {
        StoredQueryRecord storedQueryRecord = this.createStoredQueryRecord(qualifiedQueryName, version, sourceAqlText);
        storedQueryRecord.update();
    }

    public Optional<StoredQueryRecord> retrieveQualified(String qualifiedName, @NonNull SemVer version) {
        Optional queryRecord;
        StoredQueryQualifiedName qn = new StoredQueryQualifiedName(qualifiedName, version);
        SemVer semVer = qn.semVer();
        Condition condition = StoredQueryRepository.nameConstraint(qn);
        condition = condition.and(StoredQueryRepository.versionConstraint(semVer));
        SelectConditionStep unordered = this.context.selectFrom((TableLike)Tables.STORED_QUERY).where(condition);
        if (semVer.isRelease() || semVer.isPreRelease()) {
            queryRecord = unordered.fetchOptional();
        } else {
            SelectSeekStepN ordered = unordered.orderBy(StoredQueryRepository.orderBySemVerStream(SortOrder.DESC).toList());
            queryRecord = ordered.limit((Number)1).fetchOptional();
        }
        return queryRecord;
    }

    public void delete(String qualifiedName, @NonNull SemVer version) {
        StoredQueryRecord storedQuery = this.retrieveQualified(qualifiedName, version).orElseThrow(() -> new ObjectNotFoundException("STORED_QUERY", "No Stored Query with %s and %s".formatted(qualifiedName, version)));
        storedQuery.delete();
    }

    public List<QueryDefinitionResultDto> retrieveQualifiedList(String qualifiedQueryName) {
        String reverseDomainName;
        String semanticId;
        SelectWhereStep selection = this.context.selectFrom((TableLike)Tables.STORED_QUERY);
        if (StringUtils.isEmpty((CharSequence)qualifiedQueryName)) {
            semanticId = null;
            reverseDomainName = null;
        } else {
            int pos = qualifiedQueryName.indexOf("::");
            if (pos < 0) {
                reverseDomainName = null;
                semanticId = qualifiedQueryName;
            } else {
                reverseDomainName = (String)StringUtils.defaultIfEmpty((CharSequence)qualifiedQueryName.substring(0, pos), null);
                semanticId = (String)StringUtils.defaultIfEmpty((CharSequence)qualifiedQueryName.substring(pos + 2), null);
            }
        }
        ArrayList<Condition> constraints = new ArrayList<Condition>();
        ArrayList<SortField> orderFields = new ArrayList<SortField>();
        if (reverseDomainName == null) {
            orderFields.add(Tables.STORED_QUERY.REVERSE_DOMAIN_NAME.sort(SortOrder.ASC));
        } else {
            constraints.add(Tables.STORED_QUERY.REVERSE_DOMAIN_NAME.eq((Object)reverseDomainName));
        }
        if (semanticId == null) {
            orderFields.add(Tables.STORED_QUERY.SEMANTIC_ID.sort(SortOrder.ASC));
        } else {
            constraints.add(Tables.STORED_QUERY.SEMANTIC_ID.eq((Object)semanticId));
        }
        Object unordered = constraints.isEmpty() ? selection : selection.where(constraints);
        List<OrderField<?>> sortOrder = Stream.concat(orderFields.stream(), StoredQueryRepository.orderBySemVerStream(SortOrder.DESC)).toList();
        try (Stream stream = unordered.orderBy(sortOrder).stream();){
            List<QueryDefinitionResultDto> list = stream.map(StoredQueryRepository::mapToQueryDefinitionDto).toList();
            return list;
        }
    }

    public static QueryDefinitionResultDto mapToQueryDefinitionDto(StoredQueryRecord storedQueryAccess) {
        QueryDefinitionResultDto dto = new QueryDefinitionResultDto();
        dto.setSaved(storedQueryAccess.getCreationDate().toZonedDateTime());
        dto.setQualifiedName(storedQueryAccess.getReverseDomainName() + "::" + storedQueryAccess.getSemanticId());
        dto.setVersion(storedQueryAccess.getSemver());
        dto.setQueryText(storedQueryAccess.getQueryText());
        dto.setType(storedQueryAccess.getType());
        return dto;
    }

    @NonNull
    private static Condition versionConstraint(SemVer semVer) {
        if (semVer.isRelease() || semVer.isPreRelease()) {
            return Tables.STORED_QUERY.SEMVER.eq((Object)semVer.toVersionString());
        }
        Condition noPreRelease = Tables.STORED_QUERY.SEMVER.notContains((Object)"-");
        if (semVer.isNoVersion()) {
            return noPreRelease;
        }
        LikeEscapeStep prefixMatch = Tables.STORED_QUERY.SEMVER.like(semVer.toVersionString() + ".%");
        return prefixMatch.and(noPreRelease);
    }

    private static Condition nameConstraint(StoredQueryQualifiedName storedQueryQualifiedName) {
        return Tables.STORED_QUERY.REVERSE_DOMAIN_NAME.eq((Object)storedQueryQualifiedName.reverseDomainName()).and(Tables.STORED_QUERY.SEMANTIC_ID.eq((Object)storedQueryQualifiedName.semanticId()));
    }

    private static Stream<OrderField<?>> orderBySemVerStream(SortOrder sortOrder) {
        return Stream.of(DSL.splitPart((Field)Tables.STORED_QUERY.SEMVER, (String)".", (Number)1).cast(Integer.class).sort(sortOrder), DSL.splitPart((Field)Tables.STORED_QUERY.SEMVER, (String)".", (Number)2).cast(Integer.class).sort(sortOrder), DSL.splitPart((Field)DSL.splitPart((Field)Tables.STORED_QUERY.SEMVER, (String)".", (Number)3), (String)"-", (Number)1).cast(Integer.class).sort(sortOrder), DSL.splitPart((Field)DSL.splitPart((Field)Tables.STORED_QUERY.SEMVER, (String)".", (Number)3), (String)"-", (Number)2).sort(sortOrder));
    }

    private StoredQueryRecord createStoredQueryRecord(String qualifiedQueryName, SemVer version, String sourceAqlText) {
        StoredQueryRecord storedQueryRecord = (StoredQueryRecord)this.context.newRecord((Table)Tables.STORED_QUERY);
        StoredQueryQualifiedName qn = new StoredQueryQualifiedName(qualifiedQueryName, version);
        storedQueryRecord.setReverseDomainName(qn.reverseDomainName());
        storedQueryRecord.setSemanticId(qn.semanticId());
        storedQueryRecord.setSemver(version.toVersionString());
        storedQueryRecord.setQueryText(sourceAqlText);
        storedQueryRecord.setType("AQL");
        storedQueryRecord.setCreationDate(this.timeProvider.getNow());
        return storedQueryRecord;
    }
}

