/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.GeneralRequestProcessingException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.StoredQueryService;
import org.ehrbase.jooq.pg.tables.records.StoredQueryRecord;
import org.ehrbase.openehr.sdk.aql.parser.AqlParseException;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.repository.StoredQueryRepository;
import org.ehrbase.util.InvalidVersionFormatException;
import org.ehrbase.util.SemVer;
import org.ehrbase.util.SemVerUtil;
import org.ehrbase.util.VersionConflictException;
import org.jooq.exception.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class StoredQueryServiceImp
implements StoredQueryService {
    private final StoredQueryRepository storedQueryRepository;

    public StoredQueryServiceImp(StoredQueryRepository storedQueryRepository) {
        this.storedQueryRepository = storedQueryRepository;
    }

    public List<QueryDefinitionResultDto> retrieveStoredQueries(String fullyQualifiedName) {
        String name = (String)StringUtils.defaultIfEmpty((CharSequence)fullyQualifiedName, null);
        try {
            return this.storedQueryRepository.retrieveQualifiedList(name);
        }
        catch (DataAccessException e) {
            throw new GeneralRequestProcessingException("Data Access Error: " + e.getCause().getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not retrieve stored query, reason: " + String.valueOf(e), e);
        }
    }

    public QueryDefinitionResultDto retrieveStoredQuery(String qualifiedName, String version) {
        Optional<StoredQueryRecord> storedQueryAccess;
        SemVer requestedVersion = StoredQueryServiceImp.parseRequestSemVer(version);
        try {
            storedQueryAccess = this.storedQueryRepository.retrieveQualified(qualifiedName, requestedVersion);
        }
        catch (DataAccessException e) {
            throw new GeneralRequestProcessingException("Data Access Error: " + e.getCause().getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new InternalServerException(e.getMessage());
        }
        return storedQueryAccess.map(StoredQueryRepository::mapToQueryDefinitionDto).orElseThrow(() -> new IllegalArgumentException("Could not retrieve stored query for qualified name: " + qualifiedName));
    }

    public QueryDefinitionResultDto createStoredQuery(String qualifiedName, String version, String queryString) {
        SemVer requestedVersion = StoredQueryServiceImp.parseRequestSemVer(version);
        try {
            AqlQueryParser.parse((String)queryString);
        }
        catch (AqlParseException e) {
            throw new IllegalArgumentException("Invalid query, reason:" + String.valueOf((Object)e), e);
        }
        SemVer dbSemVer = this.storedQueryRepository.retrieveQualified(qualifiedName, requestedVersion).map(q -> SemVer.parse(q.getSemver())).orElse(SemVer.NO_VERSION);
        StoredQueryServiceImp.checkVersionCombination(requestedVersion, dbSemVer);
        SemVer newVersion = SemVerUtil.determineVersion(requestedVersion, dbSemVer);
        boolean isUpdate = dbSemVer.isPreRelease();
        try {
            if (isUpdate) {
                this.storedQueryRepository.update(qualifiedName, newVersion, queryString);
            } else {
                this.storedQueryRepository.store(qualifiedName, newVersion, queryString);
            }
        }
        catch (DataAccessException e) {
            throw new GeneralRequestProcessingException("Data Access Error: " + e.getCause().getMessage(), (Throwable)e);
        }
        catch (VersionConflictException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return this.storedQueryRepository.retrieveQualified(qualifiedName, newVersion).map(StoredQueryRepository::mapToQueryDefinitionDto).orElseThrow();
    }

    private static void checkVersionCombination(SemVer requestSemVer, SemVer dbSemVer) {
        if (!dbSemVer.isNoVersion()) {
            if (dbSemVer.isPartial()) {
                throw new IllegalStateException("The database contains stored queries with partial versions");
            }
            if (dbSemVer.isPreRelease()) {
                if (!requestSemVer.isPreRelease()) {
                    throw new RuntimeException("Pre-release " + String.valueOf(dbSemVer) + " was provided when " + String.valueOf(requestSemVer) + " was requested");
                }
            } else {
                if (requestSemVer.isPreRelease()) {
                    throw new RuntimeException("Version " + String.valueOf(dbSemVer) + " was provided when pre-release " + String.valueOf(requestSemVer) + " was requested");
                }
                if (requestSemVer.isRelease()) {
                    throw new StateConflictException("Version already exists");
                }
            }
        }
    }

    public void deleteStoredQuery(String qualifiedName, String version) {
        SemVer requestedVersion = StoredQueryServiceImp.parseRequestSemVer(version);
        if (requestedVersion.isNoVersion() || requestedVersion.isPartial()) {
            throw new InvalidApiParameterException("A qualified version has to be specified");
        }
        try {
            this.storedQueryRepository.delete(qualifiedName, SemVer.parse(version));
        }
        catch (ObjectNotFoundException e) {
            throw e;
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (RuntimeException e) {
            throw new InternalServerException(e.getMessage());
        }
    }

    private static SemVer parseRequestSemVer(String version) {
        try {
            return SemVer.parse(version);
        }
        catch (InvalidVersionFormatException e) {
            throw new InvalidApiParameterException("Incorrect version. Use the SEMVER format.", (Throwable)e);
        }
    }
}

