/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.util;

import org.ehrbase.util.SemVer;
import org.springframework.lang.NonNull;

public final class StoredQueryQualifiedName {
    private final String reverseDomainName;
    private final String semanticId;
    private final SemVer semVer;

    public StoredQueryQualifiedName(@NonNull String qualifiedName, @NonNull SemVer version) {
        String[] nameParts = qualifiedName.split("::");
        if (nameParts.length != 2 || qualifiedName.contains("/")) {
            throw new IllegalArgumentException("Qualified name is not valid (https://specifications.openehr.org/releases/SM/latest/openehr_platform.html#_query_package):" + qualifiedName);
        }
        this.reverseDomainName = nameParts[0];
        this.semanticId = nameParts[1];
        this.semVer = version;
    }

    public String reverseDomainName() {
        return this.reverseDomainName;
    }

    public String semanticId() {
        return this.semanticId;
    }

    public SemVer semVer() {
        return this.semVer;
    }

    public boolean hasVersion() {
        return !this.semVer.isNoVersion();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.reverseDomainName).append("::").append(this.semanticId);
        if (!this.semVer.isNoVersion()) {
            sb.append('/').append(this.semVer);
        }
        return sb.toString();
    }
}

