/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.ehr.VersionedComposition;
import com.nedap.archie.rm.generic.Attestation;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.generic.RevisionHistoryItem;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.ehrbase.api.exception.BadGatewayException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionFormat;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.StructuredString;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.StructuredStringFormat;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.FlatFormat;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.FlatJasonProvider;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.openehr.sdk.serialisation.xmlencoding.CanonicalXML;
import org.ehrbase.openehr.sdk.validation.ValidationException;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.templateprovider.TemplateProvider;
import org.ehrbase.repository.AbstractVersionedObjectRepository;
import org.ehrbase.repository.CompositionRepository;
import org.ehrbase.service.KnowledgeCacheServiceImp;
import org.ehrbase.util.UuidGenerator;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service
public class CompositionServiceImp
implements CompositionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ValidationService validationService;
    private final KnowledgeCacheServiceImp knowledgeCacheService;
    private final EhrService ehrService;
    private final CompositionRepository compositionRepository;
    private final SystemService systemService;

    public CompositionServiceImp(KnowledgeCacheServiceImp knowledgeCacheService, ValidationService validationService, EhrService ehrService, SystemService systemService, CompositionRepository compositionRepository) {
        this.validationService = validationService;
        this.ehrService = ehrService;
        this.knowledgeCacheService = knowledgeCacheService;
        this.compositionRepository = compositionRepository;
        this.systemService = systemService;
    }

    public Optional<UUID> create(UUID ehrId, Composition objData, UUID contribution, UUID audit) {
        UUID compositionId = this.createInternal(ehrId, objData, contribution, audit);
        return Optional.of(compositionId);
    }

    public Optional<UUID> create(UUID ehrId, Composition objData) {
        UUID compositionId = this.createInternal(ehrId, objData, null, null);
        return Optional.of(compositionId);
    }

    private UUID createInternal(UUID ehrId, Composition composition, UUID contributionId, UUID audit) {
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        try {
            this.validationService.check(composition);
        }
        catch (BadGatewayException | UnprocessableEntityException | org.ehrbase.api.exception.ValidationException e) {
            throw e;
        }
        catch (ValidationException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new org.ehrbase.api.exception.ValidationException((Exception)e);
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
        ObjectVersionId objectVersionId = this.checkOrConstructObjectVersionId(composition.getUid());
        composition.setUid((UIDBasedId)objectVersionId);
        UUID compositionId = AbstractVersionedObjectRepository.extractUid((UIDBasedId)objectVersionId);
        this.compositionRepository.commit(ehrId, composition, contributionId, audit);
        this.logger.debug("Composition created: id={}", (Object)compositionId);
        return compositionId;
    }

    private ObjectVersionId checkOrConstructObjectVersionId(@Nullable UIDBasedId uid) {
        if (uid == null) {
            return AbstractVersionedObjectRepository.buildObjectVersionId(UuidGenerator.randomUUID(), 1, this.systemService);
        }
        if (uid instanceof ObjectVersionId) {
            ObjectVersionId objectVersionId = (ObjectVersionId)uid;
            if (!"1".equals(objectVersionId.getVersionTreeId().getValue())) {
                throw new PreconditionFailedException("Provided Id %s has a invalid Version. Expect Version 1".formatted(uid));
            }
            if (!Objects.equals(this.systemService.getSystemId(), objectVersionId.getCreatingSystemId().getValue())) {
                throw new PreconditionFailedException("Mismatch of creating_system_id: %s !=: %s".formatted(objectVersionId.getCreatingSystemId().getValue(), this.systemService.getSystemId()));
            }
            if (this.compositionRepository.exists(UUID.fromString(objectVersionId.getObjectId().getValue()))) {
                throw new PreconditionFailedException("Provided Id %s already exists".formatted(uid));
            }
            return (ObjectVersionId)uid;
        }
        throw new PreconditionFailedException("Provided Id %s is not a ObjectVersionId".formatted(uid));
    }

    public Optional<UUID> update(UUID ehrId, ObjectVersionId targetObjId, Composition objData, UUID contribution, UUID audit) {
        UUID compoId = this.internalUpdate(ehrId, targetObjId, objData, contribution, audit);
        return Optional.of(compoId);
    }

    public Optional<UUID> update(UUID ehrId, ObjectVersionId targetObjId, Composition objData) {
        UUID compoId = this.internalUpdate(ehrId, targetObjId, objData, null, null);
        return Optional.of(compoId);
    }

    private UUID internalUpdate(UUID ehrId, ObjectVersionId compositionId, Composition composition, UUID contributionId, UUID audit) {
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        try {
            this.validationService.check(composition);
        }
        catch (ValidationException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
        catch (UnprocessableEntityException | org.ehrbase.api.exception.ValidationException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new org.ehrbase.api.exception.ValidationException((Exception)e);
        }
        catch (Exception e) {
            throw new InternalServerException((Throwable)e);
        }
        UUID compId = UUID.fromString(compositionId.getObjectId().getValue());
        int version = Integer.parseInt(compositionId.getVersionTreeId().getValue());
        String existingTemplateId = this.compositionRepository.findTemplateId(compId).orElseThrow(() -> new ObjectNotFoundException("composition", "No COMPOSITION with given id: %s".formatted(compId)));
        String inputTemplateId = composition.getArchetypeDetails().getTemplateId().getValue();
        if (!existingTemplateId.equals(inputTemplateId)) {
            if (!existingTemplateId.split("\\.")[0].equals(inputTemplateId.split("\\.")[0])) {
                throw new InvalidApiParameterException("Can't update composition to have different template.");
            }
            int existingTemplateIdVersion = Integer.parseInt(existingTemplateId.split("\\.v")[1]);
            int inputTemplateIdVersion = Integer.parseInt(inputTemplateId.substring(inputTemplateId.lastIndexOf("\\.v") + 1));
            if (inputTemplateIdVersion < existingTemplateIdVersion) {
                throw new InvalidApiParameterException("Can't update composition with wrong template version bump.");
            }
        }
        composition.setUid((UIDBasedId)AbstractVersionedObjectRepository.buildObjectVersionId(compId, version + 1, this.systemService));
        this.compositionRepository.update(ehrId, composition, contributionId, audit);
        return compId;
    }

    public void delete(UUID ehrId, ObjectVersionId targetObjId, UUID contribution, UUID audit) {
        this.internalDelete(ehrId, targetObjId, contribution, audit);
    }

    public void delete(UUID ehrId, ObjectVersionId targetObjId) {
        this.internalDelete(ehrId, targetObjId, null, null);
    }

    private void internalDelete(UUID ehrId, ObjectVersionId compositionId, UUID contributionId, UUID audit) {
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        this.compositionRepository.delete(ehrId, UUID.fromString(compositionId.getObjectId().getValue()), AbstractVersionedObjectRepository.extractVersion((UIDBasedId)compositionId), contributionId, audit);
    }

    public Optional<Composition> retrieve(UUID ehrId, UUID compositionId, Integer version) throws InternalServerException {
        Optional<Composition> result = version == null ? this.compositionRepository.findHead(ehrId, compositionId) : this.compositionRepository.findByVersion(ehrId, compositionId, (int)version);
        if (result.isEmpty()) {
            this.ehrService.checkEhrExists(ehrId);
        }
        return result;
    }

    public UUID getEhrId(UUID compositionId) {
        return this.compositionRepository.findEHRforComposition(compositionId).orElseThrow();
    }

    public StructuredString serialize(CompositionDto composition, CompositionFormat format) {
        return switch (format) {
            case CompositionFormat.XML -> new StructuredString(new CanonicalXML().marshal((RMObject)composition.getComposition(), Boolean.valueOf(false)), StructuredStringFormat.XML);
            case CompositionFormat.JSON -> new StructuredString(new CanonicalJson().marshal((RMObject)composition.getComposition()), StructuredStringFormat.JSON);
            case CompositionFormat.FLAT -> new StructuredString(new FlatJasonProvider(this.createTemplateProvider()).buildFlatJson(FlatFormat.SIM_SDT, composition.getTemplateId()).marshal((RMObject)composition.getComposition()), StructuredStringFormat.JSON);
            case CompositionFormat.STRUCTURED -> new StructuredString(new FlatJasonProvider(this.createTemplateProvider()).buildFlatJson(FlatFormat.STRUCTURED, composition.getTemplateId()).marshal((RMObject)composition.getComposition()), StructuredStringFormat.JSON);
            default -> throw new UnexpectedSwitchCaseException((Enum)format);
        };
    }

    public Composition buildComposition(String content, CompositionFormat format, String templateId) {
        return switch (format) {
            case CompositionFormat.XML -> (Composition)new CanonicalXML().unmarshal(content, Composition.class);
            case CompositionFormat.JSON -> (Composition)new CanonicalJson().unmarshal(content, Composition.class);
            case CompositionFormat.FLAT -> new FlatJasonProvider(this.createTemplateProvider()).buildFlatJson(FlatFormat.SIM_SDT, templateId).unmarshal(content);
            case CompositionFormat.STRUCTURED -> new FlatJasonProvider(this.createTemplateProvider()).buildFlatJson(FlatFormat.STRUCTURED, templateId).unmarshal(content);
            default -> throw new UnexpectedSwitchCaseException((Enum)format);
        };
    }

    private TemplateProvider createTemplateProvider() {
        return new TemplateProvider(){

            public Optional<OPERATIONALTEMPLATE> find(String s) {
                return CompositionServiceImp.this.knowledgeCacheService.retrieveOperationalTemplate(s);
            }

            public Optional<WebTemplate> buildIntrospect(String templateId) {
                if (templateId == null) {
                    return Optional.empty();
                }
                return Optional.ofNullable(CompositionServiceImp.this.knowledgeCacheService.getQueryOptMetaData(templateId));
            }
        };
    }

    public int getLastVersionNumber(UUID compositionId) {
        Optional<Integer> versionNumber = this.compositionRepository.getLatestVersionNumber(compositionId);
        return versionNumber.orElseThrow(() -> new ObjectNotFoundException("composition", "No COMPOSITION with given id: %s".formatted(compositionId)));
    }

    public int getVersionByTimestamp(UUID compositionId, OffsetDateTime timestamp) {
        Optional<Integer> versionByTime = this.compositionRepository.findVersionByTime(compositionId, timestamp);
        return versionByTime.orElseThrow(() -> new ObjectNotFoundException("composition", "No COMPOSITION with given id: %s".formatted(compositionId)));
    }

    public String getTemplateIdFromInputComposition(String content, CompositionFormat format) {
        Composition composition = this.buildComposition(content, format, null);
        if (composition.getArchetypeDetails() == null || composition.getArchetypeDetails().getTemplateId() == null) {
            return null;
        }
        return composition.getArchetypeDetails().getTemplateId().getValue();
    }

    public String retrieveTemplateId(UUID compositionId) {
        return this.compositionRepository.findTemplateId(compositionId).orElseThrow();
    }

    public boolean exists(UUID versionedObjectId) {
        return this.compositionRepository.exists(versionedObjectId);
    }

    public boolean isDeleted(UUID ehrId, UUID versionedObjectId, Integer version) {
        if (version == null) {
            Optional<Integer> versionNumber = this.compositionRepository.getLatestVersionNumber(versionedObjectId);
            if (versionNumber.isEmpty()) {
                return false;
            }
            version = versionNumber.get();
        }
        return this.compositionRepository.isDeleted(ehrId, versionedObjectId, version);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDelete(UUID compositionId) {
        this.compositionRepository.adminDelete(compositionId);
    }

    public VersionedComposition getVersionedComposition(UUID ehrId, UUID composition) {
        this.ehrService.checkEhrExists(ehrId);
        Optional<VersionedComposition> versionedComposition = this.compositionRepository.getVersionedComposition(ehrId, composition);
        if (versionedComposition.isEmpty()) {
            throw new ObjectNotFoundException("versioned_composition", "No VERSIONED_COMPOSITION with given id: " + String.valueOf(composition));
        }
        return versionedComposition.get();
    }

    public RevisionHistory getRevisionHistoryOfVersionedComposition(UUID ehrUid, UUID composition) {
        int versions = this.getLastVersionNumber(composition);
        RevisionHistory revisionHistory = new RevisionHistory();
        for (int i = 1; i <= versions; ++i) {
            Optional<OriginalVersion<Composition>> compoVersion = this.getOriginalVersionComposition(ehrUid, composition, i);
            compoVersion.ifPresent(compositionOriginalVersion -> revisionHistory.addItem(this.revisionHistoryItemFromComposition((OriginalVersion<Composition>)compositionOriginalVersion)));
        }
        if (revisionHistory.getItems().isEmpty()) {
            throw new InternalServerException("Problem creating RevisionHistory");
        }
        return revisionHistory;
    }

    private RevisionHistoryItem revisionHistoryItemFromComposition(OriginalVersion<Composition> composition) {
        ObjectVersionId objectVersionId = composition.getUid();
        ArrayList<AuditDetails> auditDetailsList = new ArrayList<AuditDetails>();
        auditDetailsList.add(composition.getCommitAudit());
        if (composition.getAttestations() != null) {
            for (Attestation a : composition.getAttestations()) {
                AuditDetails newAudit = new AuditDetails(a.getSystemId(), a.getCommitter(), a.getTimeCommitted(), a.getChangeType(), a.getDescription());
                auditDetailsList.add(newAudit);
            }
        }
        return new RevisionHistoryItem(objectVersionId, auditDetailsList);
    }

    public Optional<OriginalVersion<Composition>> getOriginalVersionComposition(UUID ehrUid, UUID versionedObjectUid, int version) {
        return this.compositionRepository.getOriginalVersionComposition(ehrUid, versionedObjectUid, version);
    }
}

