/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UID;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import com.nedap.archie.rm.support.identification.VersionTreeId;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.repository.AbstractVersionedObjectRepository;
import org.ehrbase.repository.EhrFolderRepository;
import org.ehrbase.service.InternalDirectoryService;
import org.ehrbase.util.FolderUtils;
import org.ehrbase.util.UuidGenerator;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DirectoryServiceImp
implements InternalDirectoryService {
    private final SystemService systemService;
    private final EhrService ehrService;
    private final EhrFolderRepository ehrFolderRepository;

    public DirectoryServiceImp(SystemService systemService, EhrService ehrService, EhrFolderRepository ehrFolderRepository) {
        this.systemService = systemService;
        this.ehrService = ehrService;
        this.ehrFolderRepository = ehrFolderRepository;
    }

    public Optional<Folder> get(UUID ehrId, @Nullable ObjectVersionId folderId, @Nullable String path) {
        Optional<Folder> root;
        if (folderId == null) {
            root = this.ehrFolderRepository.findHead(ehrId, 1);
        } else {
            VersionTreeId versionTreeId = folderId.getVersionTreeId();
            if (versionTreeId.isBranch()) {
                throw new UnsupportedOperationException("Version branching is not supported: %s".formatted(versionTreeId.getValue()));
            }
            if (!folderId.getCreatingSystemId().getValue().equals(this.systemService.getSystemId())) {
                return Optional.empty();
            }
            int version = Integer.parseInt(versionTreeId.getValue());
            root = this.ehrFolderRepository.findByVersion(ehrId, 1, version);
        }
        if (root.isEmpty()) {
            this.ehrService.checkEhrExists(ehrId);
            return Optional.empty();
        }
        if (folderId != null && !folderId.getRoot().equals((Object)root.get().getUid().getRoot())) {
            return Optional.empty();
        }
        return this.findByPath(root.get(), StringUtils.split((String)path, (char)'/'));
    }

    public Optional<Folder> getByTime(UUID ehrId, OffsetDateTime time, @Nullable String path) {
        Optional<ObjectVersionId> versionByTime = this.ehrFolderRepository.findVersionByTime(ehrId, 1, time);
        return versionByTime.flatMap(v -> this.ehrFolderRepository.findByVersion(ehrId, 1, AbstractVersionedObjectRepository.extractVersion((UIDBasedId)v))).flatMap(f -> this.findByPath((Folder)f, StringUtils.split((String)path, (char)'/')));
    }

    private Optional<Folder> findByPath(Folder root, String[] path) {
        if (ArrayUtils.isEmpty((Object[])path)) {
            return Optional.of(root);
        }
        if (root.getFolders() == null) {
            return Optional.empty();
        }
        return root.getFolders().stream().filter(sf -> sf.getNameAsString().equals(path[0])).findAny().flatMap(sf -> this.findByPath((Folder)sf, (String[])ArrayUtils.subarray((Object[])path, (int)1, (int)path.length)));
    }

    public Folder create(UUID ehrId, Folder folder) {
        return this.create(ehrId, folder, null, null);
    }

    @Override
    public Folder create(UUID ehrId, Folder folder, UUID contributionId, UUID auditId) {
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        if (this.ehrFolderRepository.hasFolder(ehrId, 1)) {
            throw new StateConflictException("EHR with id %s already contains a directory.".formatted(ehrId));
        }
        FolderUtils.checkSiblingNameConflicts(folder);
        this.updateUuid(folder, true, Optional.ofNullable(folder.getUid()).map(UIDBasedId::getRoot).map(UID::getValue).map(UUID::fromString).orElse(UuidGenerator.randomUUID()), 1);
        this.ehrFolderRepository.commit(ehrId, folder, contributionId, auditId, 1);
        return this.get(ehrId, null, null).orElseThrow();
    }

    public Folder update(UUID ehrId, Folder folder, ObjectVersionId ifMatches) {
        return this.update(ehrId, folder, ifMatches, null, null);
    }

    @Override
    public Folder update(UUID ehrId, Folder folder, ObjectVersionId ifMatches, UUID contributionId, UUID auditId) {
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        if (!this.ehrFolderRepository.hasFolder(ehrId, 1)) {
            throw new PreconditionFailedException(String.format("EHR with id %s does not contain a directory.", ehrId.toString()));
        }
        FolderUtils.checkSiblingNameConflicts(folder);
        int version = Integer.parseInt(ifMatches.getVersionTreeId().getValue());
        this.updateUuid(folder, true, UUID.fromString(ifMatches.getObjectId().getValue()), version + 1);
        this.ehrFolderRepository.update(ehrId, folder, contributionId, auditId, 1);
        return this.get(ehrId, null, null).orElseThrow();
    }

    public void delete(UUID ehrId, ObjectVersionId ifMatches) {
        this.delete(ehrId, ifMatches, null, null);
    }

    @Override
    public void delete(UUID ehrId, ObjectVersionId ifMatches, UUID contributionId, UUID auditId) {
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        if (!this.ehrFolderRepository.hasFolder(ehrId, 1)) {
            throw new PreconditionFailedException("EHR with id %s does not contain a directory.".formatted(ehrId));
        }
        this.ehrFolderRepository.delete(ehrId, UUID.fromString(ifMatches.getObjectId().getValue()), Integer.parseInt(ifMatches.getVersionTreeId().getValue()), 1, contributionId, auditId);
    }

    private void updateUuid(Folder folder, boolean root, UUID rootUuid, int version) {
        if (folder.getUid() == null || root) {
            if (root) {
                folder.setUid((UIDBasedId)new ObjectVersionId(String.valueOf(rootUuid) + "::" + this.systemService.getSystemId() + "::" + version));
            } else {
                folder.setUid((UIDBasedId)new HierObjectId(UuidGenerator.randomUUID().toString()));
            }
        }
        if (folder.getFolders() != null) {
            folder.getFolders().forEach(folder1 -> this.updateUuid((Folder)folder1, false, rootUuid, version));
        }
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDeleteFolder(UUID ehrId, UUID folderId) {
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("Admin Directory", "EHR with id %s does not exist".formatted(ehrId));
        }
        Optional<Folder> latest = this.ehrFolderRepository.findHead(ehrId, 1);
        if (latest.isPresent()) {
            Folder from = latest.get();
            if (!UUID.fromString(from.getUid().getRoot().getValue()).equals(folderId)) {
                throw new IllegalArgumentException("FolderIds do not match");
            }
            this.ehrFolderRepository.adminDelete(ehrId, 1);
        }
    }
}

