/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.cache;

import com.ethlo.cache.spring.EnhancedTransactionAwareCacheDecorator;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collection;
import java.util.function.Function;
import org.ehrbase.cache.CacheProperties;
import org.ehrbase.cache.CacheProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CacheProperties.class})
@EnableCaching
public class CacheConfiguration {
    @Bean
    @ConditionalOnExpression(value="T(org.springframework.boot.autoconfigure.cache.CacheType).CAFFEINE.name().equalsIgnoreCase(\"${spring.cache.type}\")")
    public CacheManagerCustomizer<CaffeineCacheManager> cacheManagerCustomizer(CacheProperties cacheProperties) {
        return cm -> this.configureCaffeineCacheManager((CaffeineCacheManager)cm, cacheProperties, CacheProvider.EhrBaseCache::name);
    }

    protected void configureCaffeineCacheManager(CaffeineCacheManager cacheManager, CacheProperties cacheProperties, Function<CacheProvider.EhrBaseCache<?, ?>, String> createCacheName) {
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.INTROSPECT_CACHE), Caffeine.newBuilder().build());
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.TEMPLATE_UUID_ID_CACHE), Caffeine.newBuilder().build());
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.TEMPLATE_ID_UUID_CACHE), Caffeine.newBuilder().build());
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.USER_ID_CACHE), CacheConfiguration.configureCache((Caffeine<Object, Object>)Caffeine.newBuilder(), cacheProperties.getUserIdCacheConfig()).build());
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.EXTERNAL_FHIR_TERMINOLOGY_CACHE), CacheConfiguration.configureCache((Caffeine<Object, Object>)Caffeine.newBuilder(), cacheProperties.getExternalFhirTerminologyCacheConfig()).build());
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.STORED_QUERY_CACHE), Caffeine.newBuilder().build());
    }

    protected static Caffeine<Object, Object> configureCache(Caffeine<Object, Object> caffeine, CacheProperties.CacheConfig cacheConfig) {
        if (cacheConfig.getExpireAfterWrite() != null) {
            caffeine.expireAfterWrite(cacheConfig.getExpireAfterWrite().getDuration(), cacheConfig.getExpireAfterWrite().getUnit());
        }
        if (cacheConfig.getExpireAfterAccess() != null) {
            caffeine.expireAfterAccess(cacheConfig.getExpireAfterAccess().getDuration(), cacheConfig.getExpireAfterAccess().getUnit());
        }
        return caffeine;
    }

    @Bean
    public static BeanPostProcessor cacheManagerTxProxyBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) {
                if (bean instanceof CacheManager) {
                    CacheManager cm = (CacheManager)bean;
                    return new CustomTxAwareCacheManagerProxy(cm);
                }
                return bean;
            }
        };
    }

    public static class CustomTxAwareCacheManagerProxy
    implements CacheManager {
        private final CacheManager targetCacheManager;

        public CustomTxAwareCacheManagerProxy(CacheManager targetCacheManager) {
            if (targetCacheManager == null) {
                throw new IllegalArgumentException("Property 'targetCacheManager' is required");
            }
            this.targetCacheManager = targetCacheManager;
        }

        public CacheManager getTargetCacheManager() {
            return this.targetCacheManager;
        }

        @Nullable
        public Cache getCache(String name) {
            Cache targetCache = this.targetCacheManager.getCache(name);
            return targetCache != null ? new EnhancedTransactionAwareCacheDecorator(targetCache, true, false) : null;
        }

        public Collection<String> getCacheNames() {
            return this.targetCacheManager.getCacheNames();
        }
    }
}

