/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.jooq.pg.tables.EhrFolderData;
import org.ehrbase.jooq.pg.tables.EhrFolderDataHistory;
import org.ehrbase.jooq.pg.tables.EhrFolderVersion;
import org.ehrbase.jooq.pg.tables.EhrFolderVersionHistory;
import org.ehrbase.jooq.pg.tables.records.EhrFolderDataHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.EhrFolderDataRecord;
import org.ehrbase.jooq.pg.tables.records.EhrFolderVersionHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.EhrFolderVersionRecord;
import org.ehrbase.jooq.pg.util.AdditionalSQLFunctions;
import org.ehrbase.openehr.dbformat.StructureNode;
import org.ehrbase.openehr.dbformat.VersionedObjectDataStructure;
import org.ehrbase.repository.AbstractVersionedObjectRepository;
import org.ehrbase.repository.AuditDetailsTargetType;
import org.ehrbase.repository.ContributionRepository;
import org.ehrbase.service.TimeProvider;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class EhrFolderRepository
extends AbstractVersionedObjectRepository<EhrFolderVersionRecord, EhrFolderDataRecord, EhrFolderVersionHistoryRecord, EhrFolderDataHistoryRecord, Folder> {
    public EhrFolderRepository(DSLContext context, ContributionRepository contributionRepository, SystemService systemService, TimeProvider timeProvider) {
        super(AuditDetailsTargetType.EHR_FOLDER, EhrFolderVersion.EHR_FOLDER_VERSION, EhrFolderData.EHR_FOLDER_DATA, EhrFolderVersionHistory.EHR_FOLDER_VERSION_HISTORY, EhrFolderDataHistory.EHR_FOLDER_DATA_HISTORY, context, contributionRepository, systemService, timeProvider);
    }

    @Override
    protected List<TableField<EhrFolderVersionRecord, ?>> getVersionDataJoinFields() {
        return List.of(Tables.EHR_FOLDER_VERSION.EHR_ID, Tables.EHR_FOLDER_VERSION.EHR_FOLDERS_IDX);
    }

    @Override
    protected Field<JSONB> jsonbDataAggregation(Table<?> dataTable) {
        Field dataField = dataTable.field((Field)EhrFolderRepository.DATA_PROTOTYPE.DATA);
        Field uuidsField = dataTable.field((Field)EhrFolderData.EHR_FOLDER_DATA.ITEM_UUIDS);
        return DSL.jsonbObjectAgg((Field)dataTable.field((Field)EhrFolderRepository.DATA_PROTOTYPE.ENTITY_IDX), (Field)DSL.case_().when(DSL.cardinality((Field)uuidsField).eq((Field)DSL.inline((int)0)), dataField).else_(AdditionalSQLFunctions.jsonb_set((Field)dataField, (Field)AdditionalSQLFunctions.array_to_jsonb((Field)uuidsField), (String[])new String[]{"IA"}))).as(DSL.name((String)"data"));
    }

    @Transactional
    public void commit(UUID ehrId, Folder folder, @Nullable UUID contributionId, @Nullable UUID auditId, int ehrFoldersIdx) {
        this.commitHead(ehrId, (Locatable)folder, contributionId, auditId, ContributionChangeType.creation, r -> r.setEhrFoldersIdx(Integer.valueOf(ehrFoldersIdx)), (n, r) -> this.addExtraFolderData(ehrId, ehrFoldersIdx, (StructureNode)n, (EhrFolderDataRecord)r));
    }

    private void addExtraFolderData(UUID ehrId, int ehrFoldersIdx, StructureNode n, EhrFolderDataRecord r) {
        JsonNode itemsNode = n.getJsonNode().remove("items");
        r.setItemUuids(this.getItemUuids(itemsNode));
        if (itemsNode != null) {
            r.setData(JSONB.valueOf((String)VersionedObjectDataStructure.applyRmAliases((ObjectNode)n.getJsonNode()).toString()));
        }
        r.setEhrId(ehrId);
        r.setEhrFoldersIdx(Integer.valueOf(ehrFoldersIdx));
    }

    private UUID[] getItemUuids(JsonNode itemsNode) {
        if (itemsNode == null) {
            return new UUID[0];
        }
        int size = itemsNode.size();
        if (size == 0) {
            return new UUID[0];
        }
        UUID[] result = new UUID[size];
        for (int i = 0; i < size; ++i) {
            String uuidText = itemsNode.get(i).get("id").get("value").asText();
            try {
                result[i] = UUID.fromString(uuidText);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Only UUIDs are supported as FOLDER.items.id.value");
            }
        }
        return result;
    }

    @Transactional
    public void update(UUID ehrId, Folder folder, @Nullable UUID contributionId, @Nullable UUID auditId, int ehrFoldersIdx) {
        this.update(ehrId, folder, this.singleFolderCondition(ehrId, ehrFoldersIdx, this.tables.versionHead()), this.singleFolderCondition(ehrId, ehrFoldersIdx, this.tables.versionHistory()), contributionId, auditId, r -> r.setEhrFoldersIdx(Integer.valueOf(ehrFoldersIdx)), (n, r) -> this.addExtraFolderData(ehrId, ehrFoldersIdx, (StructureNode)n, (EhrFolderDataRecord)r), "No FOLDER in ehr: %s".formatted(ehrId));
    }

    public Optional<Folder> findHead(UUID ehrId, int ehrFoldersIdx) {
        return this.findHead(this.singleFolderCondition(ehrId, ehrFoldersIdx, this.tables.versionHead()));
    }

    @Transactional
    public void delete(UUID ehrId, UUID rootFolderId, int version, int ehrFoldersIdx, UUID contributionId, UUID auditId) {
        this.delete(ehrId, this.singleFolderCondition(ehrId, ehrFoldersIdx, this.tables.versionHead()).and(this.field(EhrFolderRepository.VERSION_PROTOTYPE.VO_ID).eq((Object)rootFolderId)), version, contributionId, auditId, "No folder with %s ".formatted(rootFolderId));
    }

    public Optional<Folder> findByVersion(UUID ehrId, int folderIdx, int version) {
        return this.findByVersion(this.singleFolderCondition(ehrId, folderIdx, this.tables.versionHead()), this.singleFolderCondition(ehrId, folderIdx, this.tables.versionHistory()), version);
    }

    @Override
    protected Class<Folder> getLocatableClass() {
        return Folder.class;
    }

    private Condition singleFolderCondition(UUID ehrId, int folderIdx, Table<?> table) {
        return table.field((Field)EhrFolderRepository.VERSION_PROTOTYPE.EHR_ID).eq((Object)ehrId).and(table.field((Field)Tables.EHR_FOLDER_VERSION.EHR_FOLDERS_IDX).eq((Object)folderIdx));
    }

    public Optional<ObjectVersionId> findVersionByTime(UUID ehrId, int folderIdx, OffsetDateTime time) {
        return this.findVersionByTime(this.singleFolderCondition(ehrId, folderIdx, this.tables.versionHead()), this.singleFolderCondition(ehrId, folderIdx, this.tables.versionHistory()), time);
    }

    public boolean hasFolder(UUID ehrId, int ehrFolderIdx) {
        SelectConditionStep headQuery = this.context.selectOne().from(this.tables.versionHead()).where(this.singleFolderCondition(ehrId, ehrFolderIdx, this.tables.versionHead()));
        SelectConditionStep historyQuery = this.context.selectOne().from(this.tables.versionHistory()).where(this.singleFolderCondition(ehrId, ehrFolderIdx, this.tables.versionHistory()));
        return this.context.fetchExists((Select)headQuery.unionAll((Select)historyQuery));
    }

    @Transactional
    public void adminDelete(UUID ehrId, Integer ehrFoldersIdx) {
        DeleteConditionStep deleteQuery = this.context.deleteFrom(this.tables.versionHead()).where(this.field(EhrFolderRepository.VERSION_PROTOTYPE.EHR_ID).eq((Object)ehrId));
        if (ehrFoldersIdx != null) {
            deleteQuery = deleteQuery.and(Tables.EHR_FOLDER_VERSION.EHR_FOLDERS_IDX.eq((Object)ehrFoldersIdx));
        }
        deleteQuery.execute();
        DeleteConditionStep deleteHistoryQuery = this.context.deleteFrom(this.tables.versionHistory()).where(this.field(EhrFolderRepository.VERSION_HISTORY_PROTOTYPE.EHR_ID).eq((Object)ehrId));
        if (ehrFoldersIdx != null) {
            deleteHistoryQuery = deleteHistoryQuery.and(Tables.EHR_FOLDER_VERSION_HISTORY.EHR_FOLDERS_IDX.eq((Object)ehrFoldersIdx));
        }
        deleteHistoryQuery.execute();
    }

    public List<ObjectVersionId> findForContribution(UUID ehrId, UUID contributionId) {
        return this.findVersionIdsByContribution(ehrId, contributionId);
    }
}

