/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.knowledge.TemplateMetaData;
import org.ehrbase.repository.CompositionRepository;
import org.ehrbase.repository.TemplateStoreRepository;
import org.ehrbase.service.TemplateStorage;
import org.ehrbase.util.TemplateUtils;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TemplateDBStorageService
implements TemplateStorage {
    private final CompositionRepository compositionRepository;
    private final TemplateStoreRepository templateStoreRepository;

    public TemplateDBStorageService(@Lazy CompositionRepository compositionRepository, TemplateStoreRepository templateStoreRepository) {
        this.compositionRepository = compositionRepository;
        this.templateStoreRepository = templateStoreRepository;
    }

    @Override
    public List<TemplateMetaData> listAllOperationalTemplates() {
        return this.templateStoreRepository.findAll();
    }

    @Override
    public Map<UUID, String> findAllTemplateIds() {
        return this.templateStoreRepository.findAllTemplateIds();
    }

    @Override
    public TemplateMetaData storeTemplate(OPERATIONALTEMPLATE template) {
        if (this.findUuidByTemplateId(TemplateUtils.getTemplateId(template)).isEmpty()) {
            return this.templateStoreRepository.store(template);
        }
        this.checkUsage(template.getTemplateId().getValue(), "update");
        return this.templateStoreRepository.update(template);
    }

    @Override
    public Optional<TemplateMetaData> readTemplate(String templateId) {
        return this.templateStoreRepository.findByTemplateId(templateId);
    }

    private void checkUsage(String templateId, String operation) {
        if (this.compositionRepository.isTemplateUsed(templateId)) {
            throw new UnprocessableEntityException("Cannot %s template %s since it is used by at least one composition".formatted(operation, templateId));
        }
    }

    private void checkUsages() {
        List<String> usedTemplateIds = this.templateStoreRepository.getTemplateUsages();
        if (!usedTemplateIds.isEmpty()) {
            boolean single = usedTemplateIds.size() == 1;
            throw new UnprocessableEntityException("Cannot delete %s %s since %s used by at least one composition".formatted(single ? "template" : "templates", String.join((CharSequence)", ", usedTemplateIds), single ? "it is" : "they are"));
        }
    }

    @Override
    public void deleteTemplate(String templateId) {
        this.checkUsage(templateId, "delete");
        this.templateStoreRepository.delete(templateId);
    }

    @Override
    public List<Pair<UUID, String>> deleteAllTemplates() {
        this.checkUsages();
        return this.templateStoreRepository.findAll().stream().map(t -> {
            String templateId = TemplateUtils.getTemplateId(t.getOperationaltemplate());
            this.templateStoreRepository.delete(templateId);
            return Pair.of((Object)t.getInternalId(), (Object)templateId);
        }).toList();
    }

    @Override
    public Optional<String> findTemplateIdByUuid(UUID uuid) {
        return this.templateStoreRepository.findTemplateIdByUuid(uuid);
    }

    @Override
    public Optional<UUID> findUuidByTemplateId(String templateId) {
        return this.templateStoreRepository.findUuidByTemplateId(templateId);
    }
}

