/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.cache.CacheProvider;
import org.ehrbase.repository.PartyProxyRepository;
import org.ehrbase.service.IAuthenticationFacade;
import org.ehrbase.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImp
implements UserService {
    private final IAuthenticationFacade authenticationFacade;
    private final CacheProvider cacheProvider;
    private final PartyProxyRepository partyProxyRepository;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public UserServiceImp(IAuthenticationFacade authenticationFacade, CacheProvider cacheProvider, PartyProxyRepository partyProxyRepository) {
        this.authenticationFacade = authenticationFacade;
        this.cacheProvider = cacheProvider;
        this.partyProxyRepository = partyProxyRepository;
    }

    @Override
    public UUID getCurrentUserId() {
        String key = this.authenticationFacade.getAuthentication().getName();
        return CacheProvider.USER_ID_CACHE.get(this.cacheProvider, key, () -> this.getOrCreateCurrentUserIdSync(key));
    }

    private UUID getOrCreateCurrentUserIdSync(String key) {
        return this.partyProxyRepository.findInternalUserId(key).or(() -> {
            try {
                return Optional.of(this.partyProxyRepository.createInternalUser(key));
            }
            catch (DataIntegrityViolationException ex) {
                this.logger.info(ex.getMessage(), (Object)ex.getMessage());
                return this.partyProxyRepository.findInternalUserId(key);
            }
        }).orElseThrow(() -> new InternalServerException("Cannot create User"));
    }
}

