/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.changecontrol.VersionedObject;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.generic.Attestation;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.generic.RevisionHistoryItem;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.PartyRef;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.lang.runtime.SwitchBootstraps;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ehrbase.api.dto.EhrStatusDto;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.repository.AbstractVersionedObjectRepository;
import org.ehrbase.repository.CompositionRepository;
import org.ehrbase.repository.EhrFolderRepository;
import org.ehrbase.repository.EhrRepository;
import org.ehrbase.repository.experimental.ItemTagRepository;
import org.ehrbase.service.maping.EhrStatusMapper;
import org.ehrbase.util.OriginalVersionUtil;
import org.ehrbase.util.UuidGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ehrService")
@Transactional
public class EhrServiceImp
implements EhrService {
    private final ValidationService validationService;
    private final EhrFolderRepository ehrFolderRepository;
    private final CompositionRepository compositionRepository;
    private final ItemTagRepository itemTagRepository;
    private final EhrRepository ehrRepository;
    private final SystemService systemService;

    @Autowired
    public EhrServiceImp(ValidationService validationService, SystemService systemService, EhrFolderRepository ehrFolderRepository, CompositionRepository compositionRepository, EhrRepository ehrRepository, ItemTagRepository itemTagRepository) {
        this.validationService = validationService;
        this.ehrFolderRepository = ehrFolderRepository;
        this.compositionRepository = compositionRepository;
        this.ehrRepository = ehrRepository;
        this.itemTagRepository = itemTagRepository;
        this.systemService = systemService;
    }

    public EhrService.EhrResult create(@Nullable UUID ehrId, @Nullable EhrStatusDto status) {
        if (this.hasEhr(ehrId = Optional.ofNullable(ehrId).orElseGet(UuidGenerator::randomUUID))) {
            throw new StateConflictException("EHR with this ID already exists");
        }
        if (status == null) {
            status = new EhrStatusDto(null, "openEHR-EHR-EHR_STATUS.generic.v1", new DvText("EHR Status"), null, null, new PartySelf(null), Boolean.valueOf(true), Boolean.valueOf(true), null);
        } else {
            this.check(status);
            this.checkEhrExistForParty(ehrId, status);
        }
        ObjectVersionId statusVersionId = AbstractVersionedObjectRepository.buildObjectVersionId(UuidGenerator.randomUUID(), 1, this.systemService);
        status = this.ehrStatusDtoWithId(status, statusVersionId);
        this.ehrRepository.commit(ehrId, EhrStatusMapper.fromDto(status), null, null);
        return new EhrService.EhrResult(ehrId, statusVersionId, status);
    }

    public EhrService.EhrResult updateStatus(UUID ehrId, EhrStatusDto status, ObjectVersionId ifMatch, UUID contributionId, UUID audit) {
        this.check(status);
        this.checkEhrExistForParty(ehrId, status);
        UUID ehrStatusId = UUID.fromString(ifMatch.getObjectId().getValue());
        int version = Integer.parseInt(ifMatch.getVersionTreeId().getValue());
        ObjectVersionId statusVersionId = AbstractVersionedObjectRepository.buildObjectVersionId(ehrStatusId, version + 1, this.systemService);
        EhrStatusDto updatedEhrStatus = this.ehrStatusDtoWithId(status, statusVersionId);
        this.ehrRepository.update(ehrId, EhrStatusMapper.fromDto(updatedEhrStatus), contributionId, audit);
        return new EhrService.EhrResult(ehrId, statusVersionId, updatedEhrStatus);
    }

    public EhrService.EhrResult getEhrStatus(UUID ehrId) {
        this.checkEhrExists(ehrId);
        Optional<EhrStatus> head = this.ehrRepository.findHead(ehrId);
        if (head.isEmpty()) {
            EhrServiceImp.raiseEhrNotFoundException(ehrId);
        }
        return head.map(EhrStatusMapper::toDto).map(dto -> new EhrService.EhrResult(ehrId, (ObjectVersionId)dto.uid(), dto)).orElseThrow();
    }

    public Optional<OriginalVersion<EhrStatusDto>> getEhrStatusAtVersion(UUID ehrId, UUID versionedObjectUid, int version) {
        this.ensureEhrExist(ehrId);
        return this.ehrRepository.getOriginalVersionStatus(ehrId, versionedObjectUid, version).map(ov -> OriginalVersionUtil.originalVersionCopyWithData(ov, EhrStatusMapper.toDto((EhrStatus)ov.getData())));
    }

    private void checkEhrExistForParty(UUID ehrId, EhrStatusDto status) {
        String namespace;
        String subjectId;
        Optional<UUID> ehrIdOpt;
        Optional<PartyRef> partyRef = Optional.ofNullable(status).map(EhrStatusDto::subject).map(PartyProxy::getExternalRef);
        if (partyRef.isPresent() && (ehrIdOpt = this.findBySubject(subjectId = partyRef.get().getId().getValue(), namespace = partyRef.get().getNamespace())).isPresent() && !ehrIdOpt.get().equals(ehrId)) {
            throw new StateConflictException(String.format("Supplied partyId[%s] is used by a different EHR in the same partyNamespace[%s].", subjectId, namespace));
        }
    }

    private void check(@Nonnull EhrStatusDto status) {
        try {
            this.validationService.check(status);
        }
        catch (Exception ex) {
            Exception exception = ex;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UnprocessableEntityException.class, ValidationException.class}, (Object)exception2, n)) {
                case 0: {
                    UnprocessableEntityException e = (UnprocessableEntityException)exception2;
                    throw e;
                }
                case 1: {
                    ValidationException e = (ValidationException)exception2;
                    throw e;
                }
            }
            throw new InternalServerException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Optional<UUID> findBySubject(String subjectId, String nameSpace) {
        return this.ehrRepository.findBySubject(subjectId, nameSpace);
    }

    public ObjectVersionId getEhrStatusVersionByTimestamp(UUID ehrId, OffsetDateTime timestamp) {
        this.ensureEhrExist(ehrId);
        return this.ehrRepository.findVersionByTime(ehrId, timestamp).orElseThrow(() -> new ObjectNotFoundException("ehr_status", "No EHR_STATUS with given timestamp: " + String.valueOf(timestamp)));
    }

    public ObjectVersionId getLatestVersionUidOfStatus(UUID ehrId) {
        this.ensureEhrExist(ehrId);
        return this.ehrRepository.findLatestVersion(ehrId).orElseThrow();
    }

    public DvDateTime getCreationTime(UUID ehrId) {
        this.ensureEhrExist(ehrId);
        return new DvDateTime((TemporalAccessor)this.ehrRepository.findEhrCreationTime(ehrId));
    }

    public boolean hasEhr(UUID ehrId) {
        return this.ehrRepository.hasEhr(ehrId);
    }

    public VersionedObject<EhrStatusDto> getVersionedEhrStatus(UUID ehrId) {
        this.ensureEhrExist(ehrId);
        return this.ehrRepository.getVersionedEhrStatus(ehrId).map(versionedEhrStatus -> new VersionedObject(versionedEhrStatus.getUid(), versionedEhrStatus.getOwnerId(), versionedEhrStatus.getTimeCreated())).orElseThrow();
    }

    public RevisionHistory getRevisionHistoryOfVersionedEhrStatus(UUID ehrUid) {
        int versions = Integer.parseInt(this.getLatestVersionUidOfStatus(ehrUid).getVersionTreeId().getValue());
        UUID versionedObjectUid = UUID.fromString(this.getLatestVersionUidOfStatus(ehrUid).getObjectId().getValue());
        RevisionHistory revisionHistory = new RevisionHistory();
        for (int i = 1; i <= versions; ++i) {
            Optional<OriginalVersion<EhrStatusDto>> ehrStatus = this.getEhrStatusAtVersion(ehrUid, versionedObjectUid, i);
            if (!ehrStatus.isPresent()) continue;
            revisionHistory.addItem(this.revisionHistoryItemFromEhrStatus(ehrStatus.get(), i));
        }
        if (revisionHistory.getItems().isEmpty()) {
            throw new InternalServerException("Problem creating RevisionHistory");
        }
        return revisionHistory;
    }

    private RevisionHistoryItem revisionHistoryItemFromEhrStatus(OriginalVersion<EhrStatusDto> ehrStatus, int version) {
        String statusId = ehrStatus.getUid().getValue().split("::")[0];
        ObjectVersionId objectVersionId = new ObjectVersionId(statusId + "::" + this.systemService.getSystemId() + "::" + version);
        ArrayList<AuditDetails> auditDetailsList = new ArrayList<AuditDetails>();
        auditDetailsList.add(ehrStatus.getCommitAudit());
        if (ehrStatus.getAttestations() != null) {
            for (Attestation a : ehrStatus.getAttestations()) {
                AuditDetails newAudit = new AuditDetails(a.getSystemId(), a.getCommitter(), a.getTimeCommitted(), a.getChangeType(), a.getDescription());
                auditDetailsList.add(newAudit);
            }
        }
        return new RevisionHistoryItem(objectVersionId, auditDetailsList);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDeleteEhr(UUID ehrId) {
        this.ehrFolderRepository.adminDelete(ehrId, null);
        this.compositionRepository.adminDeleteAll(ehrId);
        this.itemTagRepository.adminDeleteAll(ehrId);
        this.ehrRepository.adminDelete(ehrId);
    }

    public String getSubjectExtRef(String ehrId) {
        EhrStatusDto ehrStatus = this.getEhrStatus(UUID.fromString(ehrId)).status();
        return Optional.of(ehrStatus.subject()).map(PartyProxy::getExternalRef).map(ObjectRef::getId).map(ObjectId::getValue).orElse(null);
    }

    public void checkEhrExists(UUID ehrId) {
        if (ehrId == null || !this.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("EHR", String.format("EHR with id %s not found", ehrId));
        }
    }

    public void checkEhrExistsAndIsModifiable(UUID ehrId) {
        boolean modifiable = Optional.ofNullable(this.ehrRepository.fetchIsModifiable(ehrId)).orElseThrow(() -> new ObjectNotFoundException("EHR", String.format("EHR with id %s not found", ehrId)));
        if (!modifiable) {
            throw new StateConflictException(String.format("EHR with id %s does not allow modification", ehrId));
        }
    }

    private void ensureEhrExist(UUID ehrId) {
        if (!this.hasEhr(ehrId)) {
            EhrServiceImp.raiseEhrNotFoundException(ehrId);
        }
    }

    private EhrStatusDto ehrStatusDtoWithId(EhrStatusDto ehrStatusDto, ObjectVersionId versionId) {
        return new EhrStatusDto((UIDBasedId)versionId, ehrStatusDto.archetypeNodeId(), ehrStatusDto.name(), ehrStatusDto.archetypeDetails(), ehrStatusDto.feederAudit(), ehrStatusDto.subject(), ehrStatusDto.isQueryable(), ehrStatusDto.isModifiable(), ehrStatusDto.otherDetails());
    }

    private static void raiseEhrNotFoundException(UUID ehrId) {
        throw new ObjectNotFoundException("ehr", String.format("No EHR found with given ID: %s", ehrId));
    }
}

