/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.UsersRecord;
import org.ehrbase.util.UuidGenerator;
import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class PartyProxyRepository {
    public static final String SECURITY_USER_TYPE = "EHRbase Security Authentication User";
    public static final String EHRBASE = "EHRbase";
    private final DSLContext context;

    public PartyProxyRepository(DSLContext context) {
        this.context = context;
    }

    public Optional<UUID> findInternalUserId(String username) {
        return this.context.select((SelectField)Tables.USERS.ID).from((TableLike)Tables.USERS).where(Tables.USERS.USERNAME.eq((Object)username)).fetchOptional().map(Record1::value1);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public UUID createInternalUser(String username) {
        UUID uuid = UuidGenerator.randomUUID();
        UsersRecord usersRecord = (UsersRecord)this.context.newRecord((Table)Tables.USERS);
        usersRecord.setId(uuid);
        usersRecord.setUsername(username);
        usersRecord.store();
        return uuid;
    }

    public PartyProxy fromUser(UUID userId) {
        String username = this.context.select((SelectField)Tables.USERS.USERNAME).from((TableLike)Tables.USERS).where(Tables.USERS.ID.eq((Object)userId)).fetchOptional().map(Record1::value1).orElseThrow();
        DvIdentifier identifier = new DvIdentifier();
        identifier.setId(username);
        identifier.setIssuer(EHRBASE);
        identifier.setAssigner(EHRBASE);
        identifier.setType(SECURITY_USER_TYPE);
        PartyRef externalRef = new PartyRef((ObjectId)new GenericId(userId.toString(), "DEMOGRAPHIC"), "User", "PARTY");
        PartyIdentified partyIdentified = new PartyIdentified(externalRef, "EHRbase Internal " + username, List.of(identifier));
        return partyIdentified;
    }
}

