/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.SQLDialect;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jooq.JooqProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@org.springframework.context.annotation.Configuration
@EnableTransactionManagement
@EnableConfigurationProperties(value={JooqProperties.class})
public class PersistenceConfig {
    @Qualifier(value="dataSource")
    @Autowired
    private DataSource dataSource;

    public TransactionAwareDataSourceProxy transactionAwareDataSource() {
        return new TransactionAwareDataSourceProxy(this.dataSource);
    }

    @Bean
    public DataSourceTransactionManager transactionManager() {
        return new DataSourceTransactionManager(this.dataSource);
    }

    @Bean
    public DataSourceConnectionProvider connectionProvider() {
        return new DataSourceConnectionProvider((DataSource)this.transactionAwareDataSource());
    }

    @Bean
    public ExceptionTranslator exceptionTransformer() {
        return new ExceptionTranslator();
    }

    @Bean
    @Primary
    public DefaultDSLContext dsl(DefaultConfiguration cfg) {
        return new DefaultDSLContext((Configuration)cfg);
    }

    @Bean
    public DefaultConfiguration configuration(JooqProperties properties, DataSourceConnectionProvider provider) {
        DefaultConfiguration jooqConfiguration = new DefaultConfiguration();
        jooqConfiguration.set((ConnectionProvider)provider);
        jooqConfiguration.set(new ExecuteListenerProvider[]{new DefaultExecuteListenerProvider((ExecuteListener)this.exceptionTransformer())});
        jooqConfiguration.set(properties.determineSqlDialect(provider.dataSource()));
        return jooqConfiguration;
    }

    static class ExceptionTranslator
    implements ExecuteListener {
        ExceptionTranslator() {
        }

        public void exception(ExecuteContext context) {
            SQLDialect dialect = context.configuration().dialect();
            SQLException throwable = context.sqlException();
            if (throwable != null) {
                SQLErrorCodeSQLExceptionTranslator translator = new SQLErrorCodeSQLExceptionTranslator(dialect.name());
                context.exception((RuntimeException)translator.translate("Access database using Jooq", context.sql(), throwable));
            }
        }
    }
}

