/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.changecontrol.Version;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.dto.EhrStatusDto;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.tables.records.ContributionRecord;
import org.ehrbase.openehr.sdk.response.dto.ContributionCreateDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.ContributionDto;
import org.ehrbase.repository.AuditDetailsTargetType;
import org.ehrbase.repository.CompositionRepository;
import org.ehrbase.repository.ContributionRepository;
import org.ehrbase.repository.EhrFolderRepository;
import org.ehrbase.repository.EhrRepository;
import org.ehrbase.service.InternalDirectoryService;
import org.ehrbase.service.contribution.ContributionServiceHelper;
import org.ehrbase.service.contribution.ContributionWrapper;
import org.ehrbase.util.UuidGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ContributionServiceImp
implements ContributionService {
    private final CompositionService compositionService;
    private final EhrService ehrService;
    private final InternalDirectoryService folderService;
    private final ValidationService validationService;
    private final ContributionRepository contributionRepository;
    private final CompositionRepository compositionRepository;
    private final EhrFolderRepository ehrFolderRepository;
    private final EhrRepository ehrRepository;
    private static final String ERR_VER_INVALID = "Invalid version object in contribution: %s not supported.";
    private static final String ERR_UNSUP_CHANGE_TYPE = "ChangeType[%s] not Supported.";
    private static final String ERR_MISSING_PRECEDING_UID = "Invalid version. Change type %s, but also set \"preceding_version_uid\" attribute";

    @Autowired
    public ContributionServiceImp(CompositionService compositionService, EhrService ehrService, InternalDirectoryService folderService, ValidationService validationService, ContributionRepository contributionRepository, CompositionRepository compositionRepository, EhrFolderRepository ehrFolderRepository, EhrRepository ehrRepository) {
        this.compositionService = compositionService;
        this.ehrService = ehrService;
        this.folderService = folderService;
        this.validationService = validationService;
        this.contributionRepository = contributionRepository;
        this.compositionRepository = compositionRepository;
        this.ehrFolderRepository = ehrFolderRepository;
        this.ehrRepository = ehrRepository;
    }

    @Nonnull
    public ContributionDto getContribution(UUID ehrId, UUID contributionId) {
        AuditDetails auditDetails = this.retrieveAuditDetails(ehrId, contributionId);
        Map<String, String> objectReferences = this.retrieveUuidsOfContributionObjects(ehrId, contributionId);
        return new ContributionDto(contributionId, objectReferences, auditDetails);
    }

    public UUID commitContribution(UUID ehrId, String content) {
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("EHR", "No EHR found with given ID: " + ehrId.toString());
        }
        ContributionWrapper contributionWrapper = ContributionServiceHelper.unmarshalContribution(content);
        ContributionCreateDto contribution = contributionWrapper.getContributionCreateDto();
        this.validationService.check(contribution);
        UUID auditUuid = this.contributionRepository.createAudit(contribution.getAudit(), AuditDetailsTargetType.CONTRIBUTION);
        UUID contributionUuid = Optional.of(contribution).map(ContributionCreateDto::getUid).map(ObjectId::getValue).map(UUID::fromString).orElseGet(UuidGenerator::randomUUID);
        UUID contributionId = this.contributionRepository.createContribution(ehrId, contributionUuid, ContributionDataType.other, auditUuid);
        contributionWrapper.forEachVersion((version, dto) -> {
            RMObject versionRmObject;
            RMObject selector0$temp = versionRmObject = (RMObject)version.getData();
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Composition.class, Folder.class, EhrStatus.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    Composition composition = (Composition)selector0$temp;
                    try {
                        this.processCompositionVersion(ehrId, contributionId, (Version<?>)version, composition);
                        break;
                    }
                    catch (UnprocessableEntityException e) {
                        throw new ValidationException(e.getMessage());
                    }
                }
                case 1: {
                    Folder folder = (Folder)selector0$temp;
                    this.processFolderVersion(ehrId, contributionId, (Version<?>)version, folder);
                    break;
                }
                case 2: {
                    EhrStatus __ = (EhrStatus)selector0$temp;
                    EhrStatusDto ehrStatusDto = Optional.ofNullable(dto).filter(EhrStatusDto.class::isInstance).map(EhrStatusDto.class::cast).orElseThrow(() -> new InternalServerException("Expected DTO to exist for Contribution of EHR_STATUS"));
                    this.processEhrStatusVersion(ehrId, contributionId, (Version<?>)version, ehrStatusDto);
                    break;
                }
                case -1: {
                    this.processMetadataVersion(ehrId, contributionId, (Version<?>)version);
                    break;
                }
                default: {
                    Object[] objectArray = new Object[1];
                    objectArray[0] = Optional.of(versionRmObject.getClass()).map(arg_0 -> ((ArchieRMInfoLookup)ArchieRMInfoLookup.getInstance()).getTypeInfo(arg_0)).map(RMTypeInfo::getRmName).orElseGet(() -> versionRmObject.getClass().getSimpleName().toUpperCase());
                    throw new ValidationException(ERR_VER_INVALID.formatted(objectArray));
                }
            }
        });
        return contributionId;
    }

    private void processEhrStatusVersion(UUID ehrId, UUID contributionId, Version<?> version, EhrStatusDto ehrStatus) {
        ContributionService.ContributionChangeType changeType = ContributionService.ContributionChangeType.fromAuditDetails((AuditDetails)version.getCommitAudit());
        this.checkContributionRules(version, changeType);
        UUID audit = this.contributionRepository.createAudit(version.getCommitAudit(), AuditDetailsTargetType.EHR_STATUS);
        switch (changeType) {
            case CREATION: {
                throw new ValidationException("Invalid change type. EHR_STATUS cannot be manually created.");
            }
            case AMENDMENT: 
            case MODIFICATION: {
                this.ehrService.updateStatus(ehrId, ehrStatus, version.getPrecedingVersionUid(), contributionId, audit);
                break;
            }
            case DELETED: {
                throw new ValidationException("Invalid change type. EHR_STATUS cannot be deleted.");
            }
            case SYNTHESIS: 
            case UNKNOWN: {
                throw new ValidationException(ERR_UNSUP_CHANGE_TYPE.formatted(changeType));
            }
        }
    }

    private void processCompositionVersion(UUID ehrId, UUID contributionId, Version<?> version, Composition composition) {
        ContributionService.ContributionChangeType changeType = ContributionService.ContributionChangeType.fromAuditDetails((AuditDetails)version.getCommitAudit());
        this.checkContributionRules(version, changeType);
        UUID audit = this.contributionRepository.createAudit(version.getCommitAudit(), AuditDetailsTargetType.COMPOSITION);
        switch (changeType) {
            case CREATION: {
                this.compositionService.create(ehrId, (Locatable)composition, contributionId, audit);
                break;
            }
            case AMENDMENT: 
            case MODIFICATION: {
                this.compositionService.update(ehrId, version.getPrecedingVersionUid(), (Locatable)composition, contributionId, audit);
                break;
            }
            case DELETED: {
                this.compositionService.delete(ehrId, version.getPrecedingVersionUid(), contributionId, audit);
                break;
            }
            case SYNTHESIS: 
            case UNKNOWN: {
                throw new ValidationException(ERR_UNSUP_CHANGE_TYPE.formatted(changeType));
            }
        }
    }

    private void processFolderVersion(UUID ehrId, UUID contributionId, Version<?> version, Folder folder) {
        ContributionService.ContributionChangeType changeType = ContributionService.ContributionChangeType.fromAuditDetails((AuditDetails)version.getCommitAudit());
        this.checkContributionRules(version, changeType);
        UUID audit = this.contributionRepository.createAudit(version.getCommitAudit(), AuditDetailsTargetType.EHR_FOLDER);
        switch (changeType) {
            case CREATION: {
                this.folderService.create(ehrId, folder, contributionId, audit);
                break;
            }
            case AMENDMENT: 
            case MODIFICATION: {
                this.folderService.update(ehrId, folder, version.getPrecedingVersionUid(), contributionId, audit);
                break;
            }
            case DELETED: {
                this.folderService.delete(ehrId, version.getPrecedingVersionUid(), contributionId, audit);
                break;
            }
            case SYNTHESIS: 
            case UNKNOWN: {
                throw new ValidationException(ERR_UNSUP_CHANGE_TYPE.formatted(changeType));
            }
        }
    }

    private void checkContributionRules(Version<?> version, ContributionService.ContributionChangeType changeType) {
        switch (changeType) {
            case CREATION: {
                if (version.getPrecedingVersionUid() == null) break;
                throw new ValidationException(ERR_MISSING_PRECEDING_UID.formatted(changeType));
            }
            case AMENDMENT: 
            case MODIFICATION: {
                if (version.getPrecedingVersionUid() != null) break;
                throw new ValidationException(ERR_MISSING_PRECEDING_UID.formatted(changeType));
            }
            case DELETED: 
            case SYNTHESIS: 
            case UNKNOWN: {
                break;
            }
            default: {
                throw new ValidationException(ERR_UNSUP_CHANGE_TYPE.formatted(changeType));
            }
        }
    }

    private void processMetadataVersion(UUID ehrId, UUID contributionId, Version<?> version) {
        ContributionService.ContributionChangeType changeType = ContributionService.ContributionChangeType.fromAuditDetails((AuditDetails)version.getCommitAudit());
        if (changeType != ContributionService.ContributionChangeType.DELETED) {
            throw new ValidationException(ERR_UNSUP_CHANGE_TYPE.formatted(changeType));
        }
        UUID objectUid = ContributionServiceImp.getVersionedUidFromVersion(version);
        if (this.compositionService.exists(objectUid)) {
            UUID audit = this.contributionRepository.createAudit(version.getCommitAudit(), AuditDetailsTargetType.COMPOSITION);
            this.compositionService.delete(ehrId, version.getPrecedingVersionUid(), contributionId, audit);
        } else if (this.isFolderPresent(ehrId, version.getPrecedingVersionUid())) {
            UUID audit = this.contributionRepository.createAudit(version.getCommitAudit(), AuditDetailsTargetType.EHR_FOLDER);
            this.compositionService.delete(ehrId, version.getPrecedingVersionUid(), contributionId, audit);
        } else {
            throw new ObjectNotFoundException("COMPOSITION|FOLDER", "Could not find Object[id: %s]".formatted(objectUid));
        }
    }

    private boolean isFolderPresent(UUID ehrId, ObjectVersionId folderUid) {
        return this.folderService.get(ehrId, folderUid, null).isPresent();
    }

    private static UUID getVersionedUidFromVersion(Version<?> version) {
        ObjectVersionId precedingVersionUid = version.getPrecedingVersionUid();
        if (precedingVersionUid == null) {
            throw new IllegalArgumentException("Input invalid. Composition can't be modified without pointer to precedingVersionUid in Version container.");
        }
        if (StringUtils.countMatches((CharSequence)precedingVersionUid.getValue(), (CharSequence)"::") != 2) {
            throw new IllegalArgumentException("Input invalid. Given precedingVersionUid is not a versionUid.");
        }
        String versionedUid = precedingVersionUid.getValue().substring(0, precedingVersionUid.getValue().indexOf("::"));
        return UUID.fromString(versionedUid);
    }

    private Map<String, String> retrieveUuidsOfContributionObjects(UUID ehrId, UUID contribution) {
        LinkedHashMap<String, String> objRefs = new LinkedHashMap<String, String>();
        this.compositionRepository.findVersionIdsByContribution(ehrId, contribution).stream().sorted(Comparator.comparing(ObjectId::getValue)).forEach(k -> objRefs.put(k.getValue(), SupportedVersionedObject.COMPOSITION.name()));
        this.ehrRepository.findVersionIdsByContribution(ehrId, contribution).stream().sorted(Comparator.comparing(ObjectId::getValue)).forEach(k -> objRefs.put(k.getValue(), SupportedVersionedObject.EHR_STATUS.name()));
        this.ehrFolderRepository.findForContribution(ehrId, contribution).stream().sorted(Comparator.comparing(ObjectId::getValue)).forEach(f -> objRefs.put(f.toString(), SupportedVersionedObject.FOLDER.name()));
        return objRefs;
    }

    private AuditDetails retrieveAuditDetails(UUID ehrId, UUID contributionId) {
        ContributionRecord contributionRec = this.contributionRepository.findById(contributionId);
        if (contributionRec == null || !contributionRec.getEhrId().equals(ehrId)) {
            if (this.ehrService.hasEhr(ehrId)) {
                throw new ObjectNotFoundException("CONTRIBUTION", "Contribution with given ID does not exist");
            }
            throw new ObjectNotFoundException("EHR", "No EHR found with given ID: %s".formatted(ehrId));
        }
        UUID hasAudit = contributionRec.getHasAudit();
        return this.contributionRepository.findAuditDetails(hasAudit);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDelete(UUID ehrId, UUID contributionId) {
        throw new UnsupportedOperationException();
    }

    public static enum SupportedVersionedObject {
        COMPOSITION,
        EHR_STATUS,
        FOLDER;

    }
}

