/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.cache;

import com.jayway.jsonpath.DocumentContext;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.springframework.cache.Cache;

public interface CacheProvider {
    public static final EhrBaseCache<String, WebTemplate> INTROSPECT_CACHE = new EhrBaseCache("introspectCache");
    public static final EhrBaseCache<String, UUID> TEMPLATE_ID_UUID_CACHE = new EhrBaseCache("TemplateIdUuidCache");
    public static final EhrBaseCache<UUID, String> TEMPLATE_UUID_ID_CACHE = new EhrBaseCache("TemplateUuidIdCache");
    public static final EhrBaseCache<String, UUID> USER_ID_CACHE = new EhrBaseCache("userIdCache");
    public static final EhrBaseCache<String, DocumentContext> EXTERNAL_FHIR_TERMINOLOGY_CACHE = new EhrBaseCache("externalFhirTerminologyCache");
    public static final EhrBaseCache<String, QueryDefinitionResultDto> STORED_QUERY_CACHE = new EhrBaseCache("StoredQueryCache");

    public static Supplier<InternalServerException> getExceptionSupplier(EhrBaseCache<?, ?> cache) {
        return () -> new InternalServerException("Non existing cache : %s".formatted(cache.name()));
    }

    public Cache getCache(EhrBaseCache<?, ?> var1);

    public record EhrBaseCache<K, V>(String name) {
        public V get(CacheProvider cacheProvider, K key, Callable<V> valueLoader) {
            return (V)cacheProvider.getCache(this).get(key, valueLoader);
        }

        public void evict(CacheProvider cacheProvider, K key) {
            cacheProvider.getCache(this).evict(key);
        }

        public void put(CacheProvider cacheProvider, K key, V value) {
            cacheProvider.getCache(this).put(key, value);
        }

        public void clear(CacheProvider cacheProvider) {
            cacheProvider.getCache(this).clear();
        }
    }
}

