/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.cache.CacheProvider;
import org.ehrbase.repository.PartyProxyRepository;
import org.ehrbase.service.IAuthenticationFacade;
import org.ehrbase.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class UserServiceImp
implements UserService {
    private final IAuthenticationFacade authenticationFacade;
    private final CacheProvider cacheProvider;
    private final PartyProxyRepository partyProxyRepository;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public UserServiceImp(IAuthenticationFacade authenticationFacade, CacheProvider cacheProvider, PartyProxyRepository partyProxyRepository) {
        this.authenticationFacade = authenticationFacade;
        this.cacheProvider = cacheProvider;
        this.partyProxyRepository = partyProxyRepository;
    }

    @Override
    public UUID getCurrentUserId() {
        String key = this.authenticationFacade.getAuthentication().getName();
        try {
            return CacheProvider.USER_ID_CACHE.get(this.cacheProvider, key, () -> this.getOrCreateCurrentUserIdSync(key));
        }
        catch (Cache.ValueRetrievalException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DuplicateKeyException) {
                DuplicateKeyException c = (DuplicateKeyException)cause;
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "User already created concurrently by different request", (Throwable)c);
            }
            if (cause instanceof RuntimeException) {
                RuntimeException c = (RuntimeException)cause;
                throw c;
            }
            throw e;
        }
    }

    private UUID getOrCreateCurrentUserIdSync(String key) {
        return this.partyProxyRepository.findInternalUserId(key).or(() -> Optional.of(this.partyProxyRepository.createInternalUser(key))).orElseThrow(() -> new InternalServerException("Cannot create User"));
    }
}

