/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.xmlbeans.XmlException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.api.knowledge.TemplateMetaData;
import org.ehrbase.cache.CacheProvider;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.parser.OPTParser;
import org.ehrbase.service.TemplateStorage;
import org.ehrbase.util.TemplateUtils;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeCacheServiceImp
implements KnowledgeCacheService {
    public static final String ELEMENT = "ELEMENT";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TemplateStorage templateStorage;
    private final CacheProvider cacheProvider;
    @Value(value="${ehrbase.cache.template-init-on-startup:false}")
    private boolean initTemplateCache;

    public KnowledgeCacheServiceImp(TemplateStorage templateStorage, CacheProvider cacheProvider) {
        this.templateStorage = templateStorage;
        this.cacheProvider = cacheProvider;
    }

    @PostConstruct
    public void init() {
        if (this.initTemplateCache) {
            this.listAllOperationalTemplates();
        }
    }

    private static OPERATIONALTEMPLATE buildOperationalTemplate(InputStream content) {
        try {
            TemplateDocument document = TemplateDocument.Factory.parse((InputStream)content);
            return document.getTemplate();
        }
        catch (IOException | XmlException e) {
            throw new InvalidApiParameterException(e.getMessage());
        }
    }

    public String addOperationalTemplate(OPERATIONALTEMPLATE template) {
        return this.addOperationalTemplateIntern(template, false);
    }

    private String addOperationalTemplateIntern(OPERATIONALTEMPLATE template, boolean overwrite) {
        boolean canOverwrite;
        String templateId;
        this.validateTemplate(template);
        try {
            templateId = TemplateUtils.getTemplateId(template);
        }
        catch (IllegalArgumentException a) {
            throw new InvalidApiParameterException("Invalid template input content");
        }
        boolean bl = canOverwrite = this.templateStorage.allowTemplateOverwrite() || overwrite;
        if (!canOverwrite && this.retrieveOperationalTemplate(templateId).isPresent()) {
            throw new StateConflictException("Operational template with this template ID already exists: " + templateId);
        }
        TemplateMetaData templateMetaData = this.templateStorage.storeTemplate(template);
        if (canOverwrite) {
            this.invalidateCaches(templateId, templateMetaData.getInternalId());
        }
        this.log.info("Updating WebTemplate cache for template: {}", (Object)templateId);
        this.ensureCached(templateMetaData);
        return templateId;
    }

    public String adminUpdateOperationalTemplate(InputStream content) {
        OPERATIONALTEMPLATE template = KnowledgeCacheServiceImp.buildOperationalTemplate(content);
        return this.addOperationalTemplateIntern(template, true);
    }

    private void ensureCached(TemplateMetaData template) {
        CacheProvider.TEMPLATE_UUID_ID_CACHE.get(this.cacheProvider, template.getInternalId(), () -> {
            String templateId = TemplateUtils.getTemplateId(template.getOperationaltemplate());
            CacheProvider.TEMPLATE_ID_UUID_CACHE.get(this.cacheProvider, templateId, () -> ((TemplateMetaData)template).getInternalId());
            CacheProvider.INTROSPECT_CACHE.get(this.cacheProvider, templateId, () -> this.buildWebTemplate(template.getOperationaltemplate()));
            return templateId;
        });
    }

    private void invalidateCaches(String templateId, UUID internalId) {
        CacheProvider.INTROSPECT_CACHE.evict(this.cacheProvider, templateId);
        CacheProvider.TEMPLATE_ID_UUID_CACHE.evict(this.cacheProvider, templateId);
        CacheProvider.TEMPLATE_UUID_ID_CACHE.evict(this.cacheProvider, internalId);
    }

    public List<TemplateMetaData> listAllOperationalTemplates() {
        List<TemplateMetaData> templateMetaData = this.templateStorage.listAllOperationalTemplates();
        this.log.info("Updating WebTemplate cache for all {} templates", (Object)templateMetaData.size());
        templateMetaData.forEach(this::ensureCached);
        return templateMetaData;
    }

    public Map<UUID, String> findAllTemplateIds() {
        return this.templateStorage.findAllTemplateIds();
    }

    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(String key) {
        this.log.debug("retrieveOperationalTemplate({})", (Object)key);
        return this.templateStorage.readTemplate(key).map(TemplateMetaData::getOperationaltemplate);
    }

    public void deleteOperationalTemplate(OPERATIONALTEMPLATE template) {
        String templateId = TemplateUtils.getTemplateId(template);
        Optional<UUID> internalId = this.findUuidByTemplateId(templateId);
        this.templateStorage.deleteTemplate(templateId);
        CacheProvider.INTROSPECT_CACHE.evict(this.cacheProvider, templateId);
        CacheProvider.TEMPLATE_ID_UUID_CACHE.evict(this.cacheProvider, templateId);
        internalId.ifPresent(iid -> CacheProvider.TEMPLATE_UUID_ID_CACHE.evict(this.cacheProvider, (UUID)iid));
    }

    public int deleteAllOperationalTemplates() {
        List<Pair<UUID, String>> deletedTemplates = this.templateStorage.deleteAllTemplates();
        deletedTemplates.forEach(t -> {
            CacheProvider.TEMPLATE_UUID_ID_CACHE.evict(this.cacheProvider, (UUID)t.getKey());
            CacheProvider.INTROSPECT_CACHE.evict(this.cacheProvider, (String)t.getValue());
            CacheProvider.TEMPLATE_ID_UUID_CACHE.evict(this.cacheProvider, (String)t.getValue());
        });
        return deletedTemplates.size();
    }

    public Optional<String> findTemplateIdByUuid(UUID uuid) {
        try {
            return Optional.of(CacheProvider.TEMPLATE_UUID_ID_CACHE.get(this.cacheProvider, uuid, () -> {
                String templateId = this.templateStorage.findTemplateIdByUuid(uuid).orElseThrow();
                CacheProvider.TEMPLATE_ID_UUID_CACHE.get(this.cacheProvider, templateId, () -> uuid);
                return templateId;
            }));
        }
        catch (Cache.ValueRetrievalException ex) {
            return KnowledgeCacheServiceImp.handleCacheMismatch(ex);
        }
    }

    public Optional<UUID> findUuidByTemplateId(String templateId) {
        try {
            return Optional.of(CacheProvider.TEMPLATE_ID_UUID_CACHE.get(this.cacheProvider, templateId, () -> {
                UUID internalId = this.templateStorage.findUuidByTemplateId(templateId).orElseThrow();
                CacheProvider.TEMPLATE_UUID_ID_CACHE.get(this.cacheProvider, internalId, () -> templateId);
                return internalId;
            }));
        }
        catch (Cache.ValueRetrievalException ex) {
            return KnowledgeCacheServiceImp.handleCacheMismatch(ex);
        }
    }

    public WebTemplate getInternalTemplate(String templateId) {
        try {
            return CacheProvider.INTROSPECT_CACHE.get(this.cacheProvider, templateId, () -> {
                this.log.info("Updating WebTemplate cache for template: {}", (Object)templateId);
                return this.retrieveInternalTemplate(templateId);
            });
        }
        catch (Cache.ValueRetrievalException ex) {
            throw (RuntimeException)ex.getCause();
        }
    }

    private WebTemplate retrieveInternalTemplate(String templateId) {
        return this.retrieveOperationalTemplate(templateId).map(this::buildWebTemplate).orElseThrow(() -> new IllegalArgumentException("Could not retrieve template for template Id: " + templateId));
    }

    private WebTemplate buildWebTemplate(OPERATIONALTEMPLATE operationaltemplate) {
        try {
            return new OPTParser(operationaltemplate).parse();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Invalid template: %s", e.getMessage()));
        }
    }

    private void validateTemplate(OPERATIONALTEMPLATE template) {
        if (template == null) {
            throw new InvalidApiParameterException("Could not parse input template");
        }
        if (template.getConcept() == null || template.getConcept().isEmpty()) {
            throw new IllegalArgumentException("Supplied template has nil or empty concept");
        }
        if (template.getLanguage() == null || template.getLanguage().isNil()) {
            throw new IllegalArgumentException("Supplied template has nil or empty language");
        }
        if (template.getDefinition() == null || template.getDefinition().isNil()) {
            throw new IllegalArgumentException("Supplied template has nil or empty definition");
        }
        if (template.getDescription() == null || !template.getDescription().validate()) {
            throw new IllegalArgumentException("Supplied template has nil or empty description");
        }
        if (!TemplateUtils.isSupported(template)) {
            throw new IllegalArgumentException(MessageFormat.format("The supplied template is not supported (unsupported types: {0})", String.join((CharSequence)",", TemplateUtils.UNSUPPORTED_RM_TYPES)));
        }
    }

    private static <T> Optional<T> handleCacheMismatch(Cache.ValueRetrievalException ex) {
        Throwable cause;
        Throwable throwable = cause = ex.getCause();
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NoSuchElementException.class, RuntimeException.class}, (Object)throwable2, n)) {
            case 0: {
                NoSuchElementException __ = (NoSuchElementException)throwable2;
                break;
            }
            case 1: {
                RuntimeException re = (RuntimeException)throwable2;
                throw re;
            }
            default: {
                throw ex;
            }
        }
        return Optional.empty();
    }
}

