/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.cache;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.cache.CacheProvider;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component
public class CacheProviderImp
implements CacheProvider {
    private final CacheManager cacheManager;

    public CacheProviderImp(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public <V, K> V get(CacheProvider.EhrBaseCache<K, V> cache, K key, Callable<V> valueLoader) {
        return (V)Optional.ofNullable(this.cacheManager.getCache(cache.name())).orElseThrow(CacheProviderImp.getExceptionSupplier(cache)).get(key, valueLoader);
    }

    private static <V, K> Supplier<InternalServerException> getExceptionSupplier(CacheProvider.EhrBaseCache<K, V> cache) {
        return () -> new InternalServerException("Non existing cache : %s".formatted(cache.name()));
    }

    @Override
    public <V, K> void evict(CacheProvider.EhrBaseCache<K, V> cache, K key) {
        Optional.ofNullable(this.cacheManager.getCache(cache.name())).orElseThrow(CacheProviderImp.getExceptionSupplier(cache)).evict(key);
    }
}

