/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.plugin;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.function.TriFunction;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Pointcut;
import org.ehrbase.api.exception.InternalServerException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public abstract class AbstractPluginAspect<EXTENSIONPOINT> {
    private final Comparator<Map.Entry<String, EXTENSIONPOINT>> EXTENSION_POINTS_COMPARATOR = ((Comparator)(e1, e2) -> AnnotationAwareOrderComparator.INSTANCE.compare(e1.getValue(), e2.getValue())).reversed().thenComparing(Map.Entry::getKey);
    protected final ListableBeanFactory beanFactory;
    private final Class<EXTENSIONPOINT> clazz;

    protected AbstractPluginAspect(ListableBeanFactory beanFactory, Class<EXTENSIONPOINT> clazz) {
        this.beanFactory = beanFactory;
        this.clazz = clazz;
    }

    @Pointcut(value="within(org.ehrbase.service..*)")
    public void inServiceLayerPC() {
    }

    protected Object proceed(ProceedingJoinPoint pjp, Object[] args) {
        try {
            return pjp.proceed(args);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalServerException(e.getMessage(), e);
        }
    }

    protected List<EXTENSIONPOINT> getActiveExtensionPointsOrderedDesc() {
        return this.beanFactory.getBeansOfType(this.clazz).entrySet().stream().sorted(this.EXTENSION_POINTS_COMPARATOR).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    protected <IN, OUT> OUT proceedWithPluginExtensionPoints(ProceedingJoinPoint pjp, TriFunction<EXTENSIONPOINT, IN, Function<IN, OUT>, OUT> extensionPointMethod, Function<Object[], IN> argsToInputObj, BiFunction<IN, Object[], Object[]> setArgs) {
        return (OUT)this.proceedWithPluginExtensionPoints(pjp, extensionPointMethod, argsToInputObj, setArgs, ret -> ret);
    }

    protected <IN, OUT> OUT proceedWithPluginExtensionPoints(ProceedingJoinPoint pjp, TriFunction<EXTENSIONPOINT, IN, Function<IN, OUT>, OUT> extensionPointMethod, Function<Object[], IN> argsToInputObj, BiFunction<IN, Object[], Object[]> setArgs, Function<Object, OUT> afterProceed) {
        List<EXTENSIONPOINT> extensionPoints = this.getActiveExtensionPointsOrderedDesc();
        if (extensionPoints.isEmpty()) {
            return afterProceed.apply(this.proceed(pjp, pjp.getArgs()));
        }
        IN inputArgsObj = argsToInputObj.apply(pjp.getArgs());
        Function<Object, Object> callChain = in -> afterProceed.apply(this.proceed(pjp, (Object[])setArgs.apply(in, pjp.getArgs())));
        for (int i = 0; i < extensionPoints.size() - 1; ++i) {
            Object ep = extensionPoints.get(i);
            Function<Object, Object> lastCall = callChain;
            callChain = in -> extensionPointMethod.apply(ep, in, (Object)lastCall);
        }
        return (OUT)extensionPointMethod.apply(extensionPoints.get(extensionPoints.size() - 1), inputArgsObj, callChain);
    }
}

