/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.xmlbeans.XmlException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.api.knowledge.TemplateMetaData;
import org.ehrbase.cache.CacheProvider;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.parser.OPTParser;
import org.ehrbase.service.IntrospectService;
import org.ehrbase.service.TemplateStorage;
import org.ehrbase.util.TemplateUtils;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeCacheServiceImp
implements KnowledgeCacheService,
IntrospectService {
    public static final String ELEMENT = "ELEMENT";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TemplateStorage templateStorage;
    private final CacheProvider cacheProvider;
    @Value(value="${system.allow-template-overwrite:false}")
    private boolean allowTemplateOverwrite;

    public KnowledgeCacheServiceImp(TemplateStorage templateStorage, CacheProvider cacheProvider) {
        this.templateStorage = templateStorage;
        this.cacheProvider = cacheProvider;
    }

    public String addOperationalTemplate(InputStream inputStream) {
        OPERATIONALTEMPLATE template = this.buildOperationalTemplate(inputStream);
        return this.addOperationalTemplateIntern(template, false);
    }

    private OPERATIONALTEMPLATE buildOperationalTemplate(InputStream content) {
        try {
            TemplateDocument document = TemplateDocument.Factory.parse((InputStream)content);
            return document.getTemplate();
        }
        catch (IOException | XmlException e) {
            throw new InvalidApiParameterException(e.getMessage());
        }
    }

    public String addOperationalTemplate(OPERATIONALTEMPLATE template) {
        return this.addOperationalTemplateIntern(template, false);
    }

    private String addOperationalTemplateIntern(OPERATIONALTEMPLATE template, boolean overwrite) {
        String templateId;
        this.validateTemplate(template);
        try {
            templateId = TemplateUtils.getTemplateId(template);
        }
        catch (IllegalArgumentException a) {
            throw new InvalidApiParameterException("Invalid template input content");
        }
        if (!this.allowTemplateOverwrite && !overwrite && this.retrieveOperationalTemplate(templateId).isPresent()) {
            throw new StateConflictException("Operational template with this template ID already exists: " + templateId);
        }
        this.templateStorage.storeTemplate(template);
        if (this.allowTemplateOverwrite && !overwrite) {
            this.invalidateCache(template);
        }
        return templateId;
    }

    public String adminUpdateOperationalTemplate(InputStream content) {
        OPERATIONALTEMPLATE template = this.buildOperationalTemplate(content);
        return this.addOperationalTemplateIntern(template, true);
    }

    private void invalidateCache(OPERATIONALTEMPLATE template) {
        String templateId = template.getTemplateId().getValue();
        UUID uuid = this.findUuidByTemplateId(templateId).orElseThrow();
        this.cacheProvider.evict(CacheProvider.INTROSPECT_CACHE, templateId);
        this.cacheProvider.evict(CacheProvider.TEMPLATE_ID_UUID_CACHE, templateId);
        this.cacheProvider.evict(CacheProvider.TEMPLATE_UUID_ID_CACHE, uuid);
    }

    public List<TemplateMetaData> listAllOperationalTemplates() {
        return this.templateStorage.listAllOperationalTemplates();
    }

    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(String key) {
        this.log.debug("retrieveOperationalTemplate({})", (Object)key);
        return this.templateStorage.readOperationaltemplate(key);
    }

    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(UUID uuid) {
        return this.findTemplateIdByUuid(uuid).flatMap(this::retrieveOperationalTemplate);
    }

    public boolean deleteOperationalTemplate(OPERATIONALTEMPLATE template) {
        boolean deleted = this.templateStorage.deleteTemplate(template.getTemplateId().getValue());
        if (deleted) {
            this.invalidateCache(template);
        }
        return deleted;
    }

    public Optional<String> findTemplateIdByUuid(UUID uuid) {
        try {
            return Optional.of(this.cacheProvider.get(CacheProvider.TEMPLATE_UUID_ID_CACHE, uuid, () -> this.templateStorage.findTemplateIdByUuid(uuid).orElseThrow()));
        }
        catch (Cache.ValueRetrievalException ex) {
            return Optional.empty();
        }
    }

    public Optional<UUID> findUuidByTemplateId(String templateId) {
        try {
            return Optional.of(this.cacheProvider.get(CacheProvider.TEMPLATE_ID_UUID_CACHE, templateId, () -> this.templateStorage.findUuidByTemplateId(templateId).orElseThrow()));
        }
        catch (Cache.ValueRetrievalException ex) {
            return Optional.empty();
        }
    }

    @Override
    public WebTemplate getQueryOptMetaData(String templateId) {
        try {
            return this.cacheProvider.get(CacheProvider.INTROSPECT_CACHE, templateId, () -> this.buildQueryOptMetaData(templateId));
        }
        catch (Cache.ValueRetrievalException ex) {
            throw (RuntimeException)ex.getCause();
        }
    }

    private WebTemplate buildQueryOptMetaData(String templateId) {
        return this.retrieveOperationalTemplate(templateId).map(this::buildQueryOptMetaData).orElseThrow(() -> new IllegalArgumentException("Could not retrieve  template for  template Id:" + templateId));
    }

    private WebTemplate buildQueryOptMetaData(OPERATIONALTEMPLATE operationaltemplate) {
        this.log.info("Updating WebTemplate cache for template: {}", (Object)TemplateUtils.getTemplateId(operationaltemplate));
        try {
            return new OPTParser(operationaltemplate).parse();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid template: %s", e.getMessage()));
        }
    }

    public int deleteAllOperationalTemplates() {
        List<TemplateMetaData> templateList = this.templateStorage.listAllOperationalTemplates();
        if (templateList.isEmpty()) {
            return 0;
        }
        int deleted = 0;
        for (TemplateMetaData metaData : templateList) {
            if (!this.deleteOperationalTemplate(metaData.getOperationaltemplate())) continue;
            ++deleted;
        }
        return deleted;
    }

    private void validateTemplate(OPERATIONALTEMPLATE template) {
        if (template == null) {
            throw new InvalidApiParameterException("Could not parse input template");
        }
        if (template.getConcept() == null || template.getConcept().isEmpty()) {
            throw new IllegalArgumentException("Supplied template has nil or empty concept");
        }
        if (template.getLanguage() == null || template.getLanguage().isNil()) {
            throw new IllegalArgumentException("Supplied template has nil or empty language");
        }
        if (template.getDefinition() == null || template.getDefinition().isNil()) {
            throw new IllegalArgumentException("Supplied template has nil or empty definition");
        }
        if (template.getDescription() == null || !template.getDescription().validate()) {
            throw new IllegalArgumentException("Supplied template has nil or empty description");
        }
        if (!TemplateUtils.isSupported(template)) {
            throw new IllegalArgumentException(MessageFormat.format("The supplied template is not supported (unsupported types: {0})", String.join((CharSequence)",", TemplateUtils.UNSUPPORTED_RM_TYPES)));
        }
    }
}

