/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.GeneralRequestProcessingException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.StoredQueryService;
import org.ehrbase.cache.CacheProvider;
import org.ehrbase.openehr.sdk.aql.parser.AqlParseException;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.repository.StoredQueryRepository;
import org.ehrbase.util.InvalidVersionFormatException;
import org.ehrbase.util.SemVer;
import org.ehrbase.util.SemVerUtil;
import org.ehrbase.util.StoredQueryQualifiedName;
import org.ehrbase.util.VersionConflictException;
import org.jooq.exception.DataAccessException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;

@Service
public class StoredQueryServiceImp
implements StoredQueryService {
    private final StoredQueryRepository storedQueryRepository;
    private final CacheProvider cacheProvider;
    @Value(value="${ehrbase.cache.stored-query-init-on-startup:false}")
    private boolean initStoredQueryCache = false;

    public StoredQueryServiceImp(StoredQueryRepository storedQueryRepository, CacheProvider cacheProvider) {
        this.storedQueryRepository = storedQueryRepository;
        this.cacheProvider = cacheProvider;
    }

    @PostConstruct
    public void init() {
        if (this.initStoredQueryCache) {
            this.storedQueryRepository.retrieveAllLatest().forEach(l -> SemVerUtil.streamAllResolutions(SemVer.parse(l.getVersion())).forEach(v -> {
                StoredQueryQualifiedName storedQueryQualifiedName = StoredQueryQualifiedName.create(l.getQualifiedName(), v);
                CacheProvider.STORED_QUERY_CACHE.get(this.cacheProvider, storedQueryQualifiedName.toQualifiedNameString(), () -> l);
            }));
        }
    }

    public List<QueryDefinitionResultDto> retrieveStoredQueries(String fullyQualifiedName) {
        String name = (String)StringUtils.defaultIfEmpty((CharSequence)fullyQualifiedName, null);
        try {
            return this.storedQueryRepository.retrieveQualifiedList(name);
        }
        catch (DataAccessException e) {
            throw new GeneralRequestProcessingException("Data Access Error: " + e.getCause().getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not retrieve stored query, reason: " + String.valueOf(e), e);
        }
    }

    public QueryDefinitionResultDto retrieveStoredQuery(String qualifiedName, String version) {
        QueryDefinitionResultDto result;
        SemVer requestedVersion = StoredQueryServiceImp.parseRequestSemVer(version);
        StoredQueryQualifiedName storedQueryQualifiedName = StoredQueryQualifiedName.create(qualifiedName, requestedVersion);
        try {
            result = CacheProvider.STORED_QUERY_CACHE.get(this.cacheProvider, storedQueryQualifiedName.toQualifiedNameString(), () -> this.retrieveStoredQueryInternal(storedQueryQualifiedName));
        }
        catch (Cache.ValueRetrievalException e) {
            Throwable throwable;
            Throwable throwable2 = e.getCause();
            if (throwable2 instanceof RuntimeException) {
                RuntimeException cause = (RuntimeException)throwable2;
                throwable = cause;
            } else {
                throwable = e;
            }
            throw throwable;
        }
        return result;
    }

    private QueryDefinitionResultDto retrieveStoredQueryInternal(StoredQueryQualifiedName storedQueryQualifiedName) {
        Optional<QueryDefinitionResultDto> storedQueryAccess;
        try {
            storedQueryAccess = this.storedQueryRepository.retrieveQualified(storedQueryQualifiedName);
        }
        catch (DataAccessException e) {
            throw new GeneralRequestProcessingException("Data Access Error: " + e.getCause().getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new InternalServerException(e.getMessage());
        }
        return storedQueryAccess.orElseThrow(() -> new ObjectNotFoundException("QUERY", "Could not retrieve stored query for qualified name: " + storedQueryQualifiedName.toName()));
    }

    public QueryDefinitionResultDto createStoredQuery(String qualifiedName, String version, String queryString) {
        SemVer requestedVersion = StoredQueryServiceImp.parseRequestSemVer(version);
        StoredQueryQualifiedName queryQualifiedName = StoredQueryQualifiedName.create(qualifiedName, requestedVersion);
        try {
            AqlQueryParser.parse((String)queryString);
        }
        catch (AqlParseException e) {
            throw new IllegalArgumentException("Invalid query, reason:" + String.valueOf((Object)e), e);
        }
        SemVer dbSemVer = this.storedQueryRepository.retrieveQualified(queryQualifiedName).map(q -> SemVer.parse(q.getVersion())).orElse(SemVer.NO_VERSION);
        StoredQueryServiceImp.checkVersionCombination(requestedVersion, dbSemVer);
        SemVer newVersion = SemVerUtil.determineVersion(requestedVersion, dbSemVer);
        StoredQueryQualifiedName newQueryQualifiedName = StoredQueryQualifiedName.create(qualifiedName, newVersion);
        boolean isUpdate = dbSemVer.isPreRelease();
        try {
            if (isUpdate) {
                this.storedQueryRepository.update(newQueryQualifiedName, queryString);
            } else {
                this.storedQueryRepository.store(newQueryQualifiedName, queryString);
            }
        }
        catch (DataAccessException e) {
            throw new GeneralRequestProcessingException("Data Access Error: " + e.getCause().getMessage(), (Throwable)e);
        }
        catch (VersionConflictException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.evictAllResolutions(newQueryQualifiedName);
        return this.retrieveStoredQueryInternal(newQueryQualifiedName);
    }

    private static void checkVersionCombination(SemVer requestSemVer, SemVer dbSemVer) {
        if (!dbSemVer.isNoVersion()) {
            if (dbSemVer.isPartial()) {
                throw new IllegalStateException("The database contains stored queries with partial versions");
            }
            if (dbSemVer.isPreRelease()) {
                if (!requestSemVer.isPreRelease()) {
                    throw new RuntimeException("Pre-release " + String.valueOf(dbSemVer) + " was provided when " + String.valueOf(requestSemVer) + " was requested");
                }
            } else {
                if (requestSemVer.isPreRelease()) {
                    throw new RuntimeException("Version " + String.valueOf(dbSemVer) + " was provided when pre-release " + String.valueOf(requestSemVer) + " was requested");
                }
                if (requestSemVer.isRelease()) {
                    throw new StateConflictException("Version already exists");
                }
            }
        }
    }

    public void deleteStoredQuery(String qualifiedName, String version) {
        SemVer requestedVersion = StoredQueryServiceImp.parseRequestSemVer(version);
        if (requestedVersion.isNoVersion() || requestedVersion.isPartial()) {
            throw new InvalidApiParameterException("A qualified version has to be specified");
        }
        StoredQueryQualifiedName storedQueryQualifiedName = StoredQueryQualifiedName.create(qualifiedName, requestedVersion);
        try {
            this.storedQueryRepository.delete(storedQueryQualifiedName);
        }
        catch (ObjectNotFoundException e) {
            throw e;
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (RuntimeException e) {
            throw new InternalServerException(e.getMessage());
        }
        finally {
            this.evictAllResolutions(storedQueryQualifiedName);
        }
    }

    private void evictAllResolutions(StoredQueryQualifiedName qualifiedName) {
        SemVerUtil.streamAllResolutions(qualifiedName.semVer()).forEach(v -> CacheProvider.STORED_QUERY_CACHE.evict(this.cacheProvider, new StoredQueryQualifiedName(qualifiedName.reverseDomainName(), qualifiedName.semanticId(), (SemVer)v).toQualifiedNameString()));
    }

    private static SemVer parseRequestSemVer(String version) {
        try {
            return SemVer.parse(version);
        }
        catch (InvalidVersionFormatException e) {
            throw new InvalidApiParameterException("Incorrect version. Use the SEMVER format.", (Throwable)e);
        }
    }
}

