/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.lang.management.ManagementFactory;
import java.util.function.Supplier;
import org.ehrbase.api.service.StatusService;
import org.ehrbase.util.Lazy;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.SelectField;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StatusServiceImp
implements StatusService {
    @Autowired
    private BuildProperties buildProperties;
    private final DSLContext dslContext;
    private final Supplier<String> operatingSystemInformation = Lazy.lazy(() -> String.format("%s %s %s", ManagementFactory.getOperatingSystemMXBean().getName(), ManagementFactory.getOperatingSystemMXBean().getArch(), ManagementFactory.getOperatingSystemMXBean().getVersion()));
    private final Supplier<String> javaVMInformation = Lazy.lazy(() -> String.format("%s %s", ManagementFactory.getRuntimeMXBean().getVmVendor(), ManagementFactory.getRuntimeMXBean().getSystemProperties().get("java.runtime.version")));
    private final Supplier<String> databaseInformation = Lazy.lazy(() -> (String)((Record1)this.getDSLContext().select((SelectField)DSL.function((String)"VERSION", String.class, (Field[])new Field[0])).fetchOne()).value1());
    private final Supplier<String> ehrbaseVersion = Lazy.lazy(() -> this.getBuildProperties().getVersion());
    private final Supplier<String> archieVersion = Lazy.lazy(() -> this.getBuildProperties().get("archie.version"));
    private final Supplier<String> ehrbaseSdkVersion = Lazy.lazy(() -> this.getBuildProperties().get("openEHR_SDK.version"));

    public StatusServiceImp(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public String getOperatingSystemInformation() {
        return this.operatingSystemInformation.get();
    }

    public String getJavaVMInformation() {
        return this.javaVMInformation.get();
    }

    @Transactional
    public String getDatabaseInformation() {
        return this.databaseInformation.get();
    }

    public String getEhrbaseVersion() {
        return this.ehrbaseVersion.get();
    }

    public String getArchieVersion() {
        return this.archieVersion.get();
    }

    public String getOpenEHR_SDK_Version() {
        return this.ehrbaseSdkVersion.get();
    }

    private BuildProperties getBuildProperties() {
        return this.buildProperties;
    }

    private DSLContext getDSLContext() {
        return this.dslContext;
    }
}

