/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service.experimental;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.dto.experimental.ItemTagDto;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.experimental.ItemTagService;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPathUtil;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.parser.AqlParseException;
import org.ehrbase.repository.experimental.ItemTagRepository;
import org.springframework.stereotype.Service;

@Service
public class ItemTagServiceImpl
implements ItemTagService {
    private final ItemTagRepository itemTagRepository;
    private final EhrService ehrService;

    public ItemTagServiceImpl(ItemTagRepository itemTagRepository, EhrService ehrService) {
        this.itemTagRepository = itemTagRepository;
        this.ehrService = ehrService;
    }

    public List<UUID> bulkUpsert(@Nonnull UUID ownerId, @Nonnull UUID targetId, @Nonnull ItemTagDto.ItemTagRMType targetType, @Nonnull List<ItemTagDto> itemTags) {
        if (itemTags.isEmpty()) {
            return List.of();
        }
        this.ehrService.checkEhrExists(ownerId);
        itemTags.forEach(dto -> ItemTagServiceImpl.fillAndValidateDto(dto, ownerId, targetId, targetType));
        return this.itemTagRepository.bulkStore(itemTags);
    }

    public List<ItemTagDto> findItemTag(@Nonnull UUID ownerId, @Nonnull UUID targetVoId, @Nonnull ItemTagDto.ItemTagRMType targetType, @Nonnull Collection<UUID> ids, @Nonnull Collection<String> keys) {
        this.ehrService.checkEhrExists(ownerId);
        return this.itemTagRepository.findForOwnerAndTarget(ownerId, targetVoId, targetType, ids, keys).stream().map(itemTag -> itemTag).toList();
    }

    public void bulkDelete(@Nonnull UUID ownerId, @Nonnull UUID targetVoId, @Nonnull ItemTagDto.ItemTagRMType targetType, @Nonnull Collection<UUID> ids) {
        if (ids.isEmpty()) {
            return;
        }
        this.ehrService.checkEhrExists(ownerId);
        this.itemTagRepository.bulkDelete(ownerId, targetVoId, targetType, ids);
    }

    private static void fillAndValidateDto(ItemTagDto dto, UUID ownerId, UUID targetVoId, ItemTagDto.ItemTagRMType targetType) {
        String key = dto.getKey();
        String value = dto.getValue();
        String targetPath = dto.getTargetPath();
        if (dto.getOwnerId() != null && ObjectUtils.notEqual((Object)dto.getOwnerId(), (Object)ownerId)) {
            throw new UnprocessableEntityException("Owner mismatch for ItemTag '%s': %s vs. %s".formatted(key, dto.getOwnerId(), ownerId));
        }
        if (dto.getTarget() != null && ObjectUtils.notEqual((Object)dto.getTarget(), (Object)targetVoId)) {
            throw new ValidationException("Target mismatch for ItemTag '%s': %s vs. %s".formatted(key, dto.getTarget(), targetVoId));
        }
        ItemTagServiceImpl.validateTagKey(key);
        ItemTagServiceImpl.validateTagValue(key, value);
        ItemTagServiceImpl.validateTargetPath(key, targetPath);
        ItemTagServiceImpl.validateTargetType(dto, targetType);
        dto.setOwnerId(ownerId);
        dto.setTarget(targetVoId);
        dto.setTargetType(targetType);
    }

    @VisibleForTesting
    static void validateTagKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new UnprocessableEntityException("ItemTag key must not be blank");
        }
        if (!key.matches("^[a-zA-Z0-9/\\-_:]*$")) {
            throw new UnprocessableEntityException("ItemTag key '%s' contains invalid characters, only alphanumerics, minus, slash, underscore are allowed".formatted(key));
        }
    }

    @VisibleForTesting
    static void validateTagValue(String key, String value) {
        if (StringUtils.isBlank((CharSequence)value) && value != null) {
            throw new UnprocessableEntityException("ItemTag '%s' value must not be blank".formatted(key));
        }
    }

    @VisibleForTesting
    static void validateTargetPath(String key, String targetPath) {
        AqlObjectPath path;
        if (targetPath == null) {
            return;
        }
        if (!targetPath.startsWith("/")) {
            throw new UnprocessableEntityException("ItemTag '%s' target_path '%s' does not start at root".formatted(key, targetPath));
        }
        if (targetPath.length() < 2) {
            throw new UnprocessableEntityException("ItemTag '%s' target_path cannot target '/', use null instead".formatted(key));
        }
        try {
            path = AqlObjectPath.parse((String)targetPath.substring(1));
        }
        catch (AqlParseException e) {
            throw new UnprocessableEntityException(e.getMessage(), (Throwable)e);
        }
        path.getPathNodes().forEach(node -> {
            if (node.getPredicateOrOperands().size() > 1) {
                throw new UnprocessableEntityException("ItemTag '%s' target_path '%s': OR predicates are not supported".formatted(key, targetPath));
            }
            node.getPredicateOrOperands().stream().map(AndOperatorPredicate::getOperands).flatMap(Collection::stream).map(ComparisonOperatorPredicate::getPath).filter(p -> !AqlObjectPathUtil.ARCHETYPE_NODE_ID.equals(p) && !AqlObjectPathUtil.NAME_VALUE.equals(p)).findFirst().ifPresent(__ -> {
                throw new UnprocessableEntityException("ItemTag '%s' target_path '%s': only predicates on archetype_node_id and name/value are supported".formatted(key, targetPath));
            });
        });
    }

    private static void validateTargetType(ItemTagDto itemTag, ItemTagDto.ItemTagRMType targetType) {
        ItemTagDto.ItemTagRMType tagType = itemTag.getTargetType();
        if (tagType != null && !Objects.equals(tagType, targetType)) {
            throw new ValidationException("target_type does not match %s".formatted(targetType.name()));
        }
    }
}

