/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.ehr.VersionedComposition;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.jooq.pg.tables.records.CompDataHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.CompDataRecord;
import org.ehrbase.jooq.pg.tables.records.CompVersionHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.CompVersionRecord;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.repository.AbstractVersionedObjectRepository;
import org.ehrbase.repository.AuditDetailsTargetType;
import org.ehrbase.repository.ContributionRepository;
import org.ehrbase.service.TimeProvider;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CompositionRepository
extends AbstractVersionedObjectRepository<CompVersionRecord, CompDataRecord, CompVersionHistoryRecord, CompDataHistoryRecord, Composition> {
    private final KnowledgeCacheService knowledgeCache;

    public CompositionRepository(DSLContext context, ContributionRepository contributionRepository, SystemService systemService, KnowledgeCacheService knowledgeCache, TimeProvider timeProvider) {
        super(AuditDetailsTargetType.COMPOSITION, Tables.COMP_VERSION, Tables.COMP_DATA, Tables.COMP_VERSION_HISTORY, Tables.COMP_DATA_HISTORY, context, contributionRepository, systemService, timeProvider);
        this.knowledgeCache = knowledgeCache;
    }

    @Override
    protected Class<Composition> getLocatableClass() {
        return Composition.class;
    }

    @Override
    protected List<TableField<CompVersionRecord, ?>> getVersionDataJoinFields() {
        return List.of(Tables.COMP_VERSION.VO_ID);
    }

    @Transactional
    public void commit(UUID ehrId, Composition composition, @Nullable UUID contributionId, @Nullable UUID auditId) {
        UUID templateId = (UUID)Optional.of(composition).map(Locatable::getArchetypeDetails).map(Archetyped::getTemplateId).map(ObjectId::getValue).flatMap(arg_0 -> ((KnowledgeCacheService)this.knowledgeCache).findUuidByTemplateId(arg_0)).orElseThrow(() -> new IllegalArgumentException("Unknown or missing template in composition to be stored"));
        String rootConcept = AslRmTypeAndConcept.toEntityConcept((String)composition.getArchetypeNodeId());
        this.commitHead(ehrId, (Locatable)composition, contributionId, auditId, ContributionChangeType.creation, r -> {
            r.setTemplateId(templateId);
            r.setRootConcept(rootConcept);
        }, (n, r) -> {});
    }

    @Transactional
    public void delete(UUID ehrId, UUID compId, int version, @Nullable UUID contributionId, @Nullable UUID auditId) {
        this.delete(ehrId, this.singleCompositionInEhrCondition(ehrId, compId, this.tables.versionHead()), version, contributionId, auditId, "No Composition found with: %s ".formatted(compId));
    }

    public boolean isTemplateUsed(String templateId) {
        Optional templateUuid = this.knowledgeCache.findUuidByTemplateId(templateId);
        if (templateUuid.isEmpty()) {
            return false;
        }
        return this.context.select((SelectField)Tables.COMP_VERSION.VO_ID).from((TableLike)Tables.COMP_VERSION).where(new Condition[]{Tables.COMP_VERSION.TEMPLATE_ID.eq((Object)((UUID)templateUuid.get())), Tables.COMP_VERSION.SYS_VERSION.eq((Object)1)}).limit((Number)1).unionAll((Select)this.context.select((SelectField)Tables.COMP_VERSION_HISTORY.VO_ID).from((TableLike)Tables.COMP_VERSION_HISTORY).where(new Condition[]{Tables.COMP_VERSION_HISTORY.TEMPLATE_ID.eq((Object)((UUID)templateUuid.get())), Tables.COMP_VERSION_HISTORY.SYS_VERSION.eq((Object)1)}).limit((Number)1)).limit((Number)1).fetchOptional().isPresent();
    }

    @Transactional
    public void update(UUID ehrId, Composition composition, @Nullable UUID contributionId, @Nullable UUID auditId) {
        UUID rootId = CompositionRepository.extractUid(composition.getUid());
        UUID templateId = (UUID)Optional.of(composition).map(Locatable::getArchetypeDetails).map(Archetyped::getTemplateId).map(ObjectId::getValue).flatMap(arg_0 -> ((KnowledgeCacheService)this.knowledgeCache).findUuidByTemplateId(arg_0)).orElseThrow(() -> new IllegalArgumentException("Unknown or missing template in composition to be stored"));
        String rootConcept = AslRmTypeAndConcept.toEntityConcept((String)composition.getArchetypeNodeId());
        this.update(ehrId, composition, this.singleCompositionInEhrCondition(ehrId, rootId, this.tables.versionHead()), this.singleCompositionInEhrCondition(ehrId, rootId, this.tables.versionHistory()), contributionId, auditId, r -> {
            r.setTemplateId(templateId);
            r.setRootConcept(rootConcept);
        }, (n, r) -> {}, "No COMPOSITION with given id: %s".formatted(rootId));
    }

    public boolean exists(UUID compId) {
        return this.context.selectOne().from((TableLike)Tables.COMP_VERSION).where(Tables.COMP_VERSION.VO_ID.eq((Object)compId)).unionAll((Select)this.context.selectOne().from((TableLike)Tables.COMP_VERSION_HISTORY).where(Tables.COMP_VERSION_HISTORY.VO_ID.eq((Object)compId))).fetchAny() != null;
    }

    public Optional<Integer> getLatestVersionNumber(UUID compId) {
        return this.context.select((SelectField)Tables.COMP_VERSION.SYS_VERSION).from((TableLike)Tables.COMP_VERSION).where(Tables.COMP_VERSION.VO_ID.eq((Object)compId)).unionAll((Select)this.context.select((SelectField)Tables.COMP_VERSION_HISTORY.SYS_VERSION).from((TableLike)Tables.COMP_VERSION_HISTORY).where(Tables.COMP_VERSION_HISTORY.VO_ID.eq((Object)compId))).orderBy((OrderField)Tables.COMP_VERSION.SYS_VERSION.desc()).limit((Number)1).fetchOptional(Record1::value1);
    }

    public Optional<Integer> getLatestVersionNumber(UUID ehrId, UUID compId) {
        return this.context.select((SelectField)Tables.COMP_VERSION.SYS_VERSION).from((TableLike)Tables.COMP_VERSION).where(Tables.COMP_VERSION.EHR_ID.eq((Object)ehrId).and(Tables.COMP_VERSION.VO_ID.eq((Object)compId))).unionAll((Select)this.context.select((SelectField)Tables.COMP_VERSION_HISTORY.SYS_VERSION).from((TableLike)Tables.COMP_VERSION_HISTORY).where(Tables.COMP_VERSION_HISTORY.EHR_ID.eq((Object)ehrId).and(Tables.COMP_VERSION_HISTORY.VO_ID.eq((Object)compId)))).orderBy((OrderField)Tables.COMP_VERSION.SYS_VERSION.desc()).limit((Number)1).fetchOptional(Record1::value1);
    }

    public boolean isDeleted(UUID ehrId, UUID compId, Integer version) {
        return this.isDeleted(this.singleCompositionInEhrCondition(ehrId, compId, this.tables.versionHead()), this.singleCompositionInEhrCondition(ehrId, compId, this.tables.versionHistory()), version);
    }

    private Condition singleCompositionInEhrCondition(UUID ehrId, UUID compId, Table<?> versionTable) {
        return versionTable.field((Field)CompositionRepository.VERSION_PROTOTYPE.EHR_ID).eq((Object)ehrId).and(versionTable.field((Field)CompositionRepository.VERSION_PROTOTYPE.VO_ID).eq((Object)compId));
    }

    public Optional<Composition> findByVersion(UUID ehrId, UUID compId, int version) {
        return this.findByVersion(this.singleCompositionInEhrCondition(ehrId, compId, this.tables.versionHead()), this.singleCompositionInEhrCondition(ehrId, compId, this.tables.versionHistory()), version);
    }

    public Optional<Composition> findHead(UUID ehrId, UUID compId) {
        return this.findHead(this.singleCompositionInEhrCondition(ehrId, compId, this.tables.versionHead()));
    }

    private Optional<CompVersionHistoryRecord> findRootRecordByVersion(UUID ehrId, UUID compId, int version) {
        return this.findRootRecordByVersion(this.singleCompositionInEhrCondition(ehrId, compId, this.tables.versionHead()), this.singleCompositionInEhrCondition(ehrId, compId, this.tables.versionHistory()), version);
    }

    public Optional<VersionedComposition> getVersionedComposition(UUID ehrId, UUID composition) {
        return this.findRootRecordByVersion(ehrId, composition, 1).map(root -> {
            VersionedComposition versionedComposition = new VersionedComposition();
            versionedComposition.setUid(new HierObjectId(root.getVoId().toString()));
            versionedComposition.setOwnerId(new ObjectRef((ObjectId)new HierObjectId(ehrId.toString()), "local", "ehr"));
            versionedComposition.setTimeCreated(new DvDateTime((TemporalAccessor)root.getSysPeriodLower()));
            return versionedComposition;
        });
    }

    public Optional<String> findTemplateId(UUID compId) {
        return this.context.select((SelectField)Tables.COMP_VERSION.TEMPLATE_ID).from(this.tables.versionHead()).where(new Condition[]{Tables.COMP_VERSION.VO_ID.eq((Object)compId), Tables.COMP_VERSION.SYS_VERSION.eq((Object)1)}).unionAll((Select)this.context.select((SelectField)Tables.COMP_VERSION_HISTORY.TEMPLATE_ID).from(this.tables.versionHistory()).where(new Condition[]{Tables.COMP_VERSION_HISTORY.VO_ID.eq((Object)compId), Tables.COMP_VERSION_HISTORY.SYS_VERSION.eq((Object)1)})).fetchOptional(Record1::value1).flatMap(arg_0 -> ((KnowledgeCacheService)this.knowledgeCache).findTemplateIdByUuid(arg_0));
    }

    public Optional<UUID> findEHRforComposition(UUID compId) {
        return this.context.select((SelectField)Tables.COMP_VERSION.EHR_ID).from(this.tables.versionHead()).where(Tables.COMP_VERSION.VO_ID.eq((Object)compId)).limit((Number)1).unionAll((Select)this.context.select((SelectField)Tables.COMP_VERSION_HISTORY.EHR_ID).from((TableLike)Tables.COMP_VERSION_HISTORY).where(Tables.COMP_VERSION_HISTORY.VO_ID.eq((Object)compId)).limit((Number)1)).limit((Number)1).fetchOptional().map(Record1::value1);
    }

    public Optional<OriginalVersion<Composition>> getOriginalVersionComposition(UUID ehrUid, UUID versionedObjectUid, int version) {
        return this.getOriginalVersion(this.singleCompositionInEhrCondition(ehrUid, versionedObjectUid, this.tables.versionHead()), this.singleCompositionInEhrCondition(ehrUid, versionedObjectUid, this.tables.versionHistory()), version);
    }

    public Optional<Integer> findVersionByTime(UUID compositionId, OffsetDateTime time) {
        return this.findVersionByTime(Tables.COMP_VERSION.VO_ID.eq((Object)compositionId), Tables.COMP_VERSION_HISTORY.VO_ID.eq((Object)compositionId), time).map(AbstractVersionedObjectRepository::extractVersion);
    }

    @Transactional
    public void adminDelete(UUID compId) {
        this.context.delete((Table)Tables.COMP_VERSION_HISTORY).where(Tables.COMP_VERSION_HISTORY.VO_ID.eq((Object)compId)).execute();
        this.context.delete((Table)Tables.COMP_VERSION).where(Tables.COMP_VERSION.VO_ID.eq((Object)compId)).execute();
    }

    @Transactional
    public void adminDeleteAll(UUID ehrId) {
        this.context.delete((Table)Tables.COMP_VERSION_HISTORY).where(Tables.COMP_VERSION_HISTORY.EHR_ID.eq((Object)ehrId)).execute();
        this.context.delete((Table)Tables.COMP_VERSION).where(Tables.COMP_VERSION.EHR_ID.eq((Object)ehrId)).execute();
    }
}

