/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ehrbase.api.exception.InternalServerException;
import org.jooq.DSLContext;
import org.jooq.Loader;
import org.jooq.Record;
import org.jooq.Table;

public class RepositoryHelper {
    private RepositoryHelper() {
    }

    public static <T extends Record> void executeBulkInsert(DSLContext context, Stream<T> recordStream, Table<?> table) {
        try {
            Loader execute = context.loadInto(table).bulkAfter(500).loadRecords(recordStream).fields(table.fields()).execute();
            if (!execute.result().errors().isEmpty()) {
                throw new InternalServerException(execute.result().errors().stream().map(e -> e.exception().getMessage()).collect(Collectors.joining(";")));
            }
        }
        catch (IOException e2) {
            throw new InternalServerException((Throwable)e2);
        }
    }
}

