/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.openehr.dbformat.StructureIndex;
import org.ehrbase.openehr.dbformat.StructureNode;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.dbformat.VersionedObjectDataStructure;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectDataRecordPrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectDataTablePrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectVersionRecordPrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectVersionTablePrototype;
import org.ehrbase.repository.AbstractVersionedObjectRepository;
import org.jooq.DSLContext;
import org.jooq.JSONB;
import org.jooq.Table;

public record VersionDataDbRecord(ObjectVersionRecordPrototype versionRecord, Supplier<Stream<Pair<StructureNode, ObjectDataRecordPrototype>>> dataRecords) {
    public static VersionDataDbRecord toRecords(UUID ehrId, Locatable versionDataObject, UUID contributionId, UUID auditId, OffsetDateTime now, DSLContext context) {
        UUID voId = UUID.fromString(versionDataObject.getUid().getRoot().getValue());
        ObjectVersionRecordPrototype versionRecord = VersionDataDbRecord.buildVersionRecord(context, ehrId, voId, AbstractVersionedObjectRepository.extractVersion(versionDataObject.getUid()), contributionId, auditId, now);
        List roots = VersionedObjectDataStructure.createDataStructure((RMObject)versionDataObject);
        return new VersionDataDbRecord(versionRecord, () -> VersionDataDbRecord.buildDataRecords(voId, roots, context));
    }

    private static ObjectVersionRecordPrototype buildVersionRecord(DSLContext context, UUID ehrId, UUID voId, int sysVersion, UUID contributionId, UUID auditId, OffsetDateTime now) {
        ObjectVersionRecordPrototype objectDataRecord = (ObjectVersionRecordPrototype)context.newRecord((Table)ObjectVersionTablePrototype.INSTANCE);
        objectDataRecord.setEhrId(ehrId);
        objectDataRecord.setVoId(voId);
        objectDataRecord.setSysVersion(Integer.valueOf(sysVersion));
        objectDataRecord.setSysPeriodLower(now);
        objectDataRecord.setAuditId(auditId);
        objectDataRecord.setContributionId(contributionId);
        return objectDataRecord;
    }

    private static Stream<Pair<StructureNode, ObjectDataRecordPrototype>> buildDataRecords(UUID voId, Collection<StructureNode> nodeList, DSLContext context) {
        return nodeList.stream().filter(r -> r.getStructureRmType().isStructureEntry()).map(n -> Pair.of((Object)n, (Object)VersionDataDbRecord.buildDataRecord(voId, n, context)));
    }

    private static ObjectDataRecordPrototype buildDataRecord(UUID voId, StructureNode node, DSLContext context) {
        ObjectDataRecordPrototype rec = (ObjectDataRecordPrototype)context.newRecord((Table)ObjectDataTablePrototype.INSTANCE);
        rec.setNum(Integer.valueOf(node.getNum()));
        rec.setCitemNum((Integer)Optional.of(node).map(StructureNode::getContentItem).map(StructureNode::getNum).orElse(null));
        rec.setParentNum(Integer.valueOf(node.getParentNum()));
        rec.setNumCap(Integer.valueOf(node.getNumCap()));
        rec.setRmEntity(((StructureRmType)StructureRmType.byTypeName((String)node.getRmEntity()).orElseThrow(() -> new InternalServerException("No alias for %s".formatted(node.getRmEntity())))).getAlias());
        rec.setEntityConcept(AslRmTypeAndConcept.toEntityConcept((String)node.getArchetypeNodeId()));
        rec.setEntityName(node.getEntityName());
        StructureIndex index = node.getEntityIdx();
        rec.setEntityAttribute(index.printLastAttribute());
        rec.setEntityIdx(index.printIndexString(false, true));
        rec.setEntityIdxLen(Integer.valueOf(index.length()));
        rec.setData(JSONB.valueOf((String)VersionedObjectDataStructure.applyRmAliases((ObjectNode)node.getJsonNode()).toString()));
        rec.setVoId(voId);
        return rec;
    }
}

