/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.knowledge.TemplateMetaData;
import org.ehrbase.repository.CompositionRepository;
import org.ehrbase.repository.TemplateStoreRepository;
import org.ehrbase.service.TemplateStorage;
import org.ehrbase.util.TemplateUtils;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TemplateDBStorageService
implements TemplateStorage {
    private static final String PROP_ALLOW_TEMPLATE_OVERWRITE = "ehrbase.template.allow-overwrite";
    private static final Logger log = LoggerFactory.getLogger(TemplateDBStorageService.class);
    private final CompositionRepository compositionRepository;
    private final TemplateStoreRepository templateStoreRepository;
    private final boolean allowTemplateOverwrite;

    public TemplateDBStorageService(@Lazy CompositionRepository compositionRepository, TemplateStoreRepository templateStoreRepository, @Value(value="${ehrbase.template.allow-overwrite:false}") boolean allowTemplateOverwrite) {
        this.compositionRepository = compositionRepository;
        this.templateStoreRepository = templateStoreRepository;
        this.allowTemplateOverwrite = allowTemplateOverwrite;
        if (allowTemplateOverwrite) {
            log.warn("Template overwriting is enabled, this is not recommended for production use and can lead to unexpected behavior, consider disabling {}", (Object)PROP_ALLOW_TEMPLATE_OVERWRITE);
        }
    }

    @Override
    public boolean allowTemplateOverwrite() {
        return this.allowTemplateOverwrite;
    }

    @Override
    public List<TemplateMetaData> listAllOperationalTemplates() {
        return this.templateStoreRepository.findAll();
    }

    @Override
    public Map<UUID, String> findAllTemplateIds() {
        return this.templateStoreRepository.findAllTemplateIds();
    }

    @Override
    public TemplateMetaData storeTemplate(OPERATIONALTEMPLATE template) {
        String templateId = TemplateUtils.getTemplateId(template);
        if (this.findUuidByTemplateId(templateId).isEmpty()) {
            return this.templateStoreRepository.store(template);
        }
        boolean templateUsed = this.compositionRepository.isTemplateUsed(templateId);
        if (templateUsed) {
            if (this.allowTemplateOverwrite) {
                log.warn("Updating template {} that is in use by at least one composition because {} is enabled", (Object)templateId, (Object)PROP_ALLOW_TEMPLATE_OVERWRITE);
            } else {
                throw new UnprocessableEntityException("Cannot update template %s since it is used by at least one composition".formatted(templateId));
            }
        }
        return this.templateStoreRepository.update(template);
    }

    @Override
    public Optional<TemplateMetaData> readTemplate(String templateId) {
        return this.templateStoreRepository.findByTemplateId(templateId);
    }

    private void checkUsages() {
        List<String> usedTemplateIds = this.templateStoreRepository.getTemplateUsages();
        if (!usedTemplateIds.isEmpty()) {
            boolean single = usedTemplateIds.size() == 1;
            throw new UnprocessableEntityException("Cannot delete %s %s since %s used by at least one composition".formatted(single ? "template" : "templates", String.join((CharSequence)", ", usedTemplateIds), single ? "it is" : "they are"));
        }
    }

    @Override
    public void deleteTemplate(String templateId) {
        if (this.compositionRepository.isTemplateUsed(templateId)) {
            throw new UnprocessableEntityException("Cannot delete template %s since it is used by at least one composition".formatted(templateId));
        }
        this.templateStoreRepository.delete(templateId);
    }

    @Override
    public List<Pair<UUID, String>> deleteAllTemplates() {
        this.checkUsages();
        return this.templateStoreRepository.findAll().stream().map(t -> {
            String templateId = TemplateUtils.getTemplateId(t.getOperationaltemplate());
            this.templateStoreRepository.delete(templateId);
            return Pair.of((Object)t.getInternalId(), (Object)templateId);
        }).toList();
    }

    @Override
    public Optional<String> findTemplateIdByUuid(UUID uuid) {
        return this.templateStoreRepository.findTemplateIdByUuid(uuid);
    }

    @Override
    public Optional<UUID> findUuidByTemplateId(String templateId) {
        return this.templateStoreRepository.findUuidByTemplateId(templateId);
    }
}

