/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service.contribution;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.ehr.EhrStatus;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.ehrbase.api.dto.EhrStatusDto;
import org.ehrbase.openehr.sdk.response.dto.ContributionCreateDto;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.service.contribution.ContributionWrapper;

public class ContributionServiceHelper {
    public static ContributionWrapper unmarshalContribution(String content) {
        try {
            ObjectNode root = (ObjectNode)CanonicalJson.MARSHAL_OM.readTree(content);
            root.remove("_type");
            ContributionCreateDto contributionCreateDto = (ContributionCreateDto)CanonicalJson.MARSHAL_OM.convertValue((Object)root, ContributionCreateDto.class);
            ContributionWrapper contributionWrapper = new ContributionWrapper(contributionCreateDto);
            ContributionServiceHelper.registerDtos(contributionWrapper, root);
            return contributionWrapper;
        }
        catch (JsonProcessingException | RuntimeException e) {
            throw new IllegalArgumentException("Error while processing given json input: " + e.getMessage(), e);
        }
    }

    private static void registerDtos(ContributionWrapper contributionWrapper, ObjectNode root) {
        ArrayNode rawVersions = (ArrayNode)root.get("versions");
        List versions = contributionWrapper.getContributionCreateDto().getVersions();
        IntStream.range(0, versions.size()).forEach(idx -> {
            OriginalVersion originalVersion = (OriginalVersion)versions.get(idx);
            RMObject data = (RMObject)originalVersion.getData();
            if (data instanceof EhrStatus) {
                Optional.of(rawVersions.get(idx)).map(node -> node.get("data")).map(JsonNode::deepCopy).ifPresent(node -> {
                    ((ObjectNode)node).remove("_type");
                    EhrStatusDto ehrStatusDto = (EhrStatusDto)CanonicalJson.MARSHAL_OM.convertValue(node, EhrStatusDto.class);
                    contributionWrapper.registerDtoForVersion((OriginalVersion<? extends RMObject>)originalVersion, ehrStatusDto);
                });
            }
        });
    }
}

