/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.lang.runtime.SwitchBootstraps;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.tables.Ehr;
import org.ehrbase.jooq.pg.util.AdditionalSQLFunctions;
import org.ehrbase.openehr.dbformat.DbToRmFormat;
import org.ehrbase.openehr.dbformat.StructureNode;
import org.ehrbase.openehr.dbformat.jooq.prototypes.AbstractRecordPrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.AbstractTablePrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectDataHistoryTablePrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectDataRecordPrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectDataTablePrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectVersionHistoryTablePrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectVersionTablePrototype;
import org.ehrbase.repository.AuditDetailsTargetType;
import org.ehrbase.repository.ContributionRepository;
import org.ehrbase.repository.RepositoryHelper;
import org.ehrbase.repository.VersionDataDbRecord;
import org.ehrbase.service.TimeProvider;
import org.jooq.ArrayAggOrderByStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.JSONB;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectFromStep;
import org.jooq.SelectJoinStep;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectOrderByStep;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UpdatableRecord;
import org.jooq.impl.DSL;

public abstract class AbstractVersionedObjectRepository<VR extends UpdatableRecord, DR extends UpdatableRecord, VH extends UpdatableRecord, DH extends UpdatableRecord, O extends Locatable> {
    public static final String NOT_MATCH_UID = "If-Match version_uid does not match uid";
    public static final String NOT_MATCH_SYSTEM_ID = "If-Match version_uid does not match system id";
    public static final String NOT_MATCH_LATEST_VERSION = "If-Match version_uid does not match latest version";
    protected static final ObjectVersionTablePrototype VERSION_PROTOTYPE = ObjectVersionTablePrototype.INSTANCE;
    protected static final ObjectVersionHistoryTablePrototype VERSION_HISTORY_PROTOTYPE = ObjectVersionHistoryTablePrototype.INSTANCE;
    protected static final ObjectDataTablePrototype DATA_PROTOTYPE = ObjectDataTablePrototype.INSTANCE;
    protected static final ObjectDataHistoryTablePrototype DATA_HISTORY_PROTOTYPE = ObjectDataHistoryTablePrototype.INSTANCE;
    private final AuditDetailsTargetType targetType;
    protected final Tables tables;
    protected final DSLContext context;
    protected final ContributionRepository contributionRepository;
    protected final SystemService systemService;
    protected final TimeProvider timeProvider;

    protected AbstractVersionedObjectRepository(AuditDetailsTargetType targetType, Table<VR> versionHead, Table<DR> dataHead, Table<VH> versionHistory, Table<DH> dataHistory, DSLContext context, ContributionRepository contributionRepository, SystemService systemService, TimeProvider timeProvider) {
        this.targetType = targetType;
        this.tables = new Tables(this, versionHead, dataHead, versionHistory, dataHistory);
        this.context = context;
        this.contributionRepository = contributionRepository;
        this.systemService = systemService;
        this.timeProvider = timeProvider;
    }

    public static ObjectVersionId buildObjectVersionId(UUID versionedObjectId, int sysVersion, SystemService systemService) {
        return new ObjectVersionId(versionedObjectId.toString(), systemService.getSystemId(), Integer.toString(sysVersion));
    }

    protected Optional<O> findHead(Condition condition) {
        SelectQuery<Record> locatableDataQuery = this.buildLocatableDataQuery(condition, true);
        return this.toLocatable(locatableDataQuery.fetchOne(), this.getLocatableClass());
    }

    public Optional<O> findByVersion(Condition condition, Condition historyCondition, int version) {
        SelectQuery<Record> headQuery = this.buildLocatableDataQuery(condition, true);
        headQuery.addConditions(this.field(AbstractVersionedObjectRepository.VERSION_PROTOTYPE.SYS_VERSION).eq((Object)version));
        SelectQuery<Record> historyQuery = this.buildLocatableDataQuery(historyCondition, false);
        historyQuery.addConditions(this.field(AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_VERSION).eq((Object)version));
        Record dataRecord = headQuery.unionAll(historyQuery).fetchOne();
        if (dataRecord == null && !this.isDeleted(condition, historyCondition, version)) {
            String typeName = this.targetType.name();
            throw new ObjectNotFoundException(typeName, "No %s with given ID found".formatted(typeName));
        }
        return this.toLocatable(dataRecord, this.getLocatableClass());
    }

    protected <T> Field<T> field(TableField<? extends AbstractRecordPrototype<?>, T> field) {
        Table table = field.getTable();
        if (table instanceof AbstractTablePrototype) {
            AbstractTablePrototype t;
            AbstractTablePrototype abstractTablePrototype = t = (AbstractTablePrototype)table;
            Objects.requireNonNull(abstractTablePrototype);
            AbstractTablePrototype abstractTablePrototype2 = abstractTablePrototype;
            int n = 0;
            Object targetTable = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ObjectVersionTablePrototype.class, ObjectVersionHistoryTablePrototype.class, ObjectDataTablePrototype.class, ObjectDataHistoryTablePrototype.class}, (Object)abstractTablePrototype2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ObjectVersionTablePrototype __ = (ObjectVersionTablePrototype)abstractTablePrototype2;
                    yield this.tables.versionHead;
                }
                case 1 -> {
                    ObjectVersionHistoryTablePrototype __ = (ObjectVersionHistoryTablePrototype)abstractTablePrototype2;
                    yield this.tables.versionHistory;
                }
                case 2 -> {
                    ObjectDataTablePrototype __ = (ObjectDataTablePrototype)abstractTablePrototype2;
                    yield this.tables.dataHead;
                }
                case 3 -> {
                    ObjectDataHistoryTablePrototype __ = (ObjectDataHistoryTablePrototype)abstractTablePrototype2;
                    yield this.tables.dataHistory;
                }
            };
            return targetTable.field(field);
        }
        throw new IllegalArgumentException("Type of table not supported: %s".formatted(field.getTable()));
    }

    protected Optional<VH> findRootRecordByVersion(Condition condition, Condition historyCondition, int version) {
        Table head = this.tables.versionHead;
        Table history = this.tables.versionHistory;
        Field[] historyFields = (Field[])Stream.concat(Arrays.stream(head.fields()), Stream.of(AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_PERIOD_UPPER, AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_DELETED)).map(arg_0 -> history.field(arg_0)).toArray(Field[]::new);
        return this.versionHeadQueryExtended(this.context).where(condition).and(this.field(AbstractVersionedObjectRepository.VERSION_PROTOTYPE.SYS_VERSION).eq((Object)version)).unionAll((Select)this.context.select((SelectFieldOrAsterisk[])historyFields).from(history).where(historyCondition).and(history.field((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_VERSION).eq((Object)version))).fetchOptional().map(r -> (UpdatableRecord)r.into(history));
    }

    public SelectOrderByStep<Record3<String, UUID, Integer>> buildVersionIdsByContributionQuery(String rmKey, UUID ehrId, UUID contributionId) {
        return this.context.select((SelectField)DSL.inline((String)rmKey), this.field(AbstractVersionedObjectRepository.VERSION_PROTOTYPE.VO_ID), this.field(AbstractVersionedObjectRepository.VERSION_PROTOTYPE.SYS_VERSION)).from(this.tables.versionHead).where(this.contributionCondition(ehrId, contributionId, this.tables.versionHead)).unionAll((Select)this.context.select((SelectField)DSL.inline((String)rmKey), (SelectField)this.tables.versionHistory.field((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.VO_ID), (SelectField)this.tables.versionHistory.field((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_VERSION)).from(this.tables.versionHistory).where(this.contributionCondition(ehrId, contributionId, this.tables.versionHistory)));
    }

    protected Condition contributionCondition(UUID ehrId, UUID contributionId, Table<?> table) {
        return table.field((Field)AbstractVersionedObjectRepository.VERSION_PROTOTYPE.CONTRIBUTION_ID).eq((Object)contributionId).and(table.field((Field)AbstractVersionedObjectRepository.VERSION_PROTOTYPE.EHR_ID).eq((Object)ehrId));
    }

    protected boolean isDeleted(Condition condition, Condition historyCondition, Integer version) {
        return this.findRootRecordByVersion(condition, historyCondition, version).filter(r -> (Boolean)r.get(this.field(AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_DELETED))).isPresent();
    }

    protected Optional<VH> findLatestHistoryRoot(Condition condition) {
        return this.context.selectFrom(this.tables.versionHistory).where(condition).orderBy((OrderField)this.field(AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_VERSION).desc()).limit((Number)1).fetchOptional();
    }

    protected void delete(UUID ehrId, Condition condition, int version, UUID contributionId, UUID auditId, String notfoundMessage) {
        Result<VH> versionHeads = this.findVersionHeadRecords(condition);
        if (versionHeads.isEmpty()) {
            throw new ObjectNotFoundException(this.getLocatableClass().getSimpleName(), notfoundMessage);
        }
        if (versionHeads.size() > 1) {
            throw new IllegalArgumentException("The implementation is limited to deleting one entry");
        }
        UpdatableRecord versionHead = (UpdatableRecord)versionHeads.getFirst();
        UpdatableRecord firstRecord = (UpdatableRecord)versionHead.into(this.tables.versionHistory);
        if ((Integer)firstRecord.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_VERSION) != version) {
            throw new StateConflictException(NOT_MATCH_LATEST_VERSION);
        }
        this.copyHeadToHistory(versionHead, this.createCurrentTime((OffsetDateTime)firstRecord.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_PERIOD_LOWER)));
        this.deleteHead(condition, version, StateConflictException::new);
        UUID finalContributionId = Optional.ofNullable(contributionId).orElseGet(() -> this.contributionRepository.createDefault(ehrId, ContributionDataType.folder, ContributionChangeType.deleted));
        UUID finalAuditId = Optional.ofNullable(auditId).orElseGet(() -> this.contributionRepository.createDefaultAudit(ContributionChangeType.deleted, this.targetType));
        firstRecord.set((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_DELETED, (Object)true);
        firstRecord.set((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_VERSION, (Object)(version + 1));
        firstRecord.set((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.AUDIT_ID, (Object)finalAuditId);
        firstRecord.set((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.CONTRIBUTION_ID, (Object)finalContributionId);
        firstRecord.changed(true);
        firstRecord.insert();
    }

    protected Optional<OriginalVersion<O>> getOriginalVersion(Condition condition, Condition historyCondition, int version) {
        Optional<VH> root = this.findRootRecordByVersion(condition, historyCondition, version);
        if (root.isEmpty()) {
            return Optional.empty();
        }
        UpdatableRecord versionRecord = (UpdatableRecord)root.get();
        ObjectVersionId versionId = AbstractVersionedObjectRepository.buildObjectVersionId((UUID)versionRecord.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.VO_ID), version, this.systemService);
        DvCodedText lifecycleState = new DvCodedText("complete", new CodePhrase("532"));
        AuditDetails commitAudit = this.contributionRepository.findAuditDetails((UUID)versionRecord.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.AUDIT_ID));
        ObjectRef objectRef = new ObjectRef((ObjectId)new HierObjectId(((UUID)versionRecord.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.CONTRIBUTION_ID)).toString()), "openehr", "contribution");
        ObjectVersionId precedingVersionId = null;
        if (version > 1) {
            precedingVersionId = AbstractVersionedObjectRepository.buildObjectVersionId((UUID)versionRecord.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.VO_ID), version - 1, this.systemService);
        }
        Optional<O> composition = this.findByVersion(condition, historyCondition, version);
        OriginalVersion originalVersion = new OriginalVersion(versionId, precedingVersionId, (Object)composition.orElse(null), lifecycleState, commitAudit, objectRef, null, null, null);
        return Optional.of(originalVersion);
    }

    protected boolean hasEhr(UUID ehrId) {
        return this.context.fetchExists((Table)Ehr.EHR_, Ehr.EHR_.ID.eq((Object)ehrId));
    }

    protected abstract Class<O> getLocatableClass();

    public static int extractVersion(UIDBasedId uid) {
        return Integer.parseInt(((ObjectVersionId)uid).getVersionTreeId().getValue());
    }

    public static UUID extractUid(UIDBasedId uid) {
        return UUID.fromString(uid.getRoot().getValue());
    }

    public static String extractSystemId(UIDBasedId uid) {
        return ((ObjectVersionId)uid).getCreatingSystemId().getValue();
    }

    protected void commitHead(UUID ehrId, Locatable versionDataObject, UUID contributionId, UUID auditId, ContributionChangeType changeType, Consumer<VR> addVersionFieldsFunction, BiConsumer<StructureNode, DR> addDataFieldsFunction) {
        UUID finalContributionId = Optional.ofNullable(contributionId).orElseGet(() -> this.contributionRepository.createDefault(ehrId, ContributionDataType.composition, changeType));
        UUID finalAuditId = Optional.ofNullable(auditId).orElseGet(() -> this.contributionRepository.createDefaultAudit(changeType, this.targetType));
        VersionDataDbRecord versionData = this.toRecords(ehrId, versionDataObject, finalContributionId, finalAuditId);
        UpdatableRecord versionRecord = (UpdatableRecord)versionData.versionRecord().into(this.tables.versionHead);
        addVersionFieldsFunction.accept(versionRecord);
        versionRecord.store();
        RepositoryHelper.executeBulkInsert(this.context, versionData.dataRecords().get().map(r -> {
            UpdatableRecord v = (UpdatableRecord)((ObjectDataRecordPrototype)r.getValue()).into(this.tables.dataHead);
            addDataFieldsFunction.accept((StructureNode)r.getKey(), v);
            return v;
        }), this.tables.dataHead);
    }

    protected final VersionDataDbRecord toRecords(UUID ehrId, Locatable versionDataObject, UUID contributionId, UUID auditId) {
        return VersionDataDbRecord.toRecords(ehrId, versionDataObject, contributionId, auditId, this.timeProvider.getNow(), this.context);
    }

    public void update(UUID ehrId, O versionedObject, Condition condition, Condition historyCondition, UUID contributionId, UUID auditId, Consumer<VR> addVersionFieldsFunction, BiConsumer<StructureNode, DR> addDataFieldsFunction, String notFoundErrorMessage) {
        OffsetDateTime now;
        UUID headVoId;
        int headVersion;
        UpdatableRecord delRecord;
        UIDBasedId nextUid = versionedObject.getUid();
        Result<VH> versionHeads = this.findVersionHeadRecords(condition);
        if (versionHeads.size() > 1) {
            throw new IllegalArgumentException("%d versions were returned".formatted(versionHeads.size()));
        }
        if (versionHeads.isEmpty()) {
            Optional<VH> latestHistoryRoot = this.findLatestHistoryRoot(historyCondition);
            if (latestHistoryRoot.isEmpty()) {
                if (!this.hasEhr(ehrId)) {
                    throw new ObjectNotFoundException("EHR", "EHR %s does not exist".formatted(ehrId));
                }
                throw new ObjectNotFoundException(this.getLocatableClass().getSimpleName(), notFoundErrorMessage);
            }
            delRecord = latestHistoryRoot.filter(r -> (Boolean)r.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_DELETED)).orElseThrow(() -> new PreconditionFailedException(NOT_MATCH_LATEST_VERSION));
            headVersion = (Integer)delRecord.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_VERSION);
            headVoId = (UUID)delRecord.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.VO_ID);
            now = this.createCurrentTime((OffsetDateTime)delRecord.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_PERIOD_LOWER));
        } else {
            delRecord = null;
            UpdatableRecord root = (UpdatableRecord)versionHeads.getFirst();
            headVersion = (Integer)root.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_VERSION);
            headVoId = (UUID)root.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.VO_ID);
            now = this.createCurrentTime((OffsetDateTime)root.get((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_PERIOD_LOWER));
        }
        this.checkIsNextHeadVoId(headVoId, headVersion, nextUid);
        if (delRecord != null) {
            delRecord.set((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_PERIOD_UPPER, (Object)now);
            int updateCount = this.context.executeUpdate(delRecord);
            if (updateCount != 1) {
                throw new PreconditionFailedException(NOT_MATCH_LATEST_VERSION);
            }
        } else {
            this.copyHeadToHistory((UpdatableRecord)versionHeads.getFirst(), now);
            this.deleteHead(condition, headVersion, PreconditionFailedException::new);
        }
        this.commitHead(ehrId, (Locatable)versionedObject, contributionId, auditId, ContributionChangeType.modification, addVersionFieldsFunction, addDataFieldsFunction);
    }

    protected Field<?>[] getAdditionalSelectFields(Table<?> versionTable, Table<?> dataTable, boolean head) {
        return null;
    }

    protected SelectQuery<Record> buildLocatableDataQuery(Condition condition, boolean head) {
        List<Field> groupByFields;
        List<ArrayAggOrderByStep<Record2<String, JSONB>[]>> selectFields;
        Table<?> versionTable = this.tables.get(true, head);
        Table<?> dataTable = this.tables.get(false, head);
        Field voIdField = versionTable.field((Field)AbstractVersionedObjectRepository.VERSION_PROTOTYPE.VO_ID);
        Field sysVersionField = versionTable.field((Field)AbstractVersionedObjectRepository.VERSION_PROTOTYPE.SYS_VERSION);
        ArrayAggOrderByStep<Record2<String, JSONB>[]> dataAggregationField = this.dataArrayAggregation(dataTable);
        Field<?>[] additionalFields = this.getAdditionalSelectFields(versionTable, dataTable, head);
        if (additionalFields == null) {
            selectFields = List.of(voIdField, sysVersionField, dataAggregationField);
            groupByFields = List.of(voIdField, sysVersionField);
        } else {
            selectFields = new ArrayList<ArrayAggOrderByStep<Record2<String, JSONB>[]>>(3 + additionalFields.length);
            groupByFields = new ArrayList<Field>(2 + additionalFields.length);
            selectFields.add((ArrayAggOrderByStep<Record2<String, JSONB>[]>)voIdField);
            selectFields.add((ArrayAggOrderByStep<Record2<String, JSONB>[]>)sysVersionField);
            selectFields.add(dataAggregationField);
            Collections.addAll(selectFields, additionalFields);
            groupByFields.add(voIdField);
            groupByFields.add(sysVersionField);
            Collections.addAll(groupByFields, additionalFields);
        }
        return this.fromJoinedVersionData((SelectFromStep)this.context.select(selectFields), head).where(condition).groupBy(groupByFields).getQuery();
    }

    protected ArrayAggOrderByStep<Record2<String, JSONB>[]> dataArrayAggregation(Table<?> dataTable) {
        Field keyField = dataTable.field((Field)AbstractVersionedObjectRepository.DATA_PROTOTYPE.ENTITY_IDX);
        Field dataField = dataTable.field((Field)AbstractVersionedObjectRepository.DATA_PROTOTYPE.DATA);
        return DSL.arrayAgg((Field)DSL.field((SelectField)DSL.row((SelectField)keyField, (SelectField)dataField)));
    }

    protected <R extends Record> SelectOnConditionStep<R> fromJoinedVersionData(SelectFromStep<R> select, boolean head) {
        Table<?> versionTable = this.tables.get(true, head);
        Table<?> dataTable = this.tables.get(false, head);
        Condition joinCondition = this.versionDataJoinCondition(f -> versionTable.field(f).eq(dataTable.field(f)));
        if (!head) {
            joinCondition = joinCondition.and(versionTable.field((Field)AbstractVersionedObjectRepository.VERSION_PROTOTYPE.SYS_VERSION).eq(dataTable.field((Field)AbstractVersionedObjectRepository.DATA_HISTORY_PROTOTYPE.SYS_VERSION)));
        }
        return select.from(versionTable).join(dataTable).on(joinCondition);
    }

    protected abstract List<TableField<VR, ?>> getVersionDataJoinFields();

    private Condition versionDataJoinCondition(Function<Field, Condition> fieldConditionCreator) {
        List<TableField<VR, ?>> versionDataJoinFields = this.getVersionDataJoinFields();
        Condition joinCondition = versionDataJoinFields.size() == 1 ? fieldConditionCreator.apply((Field)versionDataJoinFields.getFirst()) : DSL.and(versionDataJoinFields.stream().map(fieldConditionCreator).toList());
        return joinCondition;
    }

    protected Condition dataRootCondition(Table<?> dataTable) {
        return dataTable.field((Field)AbstractVersionedObjectRepository.DATA_PROTOTYPE.NUM).eq((Object)0);
    }

    protected Optional<ObjectVersionId> findVersionByTime(Condition condition, Condition historyCondition, OffsetDateTime time) {
        SelectLimitPercentStep headQuery = this.context.select(this.field(AbstractVersionedObjectRepository.VERSION_PROTOTYPE.SYS_VERSION), this.field(AbstractVersionedObjectRepository.VERSION_PROTOTYPE.VO_ID)).from(this.tables.versionHead).where(this.field(AbstractVersionedObjectRepository.VERSION_PROTOTYPE.SYS_PERIOD_LOWER).lessOrEqual((Object)time)).and(condition).limit((Number)1);
        SelectLimitPercentStep historyQuery = this.context.select(this.field(AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_VERSION), this.field(AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.VO_ID)).from(this.tables.versionHistory).where(new Condition[]{this.field(AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_PERIOD_LOWER).lessOrEqual((Object)time), this.field(AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_PERIOD_UPPER).greaterThan((Object)time).or(this.field(AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_PERIOD_UPPER).isNull())}).and(historyCondition).limit((Number)1);
        return headQuery.unionAll((Select)historyQuery).limit((Number)1).fetchOptional().map(r -> AbstractVersionedObjectRepository.buildObjectVersionId((UUID)r.value2(), (Integer)r.value1(), this.systemService));
    }

    protected <L extends Locatable> Optional<L> toLocatable(Record jsonbRecord, Class<L> locatableClass) {
        if (jsonbRecord == null) {
            return Optional.empty();
        }
        Locatable rmObject = (Locatable)DbToRmFormat.reconstructRmObject(locatableClass, (Record2[])((Record2[])jsonbRecord.get(2, Record2[].class)));
        rmObject.setUid((UIDBasedId)AbstractVersionedObjectRepository.buildObjectVersionId((UUID)jsonbRecord.get(0, UUID.class), (Integer)jsonbRecord.get(1, Integer.class), this.systemService));
        return Optional.of(rmObject);
    }

    protected void copyHeadToHistory(VH versionRecord, OffsetDateTime now) {
        versionRecord.set((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_PERIOD_UPPER, (Object)now);
        versionRecord.set((Field)AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_DELETED, (Object)false);
        versionRecord.changed(true);
        versionRecord.insert();
        Field[] headFields = (Field[])Stream.concat(Arrays.stream(this.tables.dataHead.fields()), Stream.of(this.field(AbstractVersionedObjectRepository.VERSION_PROTOTYPE.SYS_VERSION))).toArray(Field[]::new);
        Field[] historyFields = (Field[])Arrays.stream(headFields).map(arg_0 -> this.tables.dataHistory.field(arg_0)).toArray(Field[]::new);
        InsertQuery dataInsert = this.context.insertQuery(this.tables.dataHistory);
        Condition joinCondition = this.versionDataJoinCondition(f -> this.tables.dataHead.field(f).eq((Field)DSL.val((Object)versionRecord.get(f))));
        SelectConditionStep dataSelect = this.fromJoinedVersionData((SelectFromStep)this.context.select((SelectFieldOrAsterisk[])headFields), true).where(joinCondition);
        dataInsert.setSelect(historyFields, (Select)dataSelect);
        dataInsert.execute();
    }

    protected void deleteHead(Condition versionCondition, int oldVersion, Function<String, RuntimeException> exceptionProvider) {
        int deleteCount = this.context.deleteFrom(this.tables.versionHead).where(versionCondition.and(this.field(AbstractVersionedObjectRepository.VERSION_PROTOTYPE.SYS_VERSION).eq((Object)oldVersion))).execute();
        if (deleteCount == 0) {
            throw exceptionProvider.apply(NOT_MATCH_LATEST_VERSION);
        }
    }

    protected SelectJoinStep<Record> versionHeadQueryExtended(DSLContext context) {
        return context.select((SelectFieldOrAsterisk[])this.tables.versionHead.fields()).select(new SelectFieldOrAsterisk[]{DSL.inline(null).as(AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_PERIOD_UPPER.getName()), DSL.inline((boolean)false).as(AbstractVersionedObjectRepository.VERSION_HISTORY_PROTOTYPE.SYS_DELETED.getName())}).from(this.tables.versionHead);
    }

    protected Result<VH> findVersionHeadRecords(Condition condition) {
        return this.versionHeadQueryExtended(this.context).where(condition).fetchInto(this.tables.versionHistory);
    }

    protected Field<String> jsonDataField(Table<DR> table, String ... path) {
        return AdditionalSQLFunctions.jsonbAttributePathText((Field)table.field((Field)AbstractVersionedObjectRepository.DATA_PROTOTYPE.DATA), (String[])path);
    }

    protected OffsetDateTime createCurrentTime(OffsetDateTime lowerBound) {
        OffsetDateTime now = this.timeProvider.getNow();
        if (now.isAfter(lowerBound)) {
            return now;
        }
        return lowerBound.plusNanos(1000L);
    }

    protected void checkIsNextHeadVoId(UUID headVoid, int headVersion, UIDBasedId uid) {
        if (!Objects.equals(headVoid, AbstractVersionedObjectRepository.extractUid(uid))) {
            throw new PreconditionFailedException(NOT_MATCH_UID);
        }
        if (!Objects.equals(this.systemService.getSystemId(), AbstractVersionedObjectRepository.extractSystemId(uid))) {
            throw new PreconditionFailedException(NOT_MATCH_SYSTEM_ID);
        }
        if (headVersion + 1 != AbstractVersionedObjectRepository.extractVersion(uid)) {
            throw new PreconditionFailedException(NOT_MATCH_LATEST_VERSION);
        }
    }

    protected final class Tables {
        private final Table<VR> versionHead;
        private final Table<DR> dataHead;
        private final Table<VH> versionHistory;
        private final Table<DH> dataHistory;

        private Tables(AbstractVersionedObjectRepository this$0, Table<VR> versionHead, Table<DR> dataHead, Table<VH> versionHistory, Table<DH> dataHistory) {
            this.versionHead = versionHead;
            this.dataHead = dataHead;
            this.versionHistory = versionHistory;
            this.dataHistory = dataHistory;
        }

        public Table<VR> versionHead() {
            return this.versionHead;
        }

        public Table<DR> dataHead() {
            return this.dataHead;
        }

        public Table<VH> versionHistory() {
            return this.versionHistory;
        }

        public Table<DH> dataHistory() {
            return this.dataHistory;
        }

        public Table<?> get(boolean version, boolean head) {
            if (version) {
                if (head) {
                    return this.versionHead;
                }
                return this.versionHistory;
            }
            if (head) {
                return this.dataHead;
            }
            return this.dataHistory;
        }
    }
}

