/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service.contribution;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.openehr.sdk.response.dto.ContributionCreateDto;

public class ContributionWrapper {
    private ContributionCreateDto contributionCreateDto;
    private Map<OriginalVersion<? extends RMObject>, Object> versionsToDtos;

    public ContributionWrapper(ContributionCreateDto contributionCreateDto) {
        this.contributionCreateDto = contributionCreateDto;
        this.versionsToDtos = HashMap.newHashMap(contributionCreateDto.getVersions().size());
    }

    public ContributionCreateDto getContributionCreateDto() {
        return this.contributionCreateDto;
    }

    void registerDtoForVersion(OriginalVersion<? extends RMObject> version, Object dto) {
        if (!this.contributionCreateDto.getVersions().contains(version)) {
            throw new InternalServerException("Can not register a dto for a [OriginalVersion<%s>] because it does not exist".formatted(version.getPrecedingVersionUid()));
        }
        this.versionsToDtos.put(version, dto);
    }

    public void forEachVersion(BiConsumer<OriginalVersion<? extends RMObject>, Object> consumer) {
        this.contributionCreateDto.getVersions().forEach(version -> {
            Object dto = this.versionsToDtos.get(version);
            consumer.accept((OriginalVersion<? extends RMObject>)version, dto);
        });
    }
}

