/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.knowledge.TemplateMetaData;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.TemplateStore;
import org.ehrbase.jooq.pg.tables.records.TemplateStoreRecord;
import org.ehrbase.service.TimeProvider;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;
import org.springframework.stereotype.Repository;

@Repository
public class TemplateStoreRepository {
    private final DSLContext context;
    private final TimeProvider timeProvider;

    public TemplateStoreRepository(DSLContext context, TimeProvider timeProvider) {
        this.context = context;
        this.timeProvider = timeProvider;
    }

    public TemplateMetaData store(OPERATIONALTEMPLATE operationaltemplate) {
        TemplateStoreRecord templateStoreRecord = (TemplateStoreRecord)this.context.newRecord((Table)TemplateStore.TEMPLATE_STORE);
        TemplateStoreRepository.setTemplate(operationaltemplate, templateStoreRecord, rec -> rec.setId(UUID.randomUUID()));
        templateStoreRecord.setCreationTime(this.timeProvider.getNow());
        templateStoreRecord.store();
        return TemplateStoreRepository.buildMetadata(templateStoreRecord.getId(), templateStoreRecord.getCreationTime(), templateStoreRecord.getContent());
    }

    public TemplateMetaData update(OPERATIONALTEMPLATE operationaltemplate) {
        String templateId = operationaltemplate.getTemplateId().getValue();
        TemplateStoreRecord templateStoreRecord = (TemplateStoreRecord)this.context.selectFrom((TableLike)TemplateStore.TEMPLATE_STORE).where(TemplateStore.TEMPLATE_STORE.TEMPLATE_ID.eq((Object)templateId)).fetchOptional().orElseThrow(() -> new ObjectNotFoundException("OPERATIONALTEMPLATE", "No template with id = %s".formatted(templateId)));
        TemplateStoreRepository.setTemplate(operationaltemplate, templateStoreRecord, rec -> rec.setId(rec.getId()));
        templateStoreRecord.setCreationTime(this.timeProvider.getNow());
        templateStoreRecord.update();
        return TemplateStoreRepository.buildMetadata(templateStoreRecord.getId(), templateStoreRecord.getCreationTime(), templateStoreRecord.getContent());
    }

    public List<TemplateMetaData> findAll() {
        return this.context.select((SelectField)TemplateStore.TEMPLATE_STORE.CONTENT, (SelectField)TemplateStore.TEMPLATE_STORE.CREATION_TIME, (SelectField)TemplateStore.TEMPLATE_STORE.ID).from((TableLike)TemplateStore.TEMPLATE_STORE).fetch().map(TemplateStoreRepository::buildMetadata);
    }

    public Map<UUID, String> findAllTemplateIds() {
        return (Map)this.context.select((SelectField)TemplateStore.TEMPLATE_STORE.ID, (SelectField)TemplateStore.TEMPLATE_STORE.TEMPLATE_ID).from((TableLike)TemplateStore.TEMPLATE_STORE).collect(Collectors.toMap(Record2::value1, Record2::value2));
    }

    private static TemplateMetaData buildMetadata(Record3<String, OffsetDateTime, UUID> r) {
        return TemplateStoreRepository.buildMetadata((UUID)r.component3(), (OffsetDateTime)r.component2(), (String)r.component1());
    }

    private static TemplateMetaData buildMetadata(UUID internalId, OffsetDateTime creationTime, String templateContent) {
        TemplateMetaData templateMetaData = new TemplateMetaData();
        templateMetaData.setOperationalTemplate(TemplateStoreRepository.buildOperationalTemplate(templateContent));
        templateMetaData.setCreatedOn(creationTime);
        templateMetaData.setInternalId(internalId);
        return templateMetaData;
    }

    public void delete(String templateId) {
        int execute = this.context.deleteFrom((Table)TemplateStore.TEMPLATE_STORE).where(TemplateStore.TEMPLATE_STORE.TEMPLATE_ID.eq((Object)templateId)).execute();
        if (execute == 0) {
            throw new ObjectNotFoundException("OPERATIONALTEMPLATE", "No template with id = %s".formatted(templateId));
        }
    }

    public Optional<TemplateMetaData> findByTemplateId(String templateId) {
        return this.context.select((SelectField)TemplateStore.TEMPLATE_STORE.CONTENT, (SelectField)TemplateStore.TEMPLATE_STORE.CREATION_TIME, (SelectField)TemplateStore.TEMPLATE_STORE.ID).from((TableLike)TemplateStore.TEMPLATE_STORE).where(TemplateStore.TEMPLATE_STORE.TEMPLATE_ID.eq((Object)templateId)).fetchOptional().map(TemplateStoreRepository::buildMetadata);
    }

    public Optional<String> findTemplateIdByUuid(UUID uuid) {
        return this.context.select((SelectField)TemplateStore.TEMPLATE_STORE.TEMPLATE_ID).from((TableLike)TemplateStore.TEMPLATE_STORE).where(TemplateStore.TEMPLATE_STORE.ID.eq((Object)uuid)).fetchOptional((Field)TemplateStore.TEMPLATE_STORE.TEMPLATE_ID);
    }

    public Optional<UUID> findUuidByTemplateId(String templateId) {
        return this.context.select((SelectField)TemplateStore.TEMPLATE_STORE.ID).from((TableLike)TemplateStore.TEMPLATE_STORE).where(TemplateStore.TEMPLATE_STORE.TEMPLATE_ID.eq((Object)templateId)).fetchOptional((Field)TemplateStore.TEMPLATE_STORE.ID);
    }

    private static OPERATIONALTEMPLATE buildOperationalTemplate(String content) {
        TemplateDocument document;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        try {
            document = TemplateDocument.Factory.parse((InputStream)inputStream);
        }
        catch (IOException | XmlException e) {
            throw new InternalServerException(e.getMessage());
        }
        return document.getTemplate();
    }

    private static void setTemplate(OPERATIONALTEMPLATE template, TemplateStoreRecord templateStoreRecord, Consumer<TemplateStoreRecord> setId) {
        setId.accept(templateStoreRecord);
        templateStoreRecord.setTemplateId(template.getTemplateId().getValue());
        XmlOptions opts = new XmlOptions();
        opts.setSaveSyntheticDocumentElement(new QName("http://schemas.openehr.org/v1", "template"));
        templateStoreRecord.setContent(template.xmlText(opts));
    }

    public List<String> getTemplateUsages() {
        return this.context.selectDistinct((SelectField)TemplateStore.TEMPLATE_STORE.TEMPLATE_ID).from((TableLike)TemplateStore.TEMPLATE_STORE).join((TableLike)Tables.COMP_VERSION).on(Tables.COMP_VERSION.TEMPLATE_ID.eq((Field)TemplateStore.TEMPLATE_STORE.ID)).fetch((Field)TemplateStore.TEMPLATE_STORE.TEMPLATE_ID);
    }
}

