/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.function.Function;
import org.ehrbase.cache.CacheProperties;
import org.ehrbase.cache.CacheProvider;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CacheProperties.class})
@EnableCaching
public class CacheConfiguration {
    @Bean
    @ConditionalOnExpression(value="T(org.springframework.boot.autoconfigure.cache.CacheType).CAFFEINE.name().equalsIgnoreCase(\"${spring.cache.type}\")")
    public CacheManagerCustomizer<CaffeineCacheManager> cacheManagerCustomizer(CacheProperties cacheProperties) {
        return cm -> this.configureCaffeineCacheManager((CaffeineCacheManager)cm, cacheProperties, CacheProvider.EhrBaseCache::name);
    }

    protected void configureCaffeineCacheManager(CaffeineCacheManager cacheManager, CacheProperties cacheProperties, Function<CacheProvider.EhrBaseCache<?, ?>, String> createCacheName) {
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.INTROSPECT_CACHE), Caffeine.newBuilder().build());
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.TEMPLATE_UUID_ID_CACHE), Caffeine.newBuilder().build());
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.TEMPLATE_ID_UUID_CACHE), Caffeine.newBuilder().build());
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.USER_ID_CACHE), CacheConfiguration.configureCache((Caffeine<Object, Object>)Caffeine.newBuilder(), cacheProperties.getUserIdCacheConfig()).build());
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.EXTERNAL_FHIR_TERMINOLOGY_CACHE), CacheConfiguration.configureCache((Caffeine<Object, Object>)Caffeine.newBuilder(), cacheProperties.getExternalFhirTerminologyCacheConfig()).build());
        cacheManager.registerCustomCache(createCacheName.apply(CacheProvider.STORED_QUERY_CACHE), Caffeine.newBuilder().build());
    }

    private static Caffeine<Object, Object> configureCache(Caffeine<Object, Object> caffeine, CacheProperties.CacheConfig cacheConfig) {
        if (cacheConfig.getExpireAfterWrite() != null) {
            caffeine.expireAfterWrite(cacheConfig.getExpireAfterWrite().getDuration(), cacheConfig.getExpireAfterWrite().getUnit());
        }
        if (cacheConfig.getExpireAfterAccess() != null) {
            caffeine.expireAfterAccess(cacheConfig.getExpireAfterAccess().getDuration(), cacheConfig.getExpireAfterAccess().getUnit());
        }
        return caffeine;
    }
}

